/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import java.awt.Color;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.util.RangeHashMap;
import nl.digitalekabeltelevisie.util.Utils;

public class AVCHDPacket
extends TSPacket {
    byte[] tp_extra_header;
    int arrivalTimestamp;

    public AVCHDPacket(byte[] buf, int no, TransportStream ts) {
        super(Arrays.copyOfRange(buf, 4, 192), no, ts);
        this.tp_extra_header = Arrays.copyOf(buf, 4);
        this.arrivalTimestamp = Utils.getInt(this.tp_extra_header, 0, 4, 0x3FFFFFFF);
    }

    public byte[] getTP_extra_header() {
        return this.tp_extra_header;
    }

    public int getCopyPermissionIndicator() {
        return (this.tp_extra_header[0] & 0xC0) >> 6;
    }

    public int getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP(this.buildNodeLabel());
        kvp.addHTMLSource(this, "AVCHD Packet");
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        DefaultMutableTreeNode tpHeaderNode = new DefaultMutableTreeNode(new KVP("tp_extra_header", this.tp_extra_header, null));
        tpHeaderNode.add(new DefaultMutableTreeNode(new KVP("Copy_permission_indicator", this.getCopyPermissionIndicator(), null)));
        tpHeaderNode.add(new DefaultMutableTreeNode(new KVP("Arrival_time_stamp", this.arrivalTimestamp, Utils.printPCRTime(this.arrivalTimestamp))));
        t.add(tpHeaderNode);
        this.addMainPacketDetails(modus, t);
        return t;
    }

    @Override
    public String getHTML() {
        StringBuilder s = new StringBuilder();
        s.append("Packet: ").append(this.packetNo);
        if (this.packetOffset != -1L) {
            s.append("<br>File Offset: ").append(this.packetOffset);
        }
        if (this.transportStream != null) {
            s.append("<br>Time: ").append(this.transportStream.getPacketTime(this.packetNo));
            short pid = this.transportStream.getPacket_pid(this.packetNo);
            s.append("<br>").append(Utils.escapeHtmlBreakLines(this.transportStream.getShortLabel(pid))).append("<br>");
        }
        RangeHashMap<Integer, Color> coloring = new RangeHashMap<Integer, Color>();
        Utils.appendHeader(s, "TP_extra_header: 0x" + Utils.toHexString(this.tp_extra_header, 0, 4), FEC_COLOR);
        coloring.put(0, 4, FEC_COLOR);
        s.append("<br>Copy_permission_indicator: ").append(this.getCopyPermissionIndicator());
        s.append("<br>Arrival_time_stamp: ").append(this.getArrivalTimestamp()).append(" (").append(Utils.printPCRTime(this.getArrivalTimestamp())).append(")");
        s.append("</span><br>");
        this.addBasicPacketDetails(s, 4, coloring);
        byte[] buf = new byte[192];
        System.arraycopy(this.tp_extra_header, 0, buf, 0, 4);
        System.arraycopy(this.buffer, 0, buf, 4, 188);
        s.append("<br><b>Data:</b><br>").append(Utils.getHTMLHexviewColored(buf, 0, 192, coloring));
        return s.toString();
    }

    @Override
    public long getTimeBase() {
        return this.transportStream.getAVCHDPacketTime(this.packetNo);
    }

    @Override
    public String toString() {
        return super.toString() + " , arrivalTimestamp: " + this.arrivalTimestamp;
    }
}

