/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PCR;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.AFDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.AFDescriptorFactory;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.NtpTimeStamp;
import nl.digitalekabeltelevisie.util.Utils;

public class AdaptationField
implements HTMLSource,
TreeNode {
    private static final LookUpList data_field_tag_list = new LookUpList.Builder().add(0, "Reserved").add(1, "Announcement switching data field").add(2, "AU_information data field").add(3, "PVR_assist_information data field").add(4, "TSAP_timeline data field").add(5, 159, "Reserved for future use").add(160, 222, "User defined").add(223, "Registered Private Data").add(224, 255, "User defined").build();
    private static final LookUpList AU_coding_format_list = new LookUpList.Builder().add(0, "Undefined").add(1, "ITU-T Recommendation H.262 / ISO/IEC 13818-2 Video or ISO/IEC 11172-1 constrained parameter video stream").add(2, "H.264/AVC video stream as defined in ITU-T Recommendation H.264 / ISO/IEC 14496-10 Video").add(3, "VC-1 video stream as defined in SMPTE ST 421").add(4, 15, "Reserved").build();
    private static final LookUpList AU_frame_rate_code_list = new LookUpList.Builder().add(0, "Forbidden").add(1, "23,976").add(2, "24").add(3, "25").add(4, "29,97").add(5, "30").add(6, "50").add(7, "59,94").add(8, "60").add(9, 15, "Reserved").build();
    private static Logger logger = Logger.getLogger(AdaptationField.class.getName());
    private int adaptation_field_length = -1;
    private boolean discontinuity_indicator = false;
    private boolean random_access_indicator = false;
    private boolean elementary_stream_priority_indicator = false;
    private boolean PCR_flag = false;
    private boolean OPCR_flag = false;
    private boolean splicing_point_flag = false;
    private boolean transport_private_data_flag = false;
    private boolean adaptation_field_extension_flag = false;
    private PCR program_clock_reference = null;
    private PCR original_program_clock_reference = null;
    private int splice_countdown = 0;
    private int transport_private_data_length = 0;
    private byte[] private_data_byte;
    private List<PrivateDataField> privatedataFields = new ArrayList<PrivateDataField>();
    private int adaptation_field_extension_length;
    private byte[] adaptation_field_extension_byte;
    private boolean ltw_flag;
    private boolean piecewise_rate_flag;
    private boolean seamless_splice_flag;
    private boolean af_descriptor_not_present_flag = true;
    private boolean ltw_valid_flag;
    private int ltw_offset;
    private int piecewise_rate;
    private List<AFDescriptor> afDescriptorList;

    public AdaptationField(byte[] data) {
        this.adaptation_field_length = Utils.getInt(data, 0, 1, 255);
        if (this.adaptation_field_length > 0) {
            this.discontinuity_indicator = Utils.getBitAsBoolean(data[1], 1);
            this.random_access_indicator = Utils.getBitAsBoolean(data[1], 2);
            this.elementary_stream_priority_indicator = Utils.getBitAsBoolean(data[1], 3);
            this.PCR_flag = Utils.getBitAsBoolean(data[1], 4);
            this.OPCR_flag = Utils.getBitAsBoolean(data[1], 5);
            this.splicing_point_flag = Utils.getBitAsBoolean(data[1], 6);
            this.transport_private_data_flag = Utils.getBitAsBoolean(data[1], 7);
            this.adaptation_field_extension_flag = Utils.getBitAsBoolean(data[1], 8);
            int offset = 2;
            if (this.PCR_flag) {
                this.program_clock_reference = AdaptationField.getPCRfromBytes(data, offset);
                offset += 6;
            }
            if (this.OPCR_flag) {
                this.original_program_clock_reference = AdaptationField.getPCRfromBytes(data, offset);
                offset += 6;
            }
            if (this.splicing_point_flag) {
                this.splice_countdown = Utils.getInt(data, offset, 1, 255);
                logger.info("splicing_point_flag is set, splice_countdown=" + this.splice_countdown);
                ++offset;
            }
            if (this.transport_private_data_flag) {
                this.transport_private_data_length = Utils.getInt(data, offset, 1, 255);
                this.private_data_byte = Utils.getBytes(data, ++offset, Math.min(this.transport_private_data_length, this.adaptation_field_length + 1 - offset));
                if (this.private_data_byte.length > 0) {
                    this.privatedataFields = AdaptationField.buildPrivatedataFieldsList(this.private_data_byte);
                }
                offset += this.transport_private_data_length;
            }
            if (this.adaptation_field_extension_flag && data.length > offset + 2) {
                this.adaptation_field_extension_length = Utils.getInt(data, offset, 1, 255);
                this.adaptation_field_extension_byte = Utils.getBytes(data, ++offset, Math.min(this.adaptation_field_extension_length, this.adaptation_field_length + 1 - offset));
                int adaptation_field_extension_offset = 0;
                this.ltw_flag = Utils.getBitAsBoolean(this.adaptation_field_extension_byte[adaptation_field_extension_offset], 1);
                this.piecewise_rate_flag = Utils.getBitAsBoolean(this.adaptation_field_extension_byte[adaptation_field_extension_offset], 2);
                this.seamless_splice_flag = Utils.getBitAsBoolean(this.adaptation_field_extension_byte[adaptation_field_extension_offset], 3);
                this.af_descriptor_not_present_flag = Utils.getBitAsBoolean(this.adaptation_field_extension_byte[adaptation_field_extension_offset], 4);
                ++adaptation_field_extension_offset;
                if (this.ltw_flag) {
                    this.ltw_valid_flag = Utils.getBitAsBoolean(this.adaptation_field_extension_byte[adaptation_field_extension_offset], 1);
                    this.ltw_offset = Utils.getInt(this.adaptation_field_extension_byte, adaptation_field_extension_offset, 2, Short.MAX_VALUE);
                    adaptation_field_extension_offset += 2;
                }
                if (this.piecewise_rate_flag) {
                    this.piecewise_rate = Utils.getInt(this.adaptation_field_extension_byte, adaptation_field_extension_offset, 3, 0x3FFFFF);
                    adaptation_field_extension_offset += 3;
                }
                if (this.seamless_splice_flag) {
                    adaptation_field_extension_offset += 5;
                    logger.info("seamless_splice_flag set, not implemented");
                }
                if (!this.af_descriptor_not_present_flag) {
                    this.afDescriptorList = AFDescriptorFactory.buildDescriptorList(this.adaptation_field_extension_byte, adaptation_field_extension_offset, this.adaptation_field_extension_length - adaptation_field_extension_offset);
                }
            }
        }
    }

    private static List<PrivateDataField> buildPrivatedataFieldsList(byte[] private_data_byte2) {
        PrivateDataField pdf;
        ArrayList<PrivateDataField> result = new ArrayList<PrivateDataField>();
        for (int offset = 0; offset < private_data_byte2.length; offset += pdf.getData_field_length() + 2) {
            pdf = new PrivateDataField(private_data_byte2, offset);
            result.add(pdf);
        }
        return result;
    }

    private static PCR getPCRfromBytes(byte[] array, int offset) {
        long pcr = Byte.toUnsignedLong(array[offset]) << 25;
        pcr |= Byte.toUnsignedLong(array[offset + 1]) << 17;
        pcr |= Byte.toUnsignedLong(array[offset + 2]) << 9;
        pcr |= Byte.toUnsignedLong(array[offset + 3]) << 1;
        long reserved = (0x7EL & Byte.toUnsignedLong(array[offset + 4])) >>> 1;
        long pcr_extension = (1L & Byte.toUnsignedLong(array[offset + 4])) << 8;
        return new PCR(pcr |= (0x80L & Byte.toUnsignedLong(array[offset + 4])) >>> 7, reserved, pcr_extension |= Byte.toUnsignedLong(array[offset + 5]));
    }

    public boolean isAdaptation_field_extension_flag() {
        return this.adaptation_field_extension_flag;
    }

    public void setAdaptation_field_extension_flag(boolean adaptation_field_extension_flag) {
        this.adaptation_field_extension_flag = adaptation_field_extension_flag;
    }

    public int getAdaptation_field_length() {
        return this.adaptation_field_length;
    }

    public void setAdaptation_field_length(int adaptation_field_length) {
        this.adaptation_field_length = adaptation_field_length;
    }

    public boolean isDiscontinuity_indicator() {
        return this.discontinuity_indicator;
    }

    public void setDiscontinuity_indicator(boolean discontinuity_indicator) {
        this.discontinuity_indicator = discontinuity_indicator;
    }

    public boolean isElementary_stream_priority_indicator() {
        return this.elementary_stream_priority_indicator;
    }

    public void setElementary_stream_priority_indicator(boolean elementary_stream_priority_indicator) {
        this.elementary_stream_priority_indicator = elementary_stream_priority_indicator;
    }

    public boolean isOPCR_flag() {
        return this.OPCR_flag;
    }

    public void setOPCR_flag(boolean opcr_flag) {
        this.OPCR_flag = opcr_flag;
    }

    public PCR getOriginal_program_clock_reference() {
        return this.original_program_clock_reference;
    }

    public void setOriginal_program_clock_reference(PCR original_program_clock_reference_base) {
        this.original_program_clock_reference = original_program_clock_reference_base;
    }

    public boolean isPCR_flag() {
        return this.PCR_flag;
    }

    public void setPCR_flag(boolean pcr_flag) {
        this.PCR_flag = pcr_flag;
    }

    public PCR getProgram_clock_reference() {
        return this.program_clock_reference;
    }

    public void setProgram_clock_reference(PCR program_clock_reference_base) {
        this.program_clock_reference = program_clock_reference_base;
    }

    public boolean isRandom_access_indicator() {
        return this.random_access_indicator;
    }

    public void setRandom_access_indicator(boolean random_access_indicator) {
        this.random_access_indicator = random_access_indicator;
    }

    public boolean isSplicing_point_flag() {
        return this.splicing_point_flag;
    }

    public void setSplicing_point_flag(boolean splicing_point_flag) {
        this.splicing_point_flag = splicing_point_flag;
    }

    public boolean isTransport_private_data_flag() {
        return this.transport_private_data_flag;
    }

    public void setTransport_private_data_flag(boolean transport_private_data_flag) {
        this.transport_private_data_flag = transport_private_data_flag;
    }

    @Override
    public String getHTML() {
        DefaultMutableTreeNode treeNode;
        StringBuilder s = new StringBuilder();
        s.append("<br>adaptation_field_length: ").append(Utils.getHexAndDecimalFormattedString(this.getAdaptation_field_length()));
        if (this.getAdaptation_field_length() == 0) {
            return s.toString();
        }
        s.append("<br>discontinuity_indicator: ").append(Utils.getBooleanAsInt(this.discontinuity_indicator));
        s.append("<br>random_access_indicator: ").append(Utils.getBooleanAsInt(this.random_access_indicator));
        s.append("<br>elementary_stream_priority_indicator: ").append(Utils.getBooleanAsInt(this.elementary_stream_priority_indicator));
        s.append("<br>PCR_flag: ").append(Utils.getBooleanAsInt(this.PCR_flag));
        s.append("<br>OPCR_flag: ").append(Utils.getBooleanAsInt(this.OPCR_flag));
        s.append("<br>splicing_point_flag: ").append(Utils.getBooleanAsInt(this.splicing_point_flag));
        s.append("<br>transport_private_data_flag: ").append(Utils.getBooleanAsInt(this.transport_private_data_flag));
        s.append("<br>adaptation_field_extension_flag: ").append(Utils.getBooleanAsInt(this.adaptation_field_extension_flag));
        if (this.PCR_flag) {
            s.append("<br>PCR: [base] ").append(Utils.getHexAndDecimalFormattedString(this.program_clock_reference.getProgram_clock_reference_base())).append(" : [extension] ").append(Utils.getHexAndDecimalFormattedString(this.program_clock_reference.getProgram_clock_reference_extension())).append(" (").append(Utils.printPCRTime(this.program_clock_reference.getProgram_clock_reference())).append(")");
        }
        if (this.OPCR_flag) {
            s.append("<br>OPCR: ").append(Utils.getHexAndDecimalFormattedString(this.original_program_clock_reference.getProgram_clock_reference())).append(" (").append(Utils.printPCRTime(this.original_program_clock_reference.getProgram_clock_reference())).append(")");
        }
        if (this.splicing_point_flag) {
            s.append("<br>splice_countdown: ").append(Utils.getHexAndDecimalFormattedString(this.splice_countdown));
        }
        if (this.transport_private_data_flag) {
            s.append("<br>transport_private_data_length: ").append(Utils.getHexAndDecimalFormattedString(this.transport_private_data_length));
            s.append("<br>private_data_byte: ").append("0x").append(Utils.toHexString(this.private_data_byte)).append(" \"").append(Utils.toSafeString(this.private_data_byte)).append("\"");
            for (PrivateDataField privateDataField : this.privatedataFields) {
                treeNode = privateDataField.getJTreeNode(0);
                s.append("<br><br><b>").append(AdaptationField.getDataFieldTagString(privateDataField.getData_field_tag())).append("</b>");
                s.append("<br>").append((CharSequence)Utils.getChildrenAsHTML(treeNode));
            }
        }
        if (this.adaptation_field_extension_flag) {
            s.append("<br>adaptation_field_extension_length: ").append(Utils.getHexAndDecimalFormattedString(this.adaptation_field_extension_length));
            s.append("<br>adaptation_field_extension_byte: ").append("0x").append(Utils.toHexString(this.adaptation_field_extension_byte)).append(" \"").append(Utils.toSafeString(this.adaptation_field_extension_byte)).append("\"");
            s.append("<br>ltw_flag: ").append(Utils.getBooleanAsInt(this.ltw_flag));
            s.append("<br>piecewise_rate_flag: ").append(Utils.getBooleanAsInt(this.piecewise_rate_flag));
            s.append("<br>seamless_splice_flag: ").append(Utils.getBooleanAsInt(this.seamless_splice_flag));
            s.append("<br>af_descriptor_not_present_flag: ").append(Utils.getBooleanAsInt(this.af_descriptor_not_present_flag));
            if (this.ltw_flag) {
                s.append("<br>ltw_valid_flag: ").append(Utils.getBooleanAsInt(this.ltw_valid_flag));
                s.append("<br>ltw_offset: ").append(Utils.getHexAndDecimalFormattedString(this.ltw_offset));
            }
            if (this.piecewise_rate_flag) {
                s.append("<br>piecewise_rate: ").append(Utils.getHexAndDecimalFormattedString(this.piecewise_rate));
            }
            if (this.seamless_splice_flag) {
                s.append("<br>seamless_splice_flag: <span style=\"color:red\">Not implemented, please report!</span>");
                logger.info("seamless_splice_flag: Not implemented, please report!");
            }
            if (!this.af_descriptor_not_present_flag) {
                for (Descriptor descriptor : this.afDescriptorList) {
                    treeNode = descriptor.getJTreeNode(0);
                    s.append("<br><br><b>").append(descriptor.getDescriptorname()).append("</b>");
                    s.append("<br>").append((CharSequence)Utils.getChildrenAsHTML(treeNode));
                }
            }
        }
        return s.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("adaptation_field"));
        t.add(new DefaultMutableTreeNode(new KVP("adaptation_field_length", this.getAdaptation_field_length(), null)));
        if (this.getAdaptation_field_length() == 0) {
            return t;
        }
        t.add(new DefaultMutableTreeNode(new KVP("discontinuity_indicator", Utils.getBooleanAsInt(this.discontinuity_indicator), null)));
        t.add(new DefaultMutableTreeNode(new KVP("random_access_indicator", Utils.getBooleanAsInt(this.random_access_indicator), null)));
        t.add(new DefaultMutableTreeNode(new KVP("elementary_stream_priority_indicator", Utils.getBooleanAsInt(this.elementary_stream_priority_indicator), null)));
        t.add(new DefaultMutableTreeNode(new KVP("PCR_flag", Utils.getBooleanAsInt(this.PCR_flag), null)));
        t.add(new DefaultMutableTreeNode(new KVP("OPCR_flag", Utils.getBooleanAsInt(this.OPCR_flag), null)));
        t.add(new DefaultMutableTreeNode(new KVP("splicing_point_flag", Utils.getBooleanAsInt(this.splicing_point_flag), null)));
        t.add(new DefaultMutableTreeNode(new KVP("transport_private_data_flag", Utils.getBooleanAsInt(this.transport_private_data_flag), null)));
        t.add(new DefaultMutableTreeNode(new KVP("adaptation_field_extension_flag", Utils.getBooleanAsInt(this.adaptation_field_extension_flag), null)));
        if (this.PCR_flag) {
            t.add(this.program_clock_reference.getJTreeNode(modus, "PCR"));
        }
        if (this.OPCR_flag) {
            t.add(this.original_program_clock_reference.getJTreeNode(modus, "OPCR"));
        }
        if (this.splicing_point_flag) {
            t.add(new DefaultMutableTreeNode(new KVP("splice_countdown", this.splice_countdown, null)));
        }
        if (this.transport_private_data_flag) {
            t.add(new DefaultMutableTreeNode(new KVP("transport_private_data_length", this.transport_private_data_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.private_data_byte, null)));
            Utils.addListJTree(t, this.privatedataFields, modus, "Private Data Fields");
        }
        if (this.adaptation_field_extension_flag) {
            t.add(new DefaultMutableTreeNode(new KVP("adaptation_field_extension_length", this.adaptation_field_extension_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("adaptation_field_extension_byte", this.adaptation_field_extension_byte, null)));
            t.add(new DefaultMutableTreeNode(new KVP("ltw_flag", Utils.getBooleanAsInt(this.ltw_flag), null)));
            t.add(new DefaultMutableTreeNode(new KVP("piecewise_rate_flag", Utils.getBooleanAsInt(this.piecewise_rate_flag), null)));
            t.add(new DefaultMutableTreeNode(new KVP("seamless_splice_flag", Utils.getBooleanAsInt(this.seamless_splice_flag), null)));
            t.add(new DefaultMutableTreeNode(new KVP("af_descriptor_not_present_flag", Utils.getBooleanAsInt(this.af_descriptor_not_present_flag), null)));
            if (this.ltw_flag) {
                t.add(new DefaultMutableTreeNode(new KVP("ltw_valid_flag", Utils.getBooleanAsInt(this.ltw_valid_flag), null)));
                t.add(new DefaultMutableTreeNode(new KVP("ltw_offset", this.ltw_offset, null)));
            }
            if (this.piecewise_rate_flag) {
                t.add(new DefaultMutableTreeNode(new KVP("piecewise_rate", this.piecewise_rate, null)));
            }
            if (this.seamless_splice_flag) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("seamless_splice_flag")));
            }
            if (!this.af_descriptor_not_present_flag) {
                Utils.addListJTree(t, this.afDescriptorList, modus, "af_descriptors");
            }
        }
        return t;
    }

    private static String getDataFieldTagString(int data_field_tag2) {
        return data_field_tag_list.get(data_field_tag2);
    }

    private static String getAU_coding_formatString(int AU_coding_format) {
        return AU_coding_format_list.get(AU_coding_format);
    }

    public static LookUpList getData_field_tag_list() {
        return data_field_tag_list;
    }

    public static LookUpList getAU_coding_format_list() {
        return AU_coding_format_list;
    }

    public static LookUpList getAU_frame_rate_code_list() {
        return AU_frame_rate_code_list;
    }

    public int getSplice_countdown() {
        return this.splice_countdown;
    }

    public int getTransport_private_data_length() {
        return this.transport_private_data_length;
    }

    public byte[] getPrivate_data_byte() {
        return this.private_data_byte;
    }

    public List<PrivateDataField> getPrivatedataFields() {
        return this.privatedataFields;
    }

    public int getAdaptation_field_extension_length() {
        return this.adaptation_field_extension_length;
    }

    public byte[] getAdaptation_field_extension_byte() {
        return this.adaptation_field_extension_byte;
    }

    public boolean isLtw_flag() {
        return this.ltw_flag;
    }

    public boolean isPiecewise_rate_flag() {
        return this.piecewise_rate_flag;
    }

    public boolean isSeamless_splice_flag() {
        return this.seamless_splice_flag;
    }

    public boolean isAf_descriptor_not_present_flag() {
        return this.af_descriptor_not_present_flag;
    }

    public boolean isLtw_valid_flag() {
        return this.ltw_valid_flag;
    }

    public int getLtw_offset() {
        return this.ltw_offset;
    }

    public int getPiecewise_rate() {
        return this.piecewise_rate;
    }

    public List<AFDescriptor> getAfDescriptorList() {
        return this.afDescriptorList;
    }

    public static class PrivateDataField
    implements TreeNode {
        private int data_field_tag;
        private int data_field_length;
        private final byte[] data_byte;
        private int announcement_switching_flag_field;
        private int AU_coding_format;
        private int AU_coding_type_information;
        private int AU_ref_pic_idc;
        private int AU_pic_struct;
        private int AU_PTS_present_flag;
        private int AU_profile_info_present_flag;
        private int AU_stream_info_present_flag;
        private int AU_trick_mode_info_present_flag;
        private long AU_PTS_32;
        private int reserved;
        private int AU_frame_rate_code;
        private int AU_profile;
        private int AU_constraint_set0_flag;
        private int AU_constraint_set1_flag;
        private int AU_constraint_set2_flag;
        private int AU_AVC_compatible_flags;
        private int AU_level;
        private int AU_max_I_picture_size;
        private int AU_nominal_I_period;
        private int AU_max_I_period;
        private int reserved2;
        private int AU_Pulldown_info_present_flag;
        private int AU_reserved_zero;
        private int AU_flags_extension_1;
        private boolean extraDataPresent = false;
        private int AU_reserved;
        private byte[] AU_reserved_byte;
        public byte[] formatIdentifier;
        public int EBP_fragment_flag;
        public int EBP_segment_flag;
        public int EBP_SAP_flag;
        private int EBP_grouping_flag;
        private int EBP_time_flag;
        private int EBP_concealment_flag;
        private int EBP_extension_flag;
        private int EBP_ext_partition_flag;
        private int EBP_SAP_type;
        private int reserved3;
        private int EBP_grouping_ext_flag;
        private List<Integer> groupingList = new ArrayList<Integer>();
        private long EBP_acquisition_time;
        private int EBP_ext_partitions;

        PrivateDataField(byte[] private_data_byte, int offset) {
            this.data_byte = private_data_byte;
            this.data_field_tag = Utils.getInt(private_data_byte, offset, 1, 255);
            this.data_field_length = Utils.getInt(private_data_byte, offset + 1, 1, 255);
            if (this.data_field_tag == 1) {
                this.buildAnnouncementSwitchingData(private_data_byte, offset);
            } else if (this.data_field_tag == 2) {
                this.buildAU_information(private_data_byte, offset);
            } else if (this.data_field_tag == 223) {
                this.buildEBP_info(private_data_byte, offset);
            } else {
                logger.warning("data_field_tag==" + this.data_field_tag + " not implemented");
            }
        }

        public void buildAU_information(byte[] private_data_byte, int offset) {
            if (this.data_field_length > 0) {
                this.AU_coding_format = Utils.getInt(private_data_byte, offset + 2, 1, 240) >> 4;
                this.AU_coding_type_information = Utils.getInt(private_data_byte, offset + 2, 1, 15);
                if (this.data_field_length > 1) {
                    this.AU_ref_pic_idc = Utils.getInt(private_data_byte, offset + 3, 1, 192) >> 6;
                    this.AU_pic_struct = Utils.getInt(private_data_byte, offset + 3, 1, 48) >> 4;
                    this.AU_PTS_present_flag = Utils.getInt(private_data_byte, offset + 3, 1, 8) >> 3;
                    this.AU_profile_info_present_flag = Utils.getInt(private_data_byte, offset + 3, 1, 4) >> 2;
                    this.AU_stream_info_present_flag = Utils.getInt(private_data_byte, offset + 3, 1, 2) >> 1;
                    this.AU_trick_mode_info_present_flag = Utils.getInt(private_data_byte, offset + 3, 1, 1);
                    int localOffset = offset + 4;
                    if (this.AU_PTS_present_flag == 1) {
                        this.AU_PTS_32 = Utils.getLong(private_data_byte, localOffset, 4, -1L);
                        localOffset += 4;
                    }
                    if (this.AU_stream_info_present_flag == 1) {
                        this.reserved = Utils.getInt(private_data_byte, localOffset, 1, 240) >> 4;
                        this.AU_frame_rate_code = Utils.getInt(private_data_byte, localOffset, 1, 15);
                        ++localOffset;
                    }
                    if (this.AU_profile_info_present_flag == 1) {
                        this.AU_profile = Utils.getInt(private_data_byte, localOffset, 1, 255);
                        this.AU_constraint_set0_flag = Utils.getInt(private_data_byte, ++localOffset, 1, 128) >> 7;
                        this.AU_constraint_set1_flag = Utils.getInt(private_data_byte, localOffset, 1, 64) >> 6;
                        this.AU_constraint_set2_flag = Utils.getInt(private_data_byte, localOffset, 1, 32) >> 5;
                        this.AU_AVC_compatible_flags = Utils.getInt(private_data_byte, localOffset, 1, 31);
                        this.AU_level = Utils.getInt(private_data_byte, ++localOffset, 1, 255);
                        ++localOffset;
                    }
                    if (this.AU_trick_mode_info_present_flag == 1) {
                        this.AU_max_I_picture_size = Utils.getInt(private_data_byte, localOffset, 2, 65520) >> 4;
                        this.AU_nominal_I_period = Utils.getInt(private_data_byte, ++localOffset, 2, 4080) >> 4;
                        this.AU_max_I_period = Utils.getInt(private_data_byte, ++localOffset, 2, 4080) >> 4;
                        this.reserved2 = Utils.getInt(private_data_byte, ++localOffset, 1, 15);
                        ++localOffset;
                    }
                    if (localOffset - 2 < this.data_field_length) {
                        this.extraDataPresent = true;
                        this.AU_Pulldown_info_present_flag = Utils.getInt(private_data_byte, localOffset, 1, 128) >> 7;
                        this.AU_reserved_zero = Utils.getInt(private_data_byte, localOffset, 1, 126) >> 1;
                        this.AU_flags_extension_1 = Utils.getInt(private_data_byte, localOffset, 1, 1);
                        ++localOffset;
                        if (this.AU_flags_extension_1 == 1) {
                            this.AU_reserved = Utils.getInt(private_data_byte, localOffset, 1, 255);
                            ++localOffset;
                        }
                    }
                    if (localOffset - 2 < this.data_field_length) {
                        this.AU_reserved_byte = Utils.getBytes(private_data_byte, localOffset, this.data_field_length - localOffset + 2);
                    }
                }
            }
        }

        public void buildAnnouncementSwitchingData(byte[] private_data_byte, int offset) {
            this.announcement_switching_flag_field = Utils.getInt(private_data_byte, offset + 2, 2, 65535);
        }

        public void buildEBP_info(byte[] private_data_byte, int offset) {
            this.formatIdentifier = Utils.getBytes(private_data_byte, offset + 2, 4);
            this.EBP_fragment_flag = Utils.getInt(private_data_byte, offset + 6, 1, 128) >> 7;
            this.EBP_segment_flag = Utils.getInt(private_data_byte, offset + 6, 1, 64) >> 6;
            this.EBP_SAP_flag = Utils.getInt(private_data_byte, offset + 6, 1, 32) >> 5;
            this.EBP_grouping_flag = Utils.getInt(private_data_byte, offset + 6, 1, 16) >> 4;
            this.EBP_time_flag = Utils.getInt(private_data_byte, offset + 6, 1, 8) >> 3;
            this.EBP_concealment_flag = Utils.getInt(private_data_byte, offset + 6, 1, 4) >> 2;
            this.reserved = Utils.getInt(private_data_byte, offset + 6, 1, 2) >> 1;
            this.EBP_extension_flag = Utils.getInt(private_data_byte, offset + 6, 1, 1);
            int localOffset = offset + 7;
            if (this.EBP_extension_flag == 1) {
                this.EBP_ext_partition_flag = Utils.getInt(private_data_byte, localOffset, 1, 128) >> 7;
                this.reserved2 = Utils.getInt(private_data_byte, localOffset, 1, 127);
                ++localOffset;
            }
            if (this.EBP_SAP_flag == 1) {
                this.EBP_SAP_type = Utils.getInt(private_data_byte, localOffset, 1, 224) >> 5;
                this.reserved3 = Utils.getInt(private_data_byte, localOffset, 1, 31);
                ++localOffset;
            }
            if (this.EBP_grouping_flag == 1) {
                int grouping = Utils.getInt(private_data_byte, localOffset++, 1, 255);
                this.groupingList.add(grouping);
                this.EBP_grouping_ext_flag = (grouping & 0x80) >> 7;
                while (this.EBP_grouping_ext_flag == 1) {
                    grouping = Utils.getInt(private_data_byte, localOffset++, 1, 255);
                    this.EBP_grouping_ext_flag = (grouping & 0x80) >> 7;
                    this.groupingList.add(grouping);
                }
            }
            if (this.EBP_time_flag == 1) {
                this.EBP_acquisition_time = Utils.getLong(private_data_byte, localOffset, 8, -1L);
                localOffset += 8;
            }
            if (this.EBP_ext_partition_flag == 1) {
                this.EBP_ext_partitions = Utils.getInt(private_data_byte, localOffset++, 1, 255);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Private Data Field (" + AdaptationField.getDataFieldTagString(this.data_field_tag) + ")"));
            t.add(new DefaultMutableTreeNode(new KVP("data_field_tag", this.data_field_tag, AdaptationField.getDataFieldTagString(this.data_field_tag))));
            t.add(new DefaultMutableTreeNode(new KVP("data_field_length", this.data_field_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("data_field_data", this.data_byte, 2, this.data_field_length, null)));
            if (this.data_field_tag == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("announcement_switching_flag_field", this.announcement_switching_flag_field, null)));
            } else if (this.data_field_tag == 2) {
                if (this.data_field_length > 0) {
                    t.add(new DefaultMutableTreeNode(new KVP("AU_coding_format", this.AU_coding_format, AdaptationField.getAU_coding_formatString(this.AU_coding_format))));
                    t.add(new DefaultMutableTreeNode(new KVP("AU_coding_type_information", this.AU_coding_type_information, null)));
                    if (this.data_field_length > 1) {
                        t.add(new DefaultMutableTreeNode(new KVP("AU_ref_pic_idc", this.AU_ref_pic_idc, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("AU_pic_struct", this.AU_pic_struct, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("AU_PTS_present_flag", this.AU_PTS_present_flag, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("AU_profile_info_present_flag", this.AU_profile_info_present_flag, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("AU_stream_info_present_flag", this.AU_stream_info_present_flag, null)));
                        t.add(new DefaultMutableTreeNode(new KVP("AU_trick_mode_info_present_flag", this.AU_trick_mode_info_present_flag, null)));
                        if (this.AU_PTS_present_flag == 1) {
                            t.add(new DefaultMutableTreeNode(new KVP("AU_PTS_32", this.AU_PTS_32, null)));
                        }
                        if (this.AU_stream_info_present_flag == 1) {
                            t.add(new DefaultMutableTreeNode(new KVP("Reserved", this.reserved, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_frame_rate_code", this.AU_frame_rate_code, PrivateDataField.getAUFrameRateCodeString(this.AU_frame_rate_code))));
                        }
                        if (this.AU_profile_info_present_flag == 1) {
                            t.add(new DefaultMutableTreeNode(new KVP("AU_profile", this.AU_profile, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_constraint_set0_flag", this.AU_constraint_set0_flag, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_constraint_set1_flag", this.AU_constraint_set1_flag, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_constraint_set2_flag", this.AU_constraint_set2_flag, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_AVC_compatible_flags", this.AU_AVC_compatible_flags, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_level", this.AU_level, null)));
                        }
                        if (this.AU_trick_mode_info_present_flag == 1) {
                            t.add(new DefaultMutableTreeNode(new KVP("AU_max_I_picture_size", this.AU_max_I_picture_size, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_nominal_I_period", this.AU_nominal_I_period, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_max_I_period", this.AU_max_I_period, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("Reserved", this.reserved2, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_level", this.AU_level, null)));
                        }
                        if (this.extraDataPresent) {
                            t.add(new DefaultMutableTreeNode(new KVP("AU_Pulldown_info_present_flag", this.AU_Pulldown_info_present_flag, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_reserved_zero", this.AU_reserved_zero, null)));
                            t.add(new DefaultMutableTreeNode(new KVP("AU_flags_extension_1", this.AU_flags_extension_1, null)));
                            if (this.AU_flags_extension_1 == 1) {
                                t.add(new DefaultMutableTreeNode(new KVP("AU_reserved", this.AU_reserved, null)));
                            }
                        }
                        if (this.AU_reserved_byte != null) {
                            t.add(new DefaultMutableTreeNode(new KVP("AU_reserved_byte", this.AU_reserved_byte, null)));
                        }
                    }
                }
            } else if (this.data_field_tag == 223) {
                t.add(new DefaultMutableTreeNode(new KVP("format_identifier", this.formatIdentifier, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_fragment_flag", this.EBP_fragment_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_segment_flag", this.EBP_segment_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_SAP_flag", this.EBP_SAP_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_grouping_flag", this.EBP_grouping_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_time_flag", this.EBP_time_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_concealment_flag", this.EBP_concealment_flag, null)));
                t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
                t.add(new DefaultMutableTreeNode(new KVP("EBP_extension_flag", this.EBP_extension_flag, null)));
                if (this.EBP_extension_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("EBP_ext_partition_flag", this.EBP_ext_partition_flag, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
                }
                if (this.EBP_SAP_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("EBP_SAP_type", this.EBP_SAP_type, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved3, null)));
                }
                if (this.EBP_grouping_flag == 1) {
                    DefaultMutableTreeNode list = new DefaultMutableTreeNode(new KVP("GroupingList"));
                    for (Integer grouping : this.groupingList) {
                        this.EBP_grouping_ext_flag = (grouping & 0x80) >> 7;
                        int EBP_grouping_id = grouping & 0x7F;
                        list.add(new DefaultMutableTreeNode(new KVP("EBP_grouping_ext_flag", this.EBP_grouping_ext_flag, null)));
                        list.add(new DefaultMutableTreeNode(new KVP("EBP_grouping_id", EBP_grouping_id, null)));
                    }
                    t.add(list);
                }
                if (this.EBP_time_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("EBP_acquisition_time", this.EBP_acquisition_time, new NtpTimeStamp(this.EBP_acquisition_time).toUTCString())));
                }
                if (this.EBP_ext_partition_flag == 1) {
                    t.add(new DefaultMutableTreeNode(new KVP("EBP_ext_partitions", this.EBP_ext_partitions, null)));
                }
            } else {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("data_field_tag==" + this.data_field_tag)));
            }
            return t;
        }

        private static String getAUFrameRateCodeString(int aU_frame_rate_code2) {
            return AU_frame_rate_code_list.get(aU_frame_rate_code2);
        }

        public int getData_field_tag() {
            return this.data_field_tag;
        }

        public void setData_field_tag(int data_field_tag) {
            this.data_field_tag = data_field_tag;
        }

        public int getData_field_length() {
            return this.data_field_length;
        }

        public void setData_field_length(int data_field_length) {
            this.data_field_length = data_field_length;
        }

        public byte[] getData_byte() {
            return this.data_byte;
        }

        public int getAnnouncement_switching_flag_field() {
            return this.announcement_switching_flag_field;
        }

        public int getAU_coding_format() {
            return this.AU_coding_format;
        }

        public int getAU_coding_type_information() {
            return this.AU_coding_type_information;
        }

        public int getAU_ref_pic_idc() {
            return this.AU_ref_pic_idc;
        }

        public int getAU_pic_struct() {
            return this.AU_pic_struct;
        }

        public int getAU_PTS_present_flag() {
            return this.AU_PTS_present_flag;
        }

        public int getAU_profile_info_present_flag() {
            return this.AU_profile_info_present_flag;
        }

        public int getAU_stream_info_present_flag() {
            return this.AU_stream_info_present_flag;
        }

        public int getAU_trick_mode_info_present_flag() {
            return this.AU_trick_mode_info_present_flag;
        }

        public long getAU_PTS_32() {
            return this.AU_PTS_32;
        }

        public int getReserved() {
            return this.reserved;
        }

        public int getAU_frame_rate_code() {
            return this.AU_frame_rate_code;
        }

        public int getAU_profile() {
            return this.AU_profile;
        }

        public int getAU_constraint_set0_flag() {
            return this.AU_constraint_set0_flag;
        }

        public int getAU_constraint_set1_flag() {
            return this.AU_constraint_set1_flag;
        }

        public int getAU_constraint_set2_flag() {
            return this.AU_constraint_set2_flag;
        }

        public int getAU_AVC_compatible_flags() {
            return this.AU_AVC_compatible_flags;
        }

        public int getAU_level() {
            return this.AU_level;
        }

        public int getAU_max_I_picture_size() {
            return this.AU_max_I_picture_size;
        }

        public int getAU_nominal_I_period() {
            return this.AU_nominal_I_period;
        }

        public int getAU_max_I_period() {
            return this.AU_max_I_period;
        }

        public int getReserved2() {
            return this.reserved2;
        }

        public int getAU_Pulldown_info_present_flag() {
            return this.AU_Pulldown_info_present_flag;
        }

        public int getAU_reserved_zero() {
            return this.AU_reserved_zero;
        }

        public int getAU_flags_extension_1() {
            return this.AU_flags_extension_1;
        }

        public boolean isExtraDataPresent() {
            return this.extraDataPresent;
        }

        public int getAU_reserved() {
            return this.AU_reserved;
        }

        public byte[] getAU_reserved_byte() {
            return this.AU_reserved_byte;
        }
    }
}

