/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.AdaptationField;
import nl.digitalekabeltelevisie.data.mpeg.PCR;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.TemiTimeStamp;
import nl.digitalekabeltelevisie.data.mpeg.TimeStamp;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.AFDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.TimelineDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.PesHeader;
import nl.digitalekabeltelevisie.data.mpeg.psi.GeneralPSITable;
import nl.digitalekabeltelevisie.data.mpeg.psi.MegaFrameInitializationPacket;
import nl.digitalekabeltelevisie.util.JTreeLazyList;
import nl.digitalekabeltelevisie.util.PIDPacketGetter;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;

public class PID
implements TreeNode {
    private static final Logger logger = Logger.getLogger(PID.class.getName());
    public static final int PES = 1;
    public static final int PSI = 2;
    private int type = 0;
    private boolean scrambled = false;
    private long bitRate = -1L;
    private GeneralPSITable psi;
    private GeneralPidHandler generalPidHandler = null;
    private int packets = 0;
    private int dup_packets = 0;
    private long continuity_errors_count = 0L;
    private List<ContinuityError> continuityErrors = new ArrayList<ContinuityError>();
    private int last_continuity_counter = -1;
    private int pid = -1;
    private int last_packet_no = -1;
    private TSPacket last_packet = null;
    private int dup_found = 0;
    private PCR lastPCR;
    private PCR firstPCR;
    private int lastPCRpacketNo = -1;
    private int firstPCRpacketNo = -1;
    private long pcr_count = -1L;
    protected TransportStream parentTransportStream = null;
    private final GatherPIDData gatherer = new GatherPIDData();
    private final ArrayList<TimeStamp> pcrList = new ArrayList();
    private final ArrayList<TimeStamp> ptsList = new ArrayList();
    private final ArrayList<TimeStamp> dtsList = new ArrayList();
    private final SortedMap<Integer, ArrayList<TemiTimeStamp>> temiMap = new TreeMap<Integer, ArrayList<TemiTimeStamp>>();
    private List<TemiTimeStamp> temiBuffer = new ArrayList<TemiTimeStamp>();
    private final LabelMaker labelMaker = new LabelMaker();

    public PID(int pid, TransportStream ts) {
        this.pid = pid;
        this.parentTransportStream = ts;
        this.psi = new GeneralPSITable(ts.getPsi());
    }

    public void updatePacket(TSPacket packet) {
        if (!packet.isTransportErrorIndicator()) {
            this.updateNonErrorPacket(packet);
        }
        ++this.packets;
    }

    public Long getPacketPcrTime(long packetNo) {
        if (this.firstPCR != null && this.lastPCR != null && !this.firstPCR.equals(this.lastPCR)) {
            long diffPCR = this.lastPCR.getProgram_clock_reference() - this.firstPCR.getProgram_clock_reference();
            long diffPackets = this.lastPCRpacketNo - this.firstPCRpacketNo;
            return this.firstPCR.getProgram_clock_reference() + (packetNo - (long)this.firstPCRpacketNo) * diffPCR / diffPackets;
        }
        return null;
    }

    private void updateNonErrorPacket(TSPacket packet) {
        if (this.pid == 21) {
            this.updateMegaFrameInitializationPacket(packet);
        } else {
            AdaptationField adaptationField = null;
            if (packet.hasAdaptationField()) {
                adaptationField = this.handleAdaptationField(packet);
            }
            if (this.isNormalPacket(packet, adaptationField)) {
                PesHeader pesHeader;
                this.handleNormalPacket(packet);
                if (packet.hasAdaptationField()) {
                    this.processTEMI(adaptationField, this.temiMap, packet.getPacketNo());
                }
                if (packet.isPayloadUnitStartIndicator() && this.type != 2 && (pesHeader = packet.getPesHeader()) != null && pesHeader.hasPTS()) {
                    long pts = pesHeader.getPts();
                    for (TemiTimeStamp temi : this.temiBuffer) {
                        temi.setPts(pts);
                        ArrayList tl = this.temiMap.computeIfAbsent(temi.getTimeline_id(), k -> new ArrayList());
                        tl.add(temi);
                    }
                    this.temiBuffer.clear();
                }
            } else if (packet.hasPayload() && this.last_continuity_counter == packet.getContinuityCounter()) {
                this.handleDuplicatePacket(packet);
            } else if (packet.hasPayload() || this.last_continuity_counter != packet.getContinuityCounter()) {
                this.handleContinuityError(packet);
            }
        }
    }

    private boolean isNormalPacket(TSPacket packet, AdaptationField adaptationField) {
        return this.last_continuity_counter == -1 || this.pid == 8191 || (this.last_continuity_counter + 1) % 16 == packet.getContinuityCounter() && packet.hasPayload() || adaptationField != null && adaptationField.isDiscontinuity_indicator();
    }

    private void handleDuplicatePacket(TSPacket packet) {
        if (this.dup_found >= 1) {
            ++this.dup_found;
            logger.warning("multiple dup packet (" + this.dup_found + "th total), illegal, PID=" + this.pid + ", last=" + this.last_continuity_counter + ", new=" + packet.getContinuityCounter() + ", last_no=" + this.last_packet_no + ", packet_no=" + packet.getPacketNo());
        } else {
            this.dup_found = 1;
            ++this.dup_packets;
        }
    }

    private void handleNormalPacket(TSPacket packet) {
        this.last_continuity_counter = packet.getContinuityCounter();
        this.last_packet_no = packet.getPacketNo();
        this.last_packet = packet;
        this.dup_found = 0;
        if (packet.getTransportScramblingControl() == 0) {
            this.gatherer.processPayload(packet, this.parentTransportStream, this);
        } else {
            this.scrambled = true;
        }
    }

    private AdaptationField handleAdaptationField(TSPacket packet) {
        AdaptationField adaptationField;
        try {
            adaptationField = packet.getAdaptationField();
            this.processAdaptationField(adaptationField, packet.getPacketNo(), packet.getTimeBase());
        }
        catch (RuntimeException re) {
            logger.log(Level.WARNING, "Error getting adaptationField", re);
            adaptationField = null;
        }
        return adaptationField;
    }

    private void handleContinuityError(TSPacket packet) {
        this.continuityErrors.add(new ContinuityError(this.last_packet_no, this.last_continuity_counter, packet.getPacketNo(), packet.getContinuityCounter()));
        this.last_continuity_counter = packet.getContinuityCounter();
        this.last_packet_no = packet.getPacketNo();
        this.last_packet = packet;
        ++this.continuity_errors_count;
        this.gatherer.reset();
        this.gatherer.processPayload(packet, this.parentTransportStream, this);
    }

    private void updateMegaFrameInitializationPacket(TSPacket packet) {
        if (packet.getData() != null && packet.getData().length >= 14) {
            try {
                MegaFrameInitializationPacket mip = new MegaFrameInitializationPacket(packet);
                this.parentTransportStream.getPsi().getNetworkSync().update(mip);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Exception trying to create MegaFrameInitializationPacket. ", exception);
            }
        }
    }

    private void processAdaptationField(AdaptationField adaptationField, int packetNo, long timeBase) {
        if (adaptationField.isPCR_flag()) {
            PCR newPCR = adaptationField.getProgram_clock_reference();
            if (PreferencesManager.isEnablePcrPtsView()) {
                this.pcrList.add(new TimeStamp(timeBase, newPCR.getProgram_clock_reference_base()));
            }
            if (this.firstPCR != null && !adaptationField.isDiscontinuity_indicator()) {
                long packetsDiff = packetNo - this.firstPCRpacketNo;
                if (newPCR.getProgram_clock_reference() - this.firstPCR.getProgram_clock_reference() > 0L) {
                    this.bitRate = packetsDiff * (long)this.parentTransportStream.getPacketLenghth() * 27000000L * 8L / (newPCR.getProgram_clock_reference() - this.firstPCR.getProgram_clock_reference());
                }
                this.lastPCR = newPCR;
                this.lastPCRpacketNo = packetNo;
                ++this.pcr_count;
            } else {
                this.firstPCR = newPCR;
                this.firstPCRpacketNo = packetNo;
                this.lastPCR = null;
                this.lastPCRpacketNo = -1;
                this.pcr_count = 1L;
            }
        }
    }

    private void processTEMI(AdaptationField adaptationField, Map<Integer, ArrayList<TemiTimeStamp>> temiList, int packetNo) {
        if (adaptationField.isAdaptation_field_extension_flag() && !adaptationField.isAf_descriptor_not_present_flag()) {
            List<AFDescriptor> afDescriptorList = adaptationField.getAfDescriptorList();
            for (AFDescriptor descriptor : afDescriptorList) {
                TimelineDescriptor timelineDescriptor;
                if (!(descriptor instanceof TimelineDescriptor) || (timelineDescriptor = (TimelineDescriptor)descriptor).getHas_timestamp() != 1 && timelineDescriptor.getHas_timestamp() != 2) continue;
                this.temiBuffer.add(new TemiTimeStamp(packetNo, timelineDescriptor.getMedia_timestamp(), timelineDescriptor.getTimescale(), timelineDescriptor.getDiscontinuity(), timelineDescriptor.getTimeline_id(), timelineDescriptor.getPaused()));
            }
        }
    }

    public int getPackets() {
        return this.packets;
    }

    public String toString() {
        return "PID:" + this.pid + ", packets:" + this.packets;
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isDup_found() {
        return this.dup_found > 1;
    }

    public int getDup_packets() {
        return this.dup_packets;
    }

    public int getLast_continuity_counter() {
        return this.last_continuity_counter;
    }

    public TSPacket getLast_packet() {
        return this.last_packet;
    }

    public long getLast_packet_no() {
        return this.last_packet_no;
    }

    public TransportStream getParentTransportStream() {
        return this.parentTransportStream;
    }

    public void setParentTransportStream(TransportStream parentTransportStream) {
        this.parentTransportStream = parentTransportStream;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP("pid", this.getPid(), this.getLabelMaker().toString());
        if (this.generalPidHandler != null && !this.scrambled) {
            JMenuItem pesMenu = new JMenuItem(this.generalPidHandler.getMenuDescription());
            pesMenu.setActionCommand("parse");
            kvp.setSubMenuAndOwner(pesMenu, this);
        }
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        t.add(new DefaultMutableTreeNode(new KVP("packets", this.getPackets(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("duplicate packets", this.dup_packets, null)));
        KVP continuityErrorsKvp = new KVP("continuity errors", this.continuity_errors_count, null);
        continuityErrorsKvp.addHTMLSource(() -> this.createHtmlList(this.continuityErrors), "Continuity Errors");
        t.add(new DefaultMutableTreeNode(continuityErrorsKvp));
        t.add(new DefaultMutableTreeNode(new KVP("transport_scrambling_control", Boolean.toString(this.scrambled), null)));
        if (!this.scrambled) {
            t.add(new DefaultMutableTreeNode(new KVP("type", this.getTypeString(), null)));
        }
        if (this.firstPCR != null) {
            t.add(new DefaultMutableTreeNode(new KVP("First PCR", this.firstPCR.getProgram_clock_reference(), Utils.printPCRTime(this.firstPCR.getProgram_clock_reference()))));
            t.add(new DefaultMutableTreeNode(new KVP("First PCR packet", this.firstPCRpacketNo, this.getParentTransportStream().getPacketTime(this.firstPCRpacketNo))));
        }
        if (this.lastPCR != null) {
            t.add(new DefaultMutableTreeNode(new KVP("Last PCR", this.lastPCR.getProgram_clock_reference(), Utils.printPCRTime(this.lastPCR.getProgram_clock_reference()))));
            t.add(new DefaultMutableTreeNode(new KVP("Last PCR packet", this.lastPCRpacketNo, this.getParentTransportStream().getPacketTime(this.lastPCRpacketNo))));
            t.add(new DefaultMutableTreeNode(new KVP("PCR_count", this.pcr_count, this.getRepetitionRate(this.pcr_count, this.lastPCRpacketNo, this.firstPCRpacketNo))));
        }
        if (this.bitRate != -1L) {
            t.add(new DefaultMutableTreeNode(new KVP("TS bitrate based on PCR", this.bitRate, null)));
        }
        if (this.type == 2) {
            t.add(this.psi.getJTreeNode(modus));
        }
        JTreeLazyList list = new JTreeLazyList(new PIDPacketGetter(this.parentTransportStream, this.pid, modus));
        t.add(list.getJTreeNode(modus, "Transport packets "));
        if (this.generalPidHandler != null && this.generalPidHandler.isInitialized()) {
            t.add(this.generalPidHandler.getJTreeNode(modus));
        }
        if (!this.temiMap.isEmpty()) {
            KVP temiKvp = new KVP("TEMI");
            for (Map.Entry<Integer, ArrayList<TemiTimeStamp>> entry : this.temiMap.entrySet()) {
                int time_line_id = entry.getKey();
                KVP timeline_idKvp = new KVP("time_line_id", time_line_id);
                timeline_idKvp.addToList((Collection<? extends TreeNode>)entry.getValue(), modus);
                temiKvp.add(timeline_idKvp);
            }
            t.add(temiKvp);
        }
        return t;
    }

    private String createHtmlList(List<ContinuityError> continuityErrorsList) {
        if (continuityErrorsList.isEmpty()) {
            return "No Continuity Errors in this PID";
        }
        StringBuilder sb = new StringBuilder("<table><tr><th>Last<br>Packet<br>No</th><th>Last<br>Continuity<br>Counter</th><th>Next<br>Packet<br>No</th><th>Next<br>Continuity<br>Counter</th></tr>");
        for (ContinuityError error : continuityErrorsList) {
            sb.append("<tr>").append(this.getPacketColumns(error.lastPacketNo, error.lastCCounter)).append(this.getPacketColumns(error.newPacketNo, error.newCCounter)).append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private String getPacketColumns(int packetNo, int cCounter) {
        return "<td align=\"right\">" + "<a href=\"" + this.getPacketCrumbTrail(packetNo) + "\">" + packetNo + "</a>" + "</td><td align=\"right\">" + cCounter + "</td>";
    }

    private String getPacketCrumbTrail(int packetNo) {
        return "root/pids/pid:" + this.pid + "/transport packets/" + packetNo;
    }

    public String getTypeString() {
        return this.type == 2 ? "PSI" : (this.type == 1 ? "PES" : "-");
    }

    public GeneralPSITable getPsi() {
        return this.psi;
    }

    private String getRepetitionRate(long count, long last, long first) {
        long bitrate = this.getParentTransportStream().getBitRate();
        if (bitrate > 0L && count >= 2L) {
            float repRate = (float)(last - first) * (float)this.parentTransportStream.getPacketLenghth() * 8.0f / (float)((count - 1L) * bitrate);
            try (Formatter formatter = new Formatter();){
                String string = "repetition rate: " + String.valueOf(formatter.format("%3.3f seconds", Float.valueOf(repRate)));
                return string;
            }
        }
        return null;
    }

    public void setPsi(GeneralPSITable psi) {
        this.psi = psi;
    }

    public long getBitRate() {
        return this.bitRate;
    }

    public GeneralPidHandler getPidHandler() {
        return this.generalPidHandler;
    }

    public void setPidHandler(GeneralPidHandler generalPidHandler) {
        this.generalPidHandler = generalPidHandler;
    }

    public int getType() {
        return this.type;
    }

    public boolean isScrambled() {
        return this.scrambled;
    }

    public long getContinuity_errors_count() {
        return this.continuity_errors_count;
    }

    public PCR getLastPCR() {
        return this.lastPCR;
    }

    public PCR getFirstPCR() {
        return this.firstPCR;
    }

    public long getLastPCRpacketNo() {
        return this.lastPCRpacketNo;
    }

    public long getFirstPCRpacketNo() {
        return this.firstPCRpacketNo;
    }

    public long getPcr_count() {
        return this.pcr_count;
    }

    public GatherPIDData getGatherer() {
        return this.gatherer;
    }

    public ArrayList<TimeStamp> getPcrList() {
        return this.pcrList;
    }

    public ArrayList<TimeStamp> getPtsList() {
        return this.ptsList;
    }

    public ArrayList<TimeStamp> getDtsList() {
        return this.dtsList;
    }

    public Map<Integer, ArrayList<TemiTimeStamp>> getTemiMap() {
        return this.temiMap;
    }

    public LabelMaker getLabelMaker() {
        return this.labelMaker;
    }

    public class GatherPIDData {
        private PsiSectionData lastPSISection;

        public void reset() {
            this.lastPSISection = null;
        }

        private void processPayload(TSPacket packet, TransportStream ts, PID parentPID) {
            boolean packetHasPayload;
            PID.this.parentTransportStream = ts;
            byte[] data = packet.getData();
            if (data.length == 0) {
                logger.info("packet pretends to have payload, but data is empty, packetNo;" + packet.getPacketNo());
                return;
            }
            int adaptationFieldControl = packet.getAdaptationFieldControl();
            boolean bl = packetHasPayload = adaptationFieldControl == 1 || adaptationFieldControl == 3;
            if (this.lastPSISection == null) {
                if (packet.isPayloadUnitStartIndicator() && data.length > 1 && packetHasPayload) {
                    this.startNewSection(packet, parentPID, data);
                }
            } else if (packetHasPayload && PID.this.type == 2) {
                int bytes_read;
                int start = packet.isPayloadUnitStartIndicator() ? 1 : 0;
                int available = data.length - start;
                if (!this.lastPSISection.isComplete()) {
                    bytes_read = this.lastPSISection.readBytes(data, start, available);
                    start += bytes_read;
                    available -= bytes_read;
                }
                if (this.lastPSISection != null && this.lastPSISection.isComplete()) {
                    this.lastPSISection = null;
                }
                if (packet.isPayloadUnitStartIndicator()) {
                    while (available > 0 && Byte.toUnsignedInt(data[start]) != 255) {
                        this.lastPSISection = new PsiSectionData(parentPID, packet.getPacketNo(), PID.this.parentTransportStream);
                        bytes_read = this.lastPSISection.readBytes(data, start, available);
                        start += bytes_read;
                        available -= bytes_read;
                    }
                }
            }
        }

        private void startNewSection(TSPacket packet, PID parentPID, byte[] data) {
            if (data[0] != 0 || PID.this.getPid() == 0 || data[1] != 0) {
                int bytes_read;
                PID.this.type = 2;
                int start = 1 + Byte.toUnsignedInt(data[0]);
                for (int available = data.length - start; available > 0 && Byte.toUnsignedInt(data[start]) != 255; available -= bytes_read) {
                    this.lastPSISection = new PsiSectionData(parentPID, packet.getPacketNo(), PID.this.parentTransportStream);
                    bytes_read = this.lastPSISection.readBytes(data, start, available);
                    start += bytes_read;
                }
                if (this.lastPSISection != null && this.lastPSISection.isComplete()) {
                    this.lastPSISection = null;
                }
            } else if (data.length > 2 && data[0] == 0 && data[1] == 0 && data[2] == 1) {
                this.startPesPacket(packet, parentPID);
            }
        }

        private void startPesPacket(TSPacket packet, PID parentPID) {
            PID.this.type = 1;
            if (PreferencesManager.isEnablePcrPtsView()) {
                try {
                    PesHeader pesHeader = packet.getPesHeader();
                    if (pesHeader != null && pesHeader.isValidPesHeader() && pesHeader.hasExtendedHeader()) {
                        int pts_dts_flags = pesHeader.getPts_dts_flags();
                        if (pts_dts_flags == 2 || pts_dts_flags == 3) {
                            PID.this.ptsList.add(new TimeStamp(packet.getTimeBase(), pesHeader.getPts()));
                        }
                        if (pts_dts_flags == 3) {
                            PID.this.dtsList.add(new TimeStamp(packet.getTimeBase(), pesHeader.getDts()));
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error getting PTS/DTS from PESHeader in packet:" + packet.getPacketNo() + " from PID:" + parentPID.getPid(), e);
                }
            }
        }
    }

    static class LabelMaker {
        private String base;
        private final LinkedHashMap<String, LinkedHashSet<String>> components = new LinkedHashMap();

        LabelMaker() {
        }

        void setBase(String base) {
            this.base = base;
        }

        void addComponent(String type, String serviceName) {
            this.components.computeIfAbsent(type, k -> new LinkedHashSet()).add(serviceName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.base != null) {
                sb.append(this.base);
                if (!this.components.isEmpty()) {
                    sb.append(" / ");
                }
            }
            StringJoiner sj = new StringJoiner(" / ");
            for (String type : this.components.keySet()) {
                sj.add(this.getTypeServices(type));
            }
            sb.append(sj.toString());
            if (sb.length() == 0) {
                return "?";
            }
            return sb.toString();
        }

        private String getTypeServices(String type) {
            StringBuilder sb = new StringBuilder();
            sb.append(type).append(" - ");
            LinkedHashSet<String> servicesList = this.components.get(type);
            sb.append(String.join((CharSequence)", ", servicesList));
            return sb.toString();
        }
    }

    private record ContinuityError(int lastPacketNo, int lastCCounter, int newPacketNo, int newCCounter) {
    }
}

