/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.PesHeader;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.Utils;

public class PesPacketData
implements TreeNode {
    protected byte[] data;
    protected int stream_id = 0;
    protected int noBytes = 0;
    private PesHeader pesHeader;
    protected int pes_header_data_length;
    protected GeneralPesHandler pesHandler;
    protected int pesDataStart;
    protected int pesDataLen;
    protected int bytesRead = 0;
    protected int startPacketNo;
    public static final int program_stream_map = 188;
    public static final int private_stream_1 = 189;
    public static final int padding_stream = 190;
    public static final int private_stream_2 = 191;
    public static final int ECM_stream = 240;
    public static final int EMM_stream = 241;
    public static final int DSMCC_stream = 242;
    public static final int ISO_IEC_13522_stream = 243;
    public static final int ITU_T_Rec_H_222_1typeA = 244;
    public static final int ITU_T_Rec_H_222_1typeB = 245;
    public static final int ITU_T_Rec_H_222_1typeC = 246;
    public static final int ITU_T_Rec_H_222_1typeD = 247;
    public static final int ITU_T_Rec_H_222_1typeE = 248;
    public static final int ancillary_stream = 249;
    public static final int ISO_IEC14496_1_SL_packetized_stream = 250;
    public static final int ISO_IEC14496_1_FlexMux_stream = 251;
    public static final int program_stream_directory = 255;

    public PesPacketData(int pesStreamID, int pesLength, GeneralPesHandler pesHandler, int packetNo) {
        this.stream_id = pesStreamID;
        this.noBytes = pesLength;
        this.pesHandler = pesHandler;
        this.startPacketNo = packetNo;
        this.data = pesLength == 0 ? new byte[20000] : new byte[pesLength + 6];
    }

    protected PesPacketData(PesPacketData pesPacket) {
        this.stream_id = pesPacket.getPesStreamID();
        this.data = pesPacket.getData();
        this.noBytes = pesPacket.getNoBytes();
        this.pesHandler = pesPacket.getPesHandler();
        this.pesDataStart = pesPacket.getPesDataStart();
        this.pesDataLen = pesPacket.getPesDataLen();
        this.bytesRead = pesPacket.bytesRead;
        this.startPacketNo = pesPacket.startPacketNo;
        this.processPayload();
    }

    public synchronized PesHeader getPesHeader() {
        if (this.pesHeader == null) {
            this.pesHeader = new PesHeader(this.data, 0);
        }
        return this.pesHeader;
    }

    public void readBytes(byte[] payload, int offset, int available) {
        if (this.noBytes != 0) {
            if (this.bytesRead < this.noBytes + 6) {
                int bytesToRead = Math.min(this.noBytes - this.bytesRead + 6, available);
                System.arraycopy(payload, offset, this.data, this.bytesRead, bytesToRead);
                this.bytesRead += bytesToRead;
            }
        } else {
            int newcount = this.bytesRead + available;
            if (newcount > this.data.length) {
                byte[] newbuf = new byte[Math.max(this.data.length * 2, newcount)];
                System.arraycopy(this.data, 0, newbuf, 0, this.bytesRead);
                this.data = newbuf;
            }
            System.arraycopy(payload, offset, this.data, this.bytesRead, available);
            this.bytesRead = newcount;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getNoBytes() {
        return this.noBytes;
    }

    public int getPesStreamID() {
        return this.stream_id;
    }

    public final void processPayload() {
        if (this.stream_id != 188 && this.stream_id != 190 && this.stream_id != 191 && this.stream_id != 240 && this.stream_id != 241 && this.stream_id != 255 && this.stream_id != 242 && this.stream_id != 248) {
            this.pes_header_data_length = this.getPes_header_data_length();
            this.pesDataStart = 9 + this.pes_header_data_length;
            this.pesDataLen = this.noBytes == 0 ? this.bytesRead - this.pes_header_data_length - 3 : this.noBytes - this.pes_header_data_length - 3;
        } else {
            this.pesDataStart = 6;
            this.pesDataLen = this.noBytes;
        }
    }

    public final int getPes_header_data_length() {
        return Utils.getInt(this.data, 8, 1, 255);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        return this.getJTreeNode(modus, new KVP("PES Packet"));
    }

    public DefaultMutableTreeNode getJTreeNode(int modus, KVP kvp) {
        PesHeader phv = this.getPesHeader();
        if (Utils.showPtsModus(modus) && this.hasPTS(phv)) {
            kvp.appendLabel(" [pts=" + Utils.printTimebase90kHz(phv.getPts()) + "]");
        }
        kvp.add(new KVP("Start TS Packet No", this.startPacketNo));
        phv.addToJtree(kvp, modus);
        if (this.noBytes == 0) {
            kvp.add(new KVP("Actual PES length", this.bytesRead));
            kvp.add(new KVP("data", this.data, 0, this.bytesRead));
        } else {
            if (this.noBytes + 6 != this.bytesRead) {
                kvp.add(GuiUtils.getErrorKVP("Actual PES length does not match PES Header Length"));
                kvp.add(new KVP("Actual PES length", this.bytesRead));
            }
            kvp.add(new KVP("data", this.data));
            kvp.add(new KVP("payload", this.data, this.pesDataStart, this.pesDataLen));
        }
        return kvp;
    }

    public boolean hasPTS(PesHeader phv) {
        return phv.isValidPesHeader() && phv.hasExtendedHeader() && phv.hasPTS();
    }

    public boolean hasPTS() {
        return this.hasPTS(this.getPesHeader());
    }

    public long getPts() {
        return this.getPesHeader().getPts();
    }

    public int getPesDataLen() {
        return this.pesDataLen;
    }

    public int getPesDataStart() {
        return this.pesDataStart;
    }

    public GeneralPesHandler getPesHandler() {
        return this.pesHandler;
    }

    public int getStartPacketNo() {
        return this.startPacketNo;
    }

    public boolean isComplete() {
        if (this.noBytes == 0) {
            return false;
        }
        return this.noBytes + 6 == this.bytesRead;
    }
}

