/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ApplicationSignallingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DataBroadcastIDDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LinkageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.RegistrationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.RelatedContentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.BATsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.CAsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.DFITSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.EITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.INTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.NITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.PATsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.RCTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SDTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TDTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TOTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TSDTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.data.mpeg.psi.UNTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FNTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.FSTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.ONTSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.ses.SGTsection;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;

public class PsiSectionData {
    private byte[] data;
    private int noBytes = 0;
    private int packet_no = 0;
    final TransportStream transportStream;
    private final PID parentPID;
    private boolean complete = false;
    private static final Logger logger = Logger.getLogger(PsiSectionData.class.getName());

    public PsiSectionData(PID parent, int packetNo, TransportStream transportStream) {
        this.parentPID = parent;
        this.packet_no = packetNo;
        this.transportStream = transportStream;
        this.data = new byte[3];
    }

    public PsiSectionData(PsiSectionData src) {
        this.parentPID = src.parentPID;
        this.packet_no = src.packet_no;
        this.transportStream = src.transportStream;
        this.data = src.data;
        this.noBytes = src.noBytes;
        this.complete = src.complete;
    }

    public PsiSectionData(byte[] src) {
        this.parentPID = null;
        this.packet_no = -1;
        this.transportStream = null;
        this.data = src;
        this.noBytes = src.length;
        this.complete = true;
    }

    public int readBytes(byte[] payload, int offset, int len) {
        int section_length;
        int available = len;
        int need = 0;
        int read1 = 0;
        int read2 = 0;
        if (this.noBytes < 3) {
            need = 3 - this.noBytes;
            read1 = Math.min(need, available);
            System.arraycopy(payload, offset, this.data, this.noBytes, read1);
            this.noBytes += read1;
            available -= read1;
            if (this.noBytes == 3) {
                section_length = Utils.getInt(this.data, 1, 2, 4095);
                byte[] tmp = new byte[section_length + 3];
                System.arraycopy(this.data, 0, tmp, 0, 3);
                this.data = tmp;
            }
        }
        if (this.noBytes >= 3) {
            section_length = Utils.getInt(this.data, 1, 2, 4095);
            int pid = this.parentPID.getPid();
            if (section_length > 4093) {
                logger.warning("PSi Section Data, section_length>4093 section_length=" + section_length + ", pid=" + pid);
                section_length = 4093;
            }
            need = section_length + 3 - this.noBytes;
            read2 = Math.min(need, available);
            System.arraycopy(payload, offset + read1, this.data, this.noBytes, read2);
            this.noBytes += read2;
            if (read2 == need) {
                this.updatePSI(pid);
                if (PreferencesManager.isEnableGenericPSI()) {
                    try {
                        TableSection psi = new TableSection(this, this.parentPID);
                        this.parentPID.getPsi().update(psi);
                    }
                    catch (RuntimeException re) {
                        logger.log(Level.WARNING, "RuntimeException in readBytes PIDs: pid=" + pid, re);
                    }
                }
                this.complete = true;
            }
        }
        return read1 + read2;
    }

    private void updatePSI(int pid) {
        try {
            if (pid == 0) {
                this.transportStream.getPsi().getPat().update(new PATsection(this, this.parentPID));
            } else {
                int tableId = Byte.toUnsignedInt(this.data[0]);
                if (tableId == 2 && this.transportStream.getPsi().getPat().inPAT(pid)) {
                    this.transportStream.getPsi().getPmts().update(new PMTsection(this, this.parentPID));
                } else if (tableId == 1 && pid == 1) {
                    this.transportStream.getPsi().getCat().update(new CAsection(this, this.parentPID));
                } else if (tableId == 3 && pid == 2) {
                    this.transportStream.getPsi().getTsdt().update(new TSDTsection(this, this.parentPID));
                } else if (pid == 16 && (tableId == 64 || tableId == 65)) {
                    this.transportStream.getPsi().getNit().update(new NITsection(this, this.parentPID));
                } else if (tableId == 74 && pid == 17) {
                    this.transportStream.getPsi().getBat().update(new BATsection(this, this.parentPID));
                } else if (78 <= tableId && tableId <= 111 && pid == 18) {
                    this.transportStream.getPsi().getEit().update(new EITsection(this, this.parentPID));
                } else if (pid == 20 && tableId == 112) {
                    this.transportStream.getPsi().getTdt().update(new TDTsection(this, this.parentPID));
                } else if (pid == 20 && tableId == 115) {
                    this.transportStream.getPsi().getTot().update(new TOTsection(this, this.parentPID));
                } else if (pid == 17 && (tableId == 66 || tableId == 70)) {
                    this.transportStream.getPsi().getSdt().update(new SDTsection(this, this.parentPID));
                } else if (pid == 31 && tableId == 127) {
                    this.transportStream.getPsi().getSit().update(new SITsection(this, this.parentPID));
                } else if (tableId == 76 && this.isINTSection(pid)) {
                    this.transportStream.getPsi().getInt().update(new INTsection(this, this.parentPID));
                } else if (tableId == 75 && this.isUNTSection(pid)) {
                    this.transportStream.getPsi().getUnts().update(new UNTsection(this, this.parentPID));
                } else if (tableId == 116 && this.isAITSection(pid)) {
                    this.transportStream.getPsi().getAits().update(new AITsection(this, this.parentPID));
                } else if (tableId == 118 && this.isRCTSection(pid)) {
                    this.transportStream.getPsi().getRcts().update(new RCTsection(this, this.parentPID));
                } else if (tableId == 252 && this.isSpliceInfoSection(pid)) {
                    this.transportStream.getPsi().getScte35_table().update(new SpliceInfoSection(this, this.parentPID));
                } else if (this.isDIFTSection(pid)) {
                    this.transportStream.getPsi().getDfit_table().update(new DFITSection(this, this.parentPID));
                } else if (tableId >= 55 && tableId <= 63) {
                    if (PreferencesManager.isEnableDSMCC()) {
                        this.transportStream.getPsi().getDsms().update(new TableSectionExtendedSyntax(this, this.parentPID));
                    }
                } else if (tableId == 145 && this.isSGTSection(pid)) {
                    this.transportStream.getPsi().getSgt().update(new SGTsection(this, this.parentPID));
                } else if (PreferencesManager.isEnableM7Fastscan()) {
                    if (tableId == 188) {
                        this.transportStream.getPsi().getM7fastscan().update(new FNTsection(this, this.parentPID));
                    } else if (tableId == 189) {
                        this.transportStream.getPsi().getM7fastscan().update(new FSTsection(this, this.parentPID));
                    } else if (tableId == 190 && this.transportStream.isONTSection(pid)) {
                        this.transportStream.getPsi().getM7fastscan().update(new ONTSection(this, this.parentPID));
                    }
                }
            }
        }
        catch (RuntimeException re) {
            logger.log(Level.WARNING, "RuntimeException in updatePSI PSI data: pid=" + pid, re);
        }
    }

    private boolean isSGTSection(int pid) {
        int transportStreamId = this.transportStream.getStreamID();
        PSI psi = this.transportStream.getPsi();
        int orgNetworkId = psi.getSdt().getOrgNetworkForActualTransportStream();
        Map<Integer, PMTsection[]> pmtList = psi.getPmts().getPmts();
        int nid = psi.getNit().getActualNetworkID();
        if (nid == -1) {
            return false;
        }
        List<LinkageDescriptor> linkageDescriptors = this.transportStream.getLinkageDescriptorsFromNitNetworkLoop();
        for (PMTsection[] pmts : pmtList.values()) {
            PMTsection pmt = pmts[0];
            int programNumber = pmt.getProgramNumber();
            for (PMTsection.Component component : pmt.getComponentenList()) {
                if (component.getElementaryPID() != pid) continue;
                for (LinkageDescriptor ld : linkageDescriptors) {
                    if (!PsiSectionData.isSGTLinkageType(ld.getLinkageType()) || ld.getServiceId() != programNumber || ld.getTransportStreamId() != transportStreamId || ld.getOriginalNetworkId() != orgNetworkId) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isSGTLinkageType(int linkageType) {
        return linkageType == 144 || linkageType == 145 || linkageType == 147 || linkageType == 162;
    }

    private boolean isSpliceInfoSection(int pid) {
        Map<Integer, PMTsection[]> pmtList = this.transportStream.getPsi().getPmts().getPmts();
        for (PMTsection[] pmtSections : pmtList.values()) {
            PMTsection pmt = pmtSections[0];
            if (!PsiSectionData.hasSCTE35RegistrationDescriptor(pmt.getDescriptorList())) continue;
            for (PMTsection.Component component : pmt.getComponentenList()) {
                if (component.getElementaryPID() != pid || component.getStreamtype() != 134) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSCTE35RegistrationDescriptor(List<Descriptor> componentDescriptorList) {
        List<RegistrationDescriptor> registration_descriptors = Descriptor.findGenericDescriptorsInList(componentDescriptorList, RegistrationDescriptor.class);
        for (RegistrationDescriptor registrationDescriptor : registration_descriptors) {
            byte[] formatIdentifier = registrationDescriptor.getFormatIdentifier();
            if (!Utils.equals(formatIdentifier, 0, formatIdentifier.length, RegistrationDescriptor.SCTE_35, 0, RegistrationDescriptor.SCTE_35.length)) continue;
            return true;
        }
        return false;
    }

    public int getPacket_no() {
        return this.packet_no;
    }

    private boolean isINTSection(int pid) {
        List<LinkageDescriptor> linkageDescriptors = this.transportStream.getLinkageDescriptorsFromNitNetworkLoop();
        for (LinkageDescriptor ld : linkageDescriptors) {
            if (ld.getLinkageType() != 11) continue;
            int linkedService = ld.getServiceId();
            int streamId = ld.getTransportStreamId();
            if (streamId != this.transportStream.getStreamID()) continue;
            PMTsection pmt = this.transportStream.getPsi().getPmts().getPmt(linkedService);
            List<PMTsection.Component> componentenList = pmt.getComponentenList();
            for (PMTsection.Component c : componentenList) {
                if (c.getElementaryPID() != pid) continue;
                List<DataBroadcastIDDescriptor> databroadcastIdDescriptors = Descriptor.findGenericDescriptorsInList(c.getComponentDescriptorList(), DataBroadcastIDDescriptor.class);
                for (DataBroadcastIDDescriptor databroadcastDesc : databroadcastIdDescriptors) {
                    if (databroadcastDesc.getDataBroadcastId() != 11) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isUNTSection(int pid) {
        Map<Integer, PMTsection[]> pmtList = this.transportStream.getPsi().getPmts().getPmts();
        for (PMTsection[] pmt : pmtList.values()) {
            PMTsection p = pmt[0];
            for (PMTsection.Component component : p.getComponentenList()) {
                if (component.getElementaryPID() != pid) continue;
                List<DataBroadcastIDDescriptor> data_broadcast_id_descriptors = Descriptor.findGenericDescriptorsInList(component.getComponentDescriptorList(), DataBroadcastIDDescriptor.class);
                for (DataBroadcastIDDescriptor dataBroadCastIDDescriptor : data_broadcast_id_descriptors) {
                    if (dataBroadCastIDDescriptor.getDataBroadcastId() != 10) continue;
                    for (DataBroadcastIDDescriptor.OUIEntry oui : dataBroadCastIDDescriptor.getOuiList()) {
                        int updateType = oui.getUpdateType();
                        if (updateType != 2 && updateType != 3) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isAITSection(int pid) {
        Map<Integer, PMTsection[]> pmtList = this.transportStream.getPsi().getPmts().getPmts();
        for (PMTsection[] pmt : pmtList.values()) {
            PMTsection p = pmt[0];
            for (PMTsection.Component component : p.getComponentenList()) {
                List<ApplicationSignallingDescriptor> application_signalling_descriptors;
                if (component.getElementaryPID() != pid || (application_signalling_descriptors = Descriptor.findGenericDescriptorsInList(component.getComponentDescriptorList(), ApplicationSignallingDescriptor.class)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDIFTSection(int pid) {
        Map<Integer, PMTsection[]> pmtList = this.transportStream.getPsi().getPmts().getPmts();
        for (PMTsection[] pmt : pmtList.values()) {
            PMTsection p = pmt[0];
            for (PMTsection.Component component : p.getComponentenList()) {
                List<DataBroadcastIDDescriptor> databroadcatsid_descriptors;
                if (component.getElementaryPID() != pid || (databroadcatsid_descriptors = Descriptor.findGenericDescriptorsInList(component.getComponentDescriptorList(), DataBroadcastIDDescriptor.class)).isEmpty()) continue;
                for (DataBroadcastIDDescriptor dataBroadcastIDDescriptor : databroadcatsid_descriptors) {
                    if (dataBroadcastIDDescriptor.getDataBroadcastId() != 13) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isRCTSection(int pid) {
        Map<Integer, PMTsection[]> pmtList = this.transportStream.getPsi().getPmts().getPmts();
        for (PMTsection[] pmt : pmtList.values()) {
            PMTsection p = pmt[0];
            for (PMTsection.Component component : p.getComponentenList()) {
                List<RelatedContentDescriptor> application_signalling_descriptors;
                if (component.getElementaryPID() != pid || (application_signalling_descriptors = Descriptor.findGenericDescriptorsInList(component.getComponentDescriptorList(), RelatedContentDescriptor.class)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPacket_no(int packet_no) {
        this.packet_no = packet_no;
    }

    public int getPid() {
        return this.parentPID.getPid();
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getNoBytes() {
        return this.noBytes;
    }

    public void setNoBytes(int noBytes) {
        this.noBytes = noBytes;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getTableId() {
        return Utils.getInt(this.data, 0, 1, 255);
    }

    public int getTableIdExtension() {
        return Utils.getInt(this.data, 3, 2, 65535);
    }

    public int getSectionNumber() {
        return Utils.getInt(this.data, 6, 1, 255);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.complete ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.noBytes;
        result = 31 * result + (this.parentPID == null ? 0 : this.parentPID.hashCode());
        result = 31 * result + (this.transportStream == null ? 0 : this.transportStream.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PsiSectionData other = (PsiSectionData)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.noBytes != other.noBytes) {
            return false;
        }
        if (this.parentPID == null ? other.parentPID != null : !this.parentPID.equals(other.parentPID)) {
            return false;
        }
        if (this.transportStream == null) {
            return other.transportStream == null;
        }
        return this.transportStream.equals(other.transportStream);
    }
}

