/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.AVCHDPacket;
import nl.digitalekabeltelevisie.data.mpeg.ComponentType;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AC3Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AncillaryDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.ApplicationSignallingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CADescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.EnhancedAC3Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LinkageDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.RegistrationDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.RelatedContentDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.SubtitlingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.TeletextDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.VBIDataDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.AC4Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.T2MIDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.TtmlSubtitlingDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.AC3Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.EAC3Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.Audio138183Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.Audio144963Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.ac4.AC4Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DVBSubtitleHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUTeletextHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.smpte.Smpte2038Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.temi.TEMIPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ttml.TtmlPesHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.Video138182Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.jpegxs.JpegXsHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Video14496Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.H265Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.H266Handler;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.T2miPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.psi.EITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.GeneralPSITable;
import nl.digitalekabeltelevisie.data.mpeg.psi.NIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TDTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.handler.GeneralPsiTableHandler;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.M7Fastscan;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.ONTSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.m7fastscan.OperatorFastscan;
import nl.digitalekabeltelevisie.gui.exception.NotAnMPEGFileException;
import nl.digitalekabeltelevisie.util.JTreeLazyList;
import nl.digitalekabeltelevisie.util.OffsetHelper;
import nl.digitalekabeltelevisie.util.PositionPushbackInputStream;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.ProgressMonitorLargeInputStream;
import nl.digitalekabeltelevisie.util.RollOverHelper;
import nl.digitalekabeltelevisie.util.TSPacketGetter;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class TransportStream
implements TreeNode {
    private static final int MAX_SEARCH_BYTES = 5000;
    private static final int CONSECUTIVE_PACKETS = 5;
    public static final int TRANSPORT_ERROR_FLAG = 32768;
    public static final int ADAPTATION_FIELD_FLAG = 8192;
    public static final int PAYLOAD_UNIT_START_FLAG = 16384;
    private static final Logger logger = Logger.getLogger(TransportStream.class.getName());
    private final File file;
    private PID[] pids = new PID[8192];
    private final short[] packet_pid;
    private int[] packetATS;
    private OffsetHelper offsetHelper;
    private RollOverHelper rollOverHelper;
    private boolean enabledHumaxAtsFix;
    private PSI psi = new PSI();
    private int no_packets;
    private int error_packets;
    private long bitRate = -1L;
    private long bitRateTDT = -1L;
    private LocalDateTime zeroTime;
    private final long len;
    private int sync_errors;
    private int packetLength = 188;
    public static final int[] ALLOWED_PACKET_LENGTHS = new int[]{188, 192, 204, 208};

    public TransportStream(String fileName) throws NotAnMPEGFileException, IOException {
        this(new File(fileName));
    }

    public TransportStream(File file) throws NotAnMPEGFileException, IOException {
        this.file = file;
        this.len = file.length();
        this.packetLength = TransportStream.determinePacketLengthToUse(file);
        int max_packets = (int)(this.len / (long)this.packetLength);
        this.packet_pid = new short[max_packets];
        if (this.isAVCHD()) {
            this.packetATS = new int[max_packets];
            this.enabledHumaxAtsFix = PreferencesManager.isEnableHumaxAtsFix();
            this.rollOverHelper = new RollOverHelper(max_packets);
        }
        this.offsetHelper = new OffsetHelper(max_packets, this.packetLength);
    }

    private static int determinePacketLengthToUse(File file) throws NotAnMPEGFileException, IOException {
        int packetLengthModus = PreferencesManager.getPacketLengthModus();
        if (packetLengthModus == 0) {
            return TransportStream.determineActualPacketLength(file);
        }
        return packetLengthModus;
    }

    private static int determineActualPacketLength(File file) throws NotAnMPEGFileException, IOException {
        if (file.length() < 752L) {
            throw new NotAnMPEGFileException("File too short to determine packet length automatic. File should have at least 5 consecutive packets.\n\nTry setting packet length manual.");
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            for (int possiblePacketLength : ALLOWED_PACKET_LENGTHS) {
                logger.log(Level.INFO, "Trying for packetLength {0}", possiblePacketLength);
                if (!TransportStream.usesPacketLength(possiblePacketLength, randomAccessFile)) continue;
                logger.log(Level.INFO, "Found packetLength {0}", possiblePacketLength);
                int n = possiblePacketLength;
                return n;
            }
        }
        throw new NotAnMPEGFileException("DVB Inspector could not determine packetsize for this file. \nDVB Inspector supports packet sizes of 188, 192, 204 and 208 bytes.\n\n Are you sure this file contains a valid MPEG Transport Stream?\n\n ");
    }

    private static boolean usesPacketLength(int possiblePacketLength, RandomAccessFile randomAccessFile) throws IOException {
        int startPos = 0;
        do {
            logger.log(Level.INFO, "starting at position {0}", startPos);
            randomAccessFile.seek(startPos);
            int b = randomAccessFile.read();
            while (b != 71 && startPos < 5000) {
                b = randomAccessFile.read();
                ++startPos;
            }
            logger.log(Level.INFO, "found a sync byte at position {0}", startPos);
            boolean seqFound = true;
            for (int i = 1; i < 5 && seqFound; ++i) {
                randomAccessFile.seek((long)startPos + (long)i * (long)possiblePacketLength);
                logger.log(Level.INFO, "found {0} sequence syncs at pos {1}", new Object[]{i, startPos + i * possiblePacketLength});
                seqFound = randomAccessFile.read() == 71;
            }
            if (!seqFound) continue;
            return true;
        } while (++startPos < 5000);
        return false;
    }

    public void parseStream(Component component) throws IOException {
        try (FileInputStream is = new FileInputStream(this.file);
             PositionPushbackInputStream fileStream = component == null ? new PositionPushbackInputStream(new BufferedInputStream(is), 300) : new PositionPushbackInputStream(new BufferedInputStream(new ProgressMonitorLargeInputStream(component, "Reading file \"" + this.file.getPath() + "\"", is, this.file.length())), 300);){
            this.no_packets = 0;
            this.pids = new PID[8192];
            this.psi = new PSI();
            this.error_packets = 0;
            this.bitRate = -1L;
            this.bitRateTDT = -1L;
            if (this.isAVCHD()) {
                this.readAVCHDPackets(fileStream);
            } else {
                this.readPackets(fileStream);
            }
        }
        this.postProcess();
    }

    private void readPackets(PositionPushbackInputStream fileStream) throws IOException {
        int count = 0;
        int bytes_read = 0;
        int lastHandledSyncErrorPacket = -1;
        byte[] buf = new byte[this.packetLength];
        do {
            long offset = fileStream.getPosition();
            bytes_read = fileStream.read(buf, 0, this.packetLength);
            int next = fileStream.read();
            if (bytes_read == this.packetLength && buf[0] == 71 && (next == -1 || next == 71)) {
                if (next != -1) {
                    fileStream.unread(next);
                }
                this.offsetHelper.addPacket(this.no_packets, offset);
                this.processPacket(new TSPacket(buf, count, this));
                ++count;
                continue;
            }
            if (next == -1) continue;
            if (lastHandledSyncErrorPacket != this.no_packets) {
                ++this.sync_errors;
                logger.severe(String.format("Did not find sync byte, resyncing at offset:%d, packet_no:%d", offset, this.no_packets));
                lastHandledSyncErrorPacket = this.no_packets;
            }
            fileStream.unread(next);
            fileStream.unread(buf, 0, bytes_read);
            fileStream.read();
        } while (bytes_read == this.packetLength);
    }

    private void readAVCHDPackets(PositionPushbackInputStream fileStream) throws IOException {
        int count = 0;
        int bytes_read = 0;
        int lastHandledSyncErrorPacket = -1;
        byte[] buf = new byte[192];
        int lastArrivalTimeStamp = Integer.MAX_VALUE;
        long currentRollOver = -1L;
        do {
            long offset = fileStream.getPosition();
            bytes_read = fileStream.read(buf, 0, 192);
            byte[] nextBytes = new byte[5];
            int next = fileStream.read(nextBytes, 0, 5);
            if (bytes_read == this.packetLength && buf[4] == 71 && (next != 5 || nextBytes[4] == 71)) {
                if (next != -1) {
                    fileStream.unread(nextBytes, 0, next);
                }
                this.offsetHelper.addPacket(this.no_packets, offset);
                AVCHDPacket packet = new AVCHDPacket(buf, count, this);
                int arrivalTimestamp = packet.getArrivalTimestamp();
                if (arrivalTimestamp < lastArrivalTimeStamp) {
                    this.rollOverHelper.addPacket(count, ++currentRollOver);
                }
                lastArrivalTimeStamp = arrivalTimestamp;
                this.packetATS[count] = arrivalTimestamp;
                this.processPacket(packet);
                ++count;
                continue;
            }
            if (next == -1) continue;
            if (lastHandledSyncErrorPacket != this.no_packets) {
                ++this.sync_errors;
                logger.severe(String.format("Did not find sync byte, resyncing at offset:%d, packet_no:%d", offset, this.no_packets));
                lastHandledSyncErrorPacket = this.no_packets;
            }
            fileStream.unread(nextBytes, 0, next);
            fileStream.unread(buf, 0, bytes_read);
            fileStream.read();
        } while (bytes_read == this.packetLength);
    }

    public void postProcess() {
        this.namePIDs();
        this.setGeneralPsiTableHandlers();
        this.parseTemiPids();
        this.calculateBitRate();
        this.calculateBitrateTDT();
        this.calculateZeroTime();
    }

    private void parseTemiPids() {
        if (PreferencesManager.isEnablePcrPtsView()) {
            HashMap<Integer, GeneralPidHandler> toParsePids = new HashMap<Integer, GeneralPidHandler>();
            for (PMTsection[] pmt : this.psi.getPmts()) {
                PMTsection pmtSection = pmt[0];
                for (PMTsection.Component component : pmtSection.getComponentenList()) {
                    if (component.getStreamtype() != 39) continue;
                    int pid = component.getElementaryPID();
                    toParsePids.put(pid, this.pids[pid].getPidHandler());
                }
            }
            try {
                this.parsePidStreams(toParsePids);
            }
            catch (IOException e) {
                logger.info("IOException while parsing TEMI");
            }
        }
    }

    private void processPacket(TSPacket packet) {
        short pid = packet.getPID();
        this.packet_pid[this.no_packets] = TransportStream.addPIDFlags(packet, pid);
        ++this.no_packets;
        if (this.pids[pid] == null) {
            this.pids[pid] = new PID(pid, this);
        }
        this.pids[pid].updatePacket(packet);
        if (packet.isTransportErrorIndicator()) {
            ++this.error_packets;
            logger.warning(String.format("TransportErrorIndicator set for packet %s", packet));
        }
    }

    private static short addPIDFlags(TSPacket packet, short pid) {
        short pidFlags = pid;
        if (packet.hasAdaptationField()) {
            pidFlags = (short)(pidFlags | 0x2000);
        }
        if (packet.isPayloadUnitStartIndicator()) {
            pidFlags = (short)(pidFlags | 0x4000);
        }
        if (packet.isTransportErrorIndicator()) {
            pidFlags = (short)(pidFlags | 0x8000);
        }
        return pidFlags;
    }

    public void parsePidStreams(Map<Integer, GeneralPidHandler> toParsePids) throws IOException {
        if (toParsePids == null || toParsePids.isEmpty()) {
            return;
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");){
            for (int t = 0; t < this.no_packets; ++t) {
                short pid = this.getPacket_pid(t);
                GeneralPidHandler handler = toParsePids.get(pid);
                if (handler == null) continue;
                TSPacket packet = this.readPacket(t, randomAccessFile);
                handler.processTSPacket(packet);
            }
            for (GeneralPidHandler pidHandler : toParsePids.values()) {
                pidHandler.postProcess();
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Transportstream :").append(this.file.getName()).append('\n');
        for (int i = 0; i < this.pids.length; ++i) {
            PID pid = this.pids[i];
            if (pid == null) continue;
            buf.append("  PID :").append(i).append(", ").append(pid).append(" packets, ").append(pid.getPackets() * 100 / this.no_packets).append("%, duplicate packets:").append(pid.getDup_packets()).append("\n");
        }
        return buf.toString();
    }

    public File getFile() {
        return this.file;
    }

    public int getNo_packets() {
        return this.no_packets;
    }

    public PID[] getPids() {
        return this.pids;
    }

    public PSI getPsi() {
        return this.psi;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = new KVP("Transport Stream " + this.psi.getPat().getTransportStreamId()).setCrumb("root");
        t.addHTMLSource(() -> this.getSummary(modus), "Summary");
        t.add(new KVP("file", this.file.getPath()));
        t.add(new KVP("size", this.file.length()));
        t.add(new KVP("modified", String.format("%1$tc", this.file.lastModified())));
        t.add(new KVP("TS packets", this.no_packets));
        t.add(new KVP("packet size", this.packetLength).setDescription(PreferencesManager.getPacketLengthModus() == 0 ? "(detected)" : "(forced)"));
        t.add(new KVP("Error packets", this.error_packets));
        t.add(new KVP("Sync Errors", this.sync_errors));
        if (this.bitRate != -1L) {
            t.add(new KVP("bitrate", this.bitRate));
            t.add(new KVP("length (secs)", this.file.length() * 8L / this.bitRate));
        }
        if (this.bitRateTDT != -1L) {
            t.add(new KVP("bitrate based on TDT", this.bitRateTDT));
            t.add(new KVP("length (secs)", this.file.length() * 8L / this.bitRateTDT));
        }
        t.add(this.psi.getJTreeNode(modus));
        if (!Utils.psiOnlyModus(modus)) {
            KVP pidTreeNode = new KVP("PIDs").addTableSource(this::getTableModel, "PIDs");
            t.add(pidTreeNode);
            for (PID pid : this.pids) {
                if (pid == null) continue;
                pidTreeNode.add(pid.getJTreeNode(modus));
            }
            if (this.no_packets == 0) {
                t.add(new KVP("Transport packets "));
            } else {
                JTreeLazyList list = new JTreeLazyList(new TSPacketGetter(this, modus));
                t.add(list.getJTreeNode(modus, "Transport packets "));
            }
        }
        return t;
    }

    private String getSummary(int modus) {
        StringBuilder sb = new StringBuilder();
        int transportStreamId = this.psi.getPat().getTransportStreamId();
        if (transportStreamId != -1) {
            sb.append("Transport Stream: ").append(transportStreamId).append("<br/>");
        }
        Map<Integer, PMTsection[]> pmts = this.psi.getPmts().getPmts();
        TreeSet<Integer> serviceIds = new TreeSet<Integer>(pmts.keySet());
        sb.append("<ol>");
        for (Integer programNumber : serviceIds) {
            PMTsection[] sections = pmts.get(programNumber);
            sb.append("<li>program: ").append("<a href=\"root/psi/pmts/program:").append(programNumber).append("\">").append(programNumber).append("</a>");
            this.psi.getSdt().getServiceNameForActualTransportStreamOptional(programNumber).ifPresent(s -> sb.append(" (").append((String)s).append(')'));
            sb.append("<br/>");
            PMTsection pmtSection = sections[0];
            sb.append("<ol>");
            for (PMTsection.Component component : pmtSection.getComponentenList()) {
                sb.append("<li>Pid: ");
                if (!Utils.psiOnlyModus(modus)) {
                    sb.append("<a href=\"root/pids/pid:").append(component.getElementaryPID()).append("\">");
                }
                sb.append(component.getElementaryPID());
                if (!Utils.psiOnlyModus(modus)) {
                    sb.append("</a>");
                }
                sb.append(" Stream type: ").append(component.getStreamtype()).append(" (").append(TransportStream.determineComponentType(component.getComponentDescriptorList()).map(ComponentType::getDescription).orElse(Utils.getStreamTypeShortString(component.getStreamtype()))).append(")</li>");
            }
            sb.append("</ol><br/>");
            EITsection[] pf = this.psi.getEit().getActualTransportStreamEitPF(programNumber);
            if (pf.length > 0) {
                sb.append("EIT p/f:<br/>");
                for (EITsection section : pf) {
                    int sectionNumber = section.getSectionNumber();
                    for (EITsection.Event event : section.getEventList()) {
                        sb.append(Utils.escapeHTML(Utils.getEITStartTimeAsString(event.getStartTime()))).append("&nbsp;").append(Utils.formatDuration(event.getDuration())).append("&nbsp;").append("<a href=\"root/psi/eit/original_network_id:").append(section.getOriginalNetworkID()).append("/transport_stream_id:").append(section.getTransportStreamID()).append("/service_id:").append(programNumber).append("/tableid:78");
                        if (!Utils.simpleModus(modus)) {
                            sb.append("/tablesection:").append(sectionNumber).append("/events");
                        }
                        sb.append("/event:").append(event.getEventID()).append("\">").append(event.getEventName()).append("</a><br/>");
                    }
                }
            }
            sb.append("<br/></li>");
        }
        sb.append("</ol>");
        return sb.toString();
    }

    static TableHeader<TransportStream, PID> buildPidTableHeader() {
        return new TableHeaderBuilder().addOptionalRowColumn("pid", PID::getPid, Integer.class).addOptionalRowColumn("label", p -> p.getLabelMaker().toString(), String.class).addOptionalRowColumn("pid type", PID::getTypeString, String.class).addOptionalRowColumn("packets", PID::getPackets, Integer.class).addOptionalRowColumn("duplicate packets", PID::getDup_packets, Integer.class).addOptionalRowColumn("continuity errors", PID::getContinuity_errors_count, Integer.class).addOptionalRowColumn("scrambled", PID::isScrambled, Boolean.class).build();
    }

    public TableModel getTableModel() {
        FlexTableModel<TransportStream, PID> tableModel = new FlexTableModel<TransportStream, PID>(TransportStream.buildPidTableHeader());
        List<PID> pidsList = Arrays.asList(this.pids);
        tableModel.addData(this, pidsList);
        tableModel.process();
        return tableModel;
    }

    private void setLabelMakerBase(int pidNo, String base) {
        if (this.pids[pidNo] != null) {
            this.pids[pidNo].getLabelMaker().setBase(base);
        }
    }

    private void addLabelMakerComponent(int pidNo, String type, String serviceName) {
        if (this.pids[pidNo] != null) {
            this.pids[pidNo].getLabelMaker().addComponent(type, serviceName);
        }
    }

    private static String getFixedLabel(short pid) {
        switch (pid) {
            case 0: {
                return "PAT";
            }
            case 1: {
                return "CAT";
            }
            case 2: {
                return "TSDT";
            }
            case 3: {
                return "IPMP control information table ";
            }
            case 4: {
                return "Adaptive streaming information";
            }
            case 16: {
                return "NIT";
            }
            case 17: {
                return "SDT/BAT";
            }
            case 18: {
                return "EIT";
            }
            case 19: {
                return "RST, ST";
            }
            case 20: {
                return "TOT/TDT";
            }
            case 21: {
                return "network synchronization";
            }
            case 22: {
                return "RNT (TS 102 323)";
            }
            case 27: {
                return "SAT";
            }
            case 28: {
                return "inband signalling";
            }
            case 29: {
                return "measurement";
            }
            case 30: {
                return "DIT";
            }
            case 31: {
                return "SIT";
            }
        }
        if (pid <= 27) {
            return "reserved for future use";
        }
        return "??";
    }

    private void namePIDs() {
        for (short i = 0; i <= 31; i = (short)(i + 1)) {
            this.setLabelMakerBase(i, TransportStream.getFixedLabel(i));
        }
        this.setLabelMakerBase(8191, "NULL Packets (Stuffing)");
        if (this.pids[1] != null) {
            for (CADescriptor caDescriptor : Descriptor.findGenericDescriptorsInList(this.psi.getCat().getDescriptorList(), CADescriptor.class)) {
                this.addLabelMakerComponent(caDescriptor.getCaPID(), "EMM", "CA_ID:" + caDescriptor.getCaSystemID() + " (" + Utils.getCASystemIDString(caDescriptor.getCaSystemID()) + ")");
            }
        }
        for (PMTsection[] pmt : this.psi.getPmts()) {
            for (PMTsection pmtSection = pmt[0]; pmtSection != null; pmtSection = (PMTsection)pmtSection.getNextVersion()) {
                int service_id = pmtSection.getProgramNumber();
                String service_name = this.psi.getSdt().getServiceNameForActualTransportStreamOptional(service_id).orElse("Service " + service_id);
                this.labelPmtForProgram(pmtSection, service_name);
                this.labelEcmForProgram(pmtSection, service_name);
                this.labelComponentsForProgram(pmtSection, service_name);
                this.labelPcrForProgram(pmtSection, service_name);
            }
        }
        if (PreferencesManager.isEnableM7Fastscan()) {
            this.labelM7FastscanTables();
        }
    }

    private void setGeneralPsiTableHandlers() {
        if (PreferencesManager.isEnableGenericPSI()) {
            for (PID pid : this.pids) {
                GeneralPSITable psiData;
                if (pid == null || pid.getType() != 2 || (psiData = pid.getPsi()).getLongSections().isEmpty() && psiData.getSimpleSectionsd().isEmpty() || pid.getPidHandler() != null) continue;
                GeneralPsiTableHandler generalPsiTableHandler = new GeneralPsiTableHandler();
                generalPsiTableHandler.setPID(pid);
                generalPsiTableHandler.setTransportStream(this);
                pid.setPidHandler(generalPsiTableHandler);
            }
        }
    }

    private void labelM7FastscanTables() {
        M7Fastscan fastScan = this.psi.getM7fastscan();
        TransportStream.labelM7FastscanONT(fastScan);
        this.labelM7FastscanFstFnt(fastScan);
    }

    private void labelM7FastscanFstFnt(M7Fastscan fastScan) {
        Map<Integer, Map<Integer, OperatorFastscan>> operators = fastScan.getOperators();
        for (Integer operatorId : new TreeSet<Integer>(operators.keySet())) {
            Map<Integer, OperatorFastscan> operatorsInPid = operators.get(operatorId);
            for (Integer pid : new TreeSet<Integer>(operatorsInPid.keySet())) {
                StringBuilder name = new StringBuilder("M7 FastScan operator ").append(fastScan.getOperatorName(operatorId));
                OperatorFastscan operatorFastscan = operatorsInPid.get(pid);
                if (operatorFastscan.getOperatorSubListName() != null) {
                    name.append(" ").append(operatorFastscan.getOperatorSubListName());
                }
                if (operatorFastscan.getFntSections() != null) {
                    name.append(" FNT");
                }
                if (operatorFastscan.getFstSections() != null) {
                    name.append(" FST");
                }
                if (this.pids[pid] == null) continue;
                this.pids[pid].getLabelMaker().setBase(name.toString());
            }
        }
    }

    private static void labelM7FastscanONT(M7Fastscan fastScan) {
        ONTSection[] sections = fastScan.getOntSections();
        if (sections != null) {
            for (ONTSection section : sections) {
                if (section == null) continue;
                section.getParentPID().getLabelMaker().setBase("M7 FastScan ONT");
                return;
            }
        }
    }

    private void labelPmtForProgram(PMTsection pmtSection, String service_name) {
        this.addLabelMakerComponent(pmtSection.getParentPID().getPid(), "PMT", service_name);
    }

    private void labelEcmForProgram(PMTsection pmtSection, String service_name) {
        for (CADescriptor caDescriptor : Descriptor.findGenericDescriptorsInList(pmtSection.getDescriptorList(), CADescriptor.class)) {
            this.addLabelMakerComponent(caDescriptor.getCaPID(), "ECM", "CA_ID:" + caDescriptor.getCaSystemID() + " (" + service_name + ")");
        }
    }

    private void labelPcrForProgram(PMTsection pmtSection, String service_name) {
        int PCR_pid = pmtSection.getPcrPid();
        boolean pcrInComponent = false;
        for (PMTsection.Component component : pmtSection.getComponentenList()) {
            if (PCR_pid != component.getElementaryPID()) continue;
            pcrInComponent = true;
            break;
        }
        if (!pcrInComponent && PCR_pid != 8191) {
            this.addLabelMakerComponent(PCR_pid, "PCR", service_name);
        }
    }

    private void labelComponentsForProgram(PMTsection pmtSection, String service_name) {
        for (PMTsection.Component component : pmtSection.getComponentenList()) {
            PID pid;
            int streamType = component.getStreamtype();
            GeneralPidHandler generalPidHandler = this.determinePesHandlerByStreamType(component, streamType);
            Optional<ComponentType> componentType = TransportStream.determineComponentType(component.getComponentDescriptorList());
            this.addLabelMakerComponent(component.getElementaryPID(), componentType.map(ComponentType::getDescription).orElse(Utils.getStreamTypeShortString(streamType)), service_name);
            if (componentType.isPresent()) {
                switch (componentType.get()) {
                    case DVB_SUBTITLING: {
                        generalPidHandler = new DVBSubtitleHandler();
                        break;
                    }
                    case TELETEXT: 
                    case VBI: {
                        generalPidHandler = new EBUTeletextHandler();
                        break;
                    }
                    case AC3: {
                        generalPidHandler = new AC3Handler();
                        break;
                    }
                    case AC4: {
                        generalPidHandler = new AC4Handler();
                        break;
                    }
                    case E_AC3: {
                        generalPidHandler = new EAC3Handler();
                        break;
                    }
                    case AIT: 
                    case RCT: {
                        break;
                    }
                    case T2MI: {
                        generalPidHandler = new T2miPidHandler();
                        break;
                    }
                    case TTML: {
                        generalPidHandler = new TtmlPesHandler();
                        break;
                    }
                    case SMPTE2038: {
                        generalPidHandler = new Smpte2038Handler();
                        break;
                    }
                    default: {
                        logger.warning(String.format("no componenttype found for pid %d, part of service %s", component.getElementaryPID(), service_name));
                    }
                }
            }
            if ((pid = this.pids[component.getElementaryPID()]) != null && generalPidHandler != null) {
                generalPidHandler.setTransportStream(this);
                generalPidHandler.setPID(pid);
                pid.setPidHandler(generalPidHandler);
            }
            List<CADescriptor> caDescriptorList = Descriptor.findGenericDescriptorsInList(component.getComponentDescriptorList(), CADescriptor.class);
            for (CADescriptor cad : caDescriptorList) {
                this.addLabelMakerComponent(cad.getCaPID(), "ECM", "CA_ID:" + cad.getCaSystemID() + " (" + service_name + ")");
            }
        }
    }

    public static Optional<ComponentType> determineComponentType(List<Descriptor> componentDescriptorList) {
        return Optional.ofNullable(TransportStream.findComponentType(componentDescriptorList));
    }

    private static ComponentType findComponentType(List<Descriptor> componentDescriptorList) {
        for (Descriptor descriptor : componentDescriptorList) {
            Descriptor descriptor2;
            Objects.requireNonNull(descriptor);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubtitlingDescriptor.class, TeletextDescriptor.class, VBIDataDescriptor.class, AC3Descriptor.class, AC4Descriptor.class, RegistrationDescriptor.class, EnhancedAC3Descriptor.class, ApplicationSignallingDescriptor.class, RelatedContentDescriptor.class, T2MIDescriptor.class, TtmlSubtitlingDescriptor.class}, (Object)descriptor2, n)) {
                case 0: {
                    SubtitlingDescriptor ignored = (SubtitlingDescriptor)descriptor2;
                    return ComponentType.DVB_SUBTITLING;
                }
                case 1: {
                    TeletextDescriptor ignored = (TeletextDescriptor)descriptor2;
                    return ComponentType.TELETEXT;
                }
                case 2: {
                    VBIDataDescriptor ignored = (VBIDataDescriptor)descriptor2;
                    return ComponentType.VBI;
                }
                case 3: {
                    AC3Descriptor ignored = (AC3Descriptor)descriptor2;
                    return ComponentType.AC3;
                }
                case 4: {
                    AC4Descriptor ignored = (AC4Descriptor)descriptor2;
                    return ComponentType.AC4;
                }
                case 5: {
                    RegistrationDescriptor registrationDescriptor = (RegistrationDescriptor)descriptor2;
                    byte[] formatIdentifier = registrationDescriptor.getFormatIdentifier();
                    if (Arrays.equals(formatIdentifier, RegistrationDescriptor.AC_3)) {
                        return ComponentType.AC3;
                    }
                    if (!Arrays.equals(formatIdentifier, RegistrationDescriptor.SMPTE_2038)) break;
                    return ComponentType.SMPTE2038;
                }
                case 6: {
                    EnhancedAC3Descriptor ignored = (EnhancedAC3Descriptor)descriptor2;
                    return ComponentType.E_AC3;
                }
                case 7: {
                    ApplicationSignallingDescriptor ignored = (ApplicationSignallingDescriptor)descriptor2;
                    return ComponentType.AIT;
                }
                case 8: {
                    RelatedContentDescriptor ignored = (RelatedContentDescriptor)descriptor2;
                    return ComponentType.RCT;
                }
                case 9: {
                    T2MIDescriptor ignored = (T2MIDescriptor)descriptor2;
                    return ComponentType.T2MI;
                }
                case 10: {
                    TtmlSubtitlingDescriptor ignored = (TtmlSubtitlingDescriptor)descriptor2;
                    return ComponentType.TTML;
                }
            }
        }
        return null;
    }

    private GeneralPidHandler determinePesHandlerByStreamType(PMTsection.Component component, int streamType) {
        int componentElementaryPID = component.getElementaryPID();
        PID pid = this.pids[componentElementaryPID];
        if (pid != null && !pid.isScrambled() && pid.getType() == 1) {
            return switch (streamType) {
                case 1, 2 -> new Video138182Handler();
                case 3, 4 -> new Audio138183Handler(TransportStream.getAncillaryDataIdentifier(component));
                case 17 -> new Audio144963Handler();
                case 27 -> new Video14496Handler();
                case 32 -> new Video14496Handler();
                case 36 -> new H265Handler();
                case 39 -> new TEMIPesHandler();
                case 51 -> new H266Handler();
                case 50 -> new JpegXsHandler();
                default -> new GeneralPesHandler();
            };
        }
        return null;
    }

    private static int getAncillaryDataIdentifier(PMTsection.Component component) {
        List<AncillaryDataDescriptor> ancillaryDataDescriptors = Descriptor.findGenericDescriptorsInList(component.getComponentDescriptorList(), AncillaryDataDescriptor.class);
        if (!ancillaryDataDescriptors.isEmpty()) {
            return ancillaryDataDescriptors.getFirst().getAncillaryDataIdentifier();
        }
        return 0;
    }

    private void calculateBitRate() {
        int teller = 0;
        long totBitrate = 0L;
        for (PID pid : this.pids) {
            if (pid == null || pid.getBitRate() == -1L) continue;
            ++teller;
            totBitrate += pid.getBitRate();
        }
        if (teller != 0) {
            this.bitRate = totBitrate / (long)teller;
        }
    }

    private void calculateBitrateTDT() {
        List<TDTsection> tdtSectionList;
        if (this.psi.getTdt() != null && (tdtSectionList = this.psi.getTdt().getTdtSectionList()).size() >= 2) {
            long timeDiffMills;
            TDTsection first = tdtSectionList.getFirst();
            TDTsection last = tdtSectionList.getLast();
            long diffPacket = (long)last.getPacket_no() - (long)first.getPacket_no();
            LocalDateTime utcCalenderLast = Utils.getUTCLocalDateTime(last.getUTC_time());
            LocalDateTime utcCalenderFirst = Utils.getUTCLocalDateTime(first.getUTC_time());
            if (utcCalenderLast != null && utcCalenderFirst != null && (timeDiffMills = utcCalenderFirst.until(utcCalenderLast, ChronoUnit.MILLIS)) > 0L) {
                this.bitRateTDT = diffPacket * (long)this.packetLength * 8L * 1000L / timeDiffMills;
            }
        }
    }

    private void calculateZeroTime() {
        TDTsection first;
        LocalDateTime firstTime;
        List<TDTsection> tdtSectionList;
        if (this.psi.getTdt() != null && this.getBitRate() != -1L && !(tdtSectionList = this.psi.getTdt().getTdtSectionList()).isEmpty() && (firstTime = Utils.getUTCLocalDateTime((first = tdtSectionList.getFirst()).getUTC_time())) != null) {
            long millsIntoStream = (long)first.getPacket_no() * (long)this.packetLength * 8L * 1000L / this.getBitRate();
            this.zeroTime = firstTime.minus(millsIntoStream, ChronoUnit.MILLIS);
        }
    }

    public int getStreamID() {
        return this.psi.getPat().getTransportStreamId();
    }

    public int getNoPIDS() {
        int t = 0;
        for (PID pid : this.pids) {
            if (pid == null) continue;
            ++t;
        }
        return t;
    }

    public short[] getUsedPids() {
        int no = this.getNoPIDS();
        short[] r = new short[no];
        int i = 0;
        for (int pid = 0; pid < 8192; pid = (int)((short)(pid + 1))) {
            if (this.pids[pid] == null) continue;
            r[i++] = pid;
        }
        return r;
    }

    public short getPacket_pid(int t) {
        return (short)(0x1FFF & this.packet_pid[t]);
    }

    public short getPacketPidFlags(int t) {
        return this.packet_pid[t];
    }

    public String getShortLabel(short pid) {
        if (this.pids[pid] != null) {
            return this.pids[pid].getLabelMaker().toString();
        }
        return null;
    }

    public long getBitRate() {
        if (this.bitRate != -1L) {
            return this.bitRate;
        }
        if (this.bitRateTDT != -1L) {
            return this.bitRateTDT;
        }
        return -1L;
    }

    public double getLength() {
        if (this.bitRate != -1L) {
            return (double)this.file.length() * 8.0 / (double)this.bitRate;
        }
        if (this.bitRateTDT != -1L) {
            return (double)this.file.length() * 8.0 / (double)this.bitRateTDT;
        }
        return -1.0;
    }

    public String getPacketTime(int packetNo) {
        if (this.isAVCHD()) {
            return Utils.printPCRTime(this.getAVCHDPacketTime(packetNo));
        }
        if (this.getBitRate() == -1L) {
            return packetNo + " (packetNo)";
        }
        if (this.zeroTime == null) {
            Instant instant = Instant.ofEpochMilli(this.getTimeFromStartInMilliSecs(packetNo));
            LocalDateTime ldt = instant.atZone(ZoneId.of("Z")).toLocalDateTime();
            return TransportStream.getFormattedTime(ldt);
        }
        LocalDateTime packetTime = this.zeroTime.plusNanos(1000000L * (long)this.getTimeFromStartInMilliSecs(packetNo));
        return TransportStream.getFormattedDateTime(packetTime);
    }

    private int getTimeFromStartInMilliSecs(int packetNo) {
        return (int)((long)packetNo * (long)this.packetLength * 8L * 1000L / this.getBitRate());
    }

    private static String getFormattedDateTime(LocalDateTime calendar) {
        return String.format("%1$tY/%1$tm/%1$td %1$tHh%1$tMm%1$tS:%1$tL", calendar);
    }

    private static String getFormattedTime(LocalDateTime calendar) {
        return String.format("%1$tHh%1$tMm%1$tS:%1$tL", calendar);
    }

    public String getShortPacketTime(long packetNoOrPCR) {
        if (this.isAVCHD()) {
            return Utils.printPCRTime(packetNoOrPCR);
        }
        if (this.getBitRate() != -1L) {
            if (this.zeroTime == null) {
                Instant instant = Instant.ofEpochMilli(this.getTimeFromStartInMilliSecs((int)packetNoOrPCR));
                return TransportStream.getFormattedTime(instant.atZone(ZoneId.of("Z")).toLocalDateTime());
            }
            return TransportStream.getFormattedTime(this.zeroTime.plusNanos(1000000L * (long)this.getTimeFromStartInMilliSecs((int)packetNoOrPCR)));
        }
        return packetNoOrPCR + " (packetNo)";
    }

    public final boolean isAVCHD() {
        return this.packetLength == 192;
    }

    public PMTsection getPMTforPID(int thisPID) {
        PMTs pmts = this.psi.getPmts();
        for (PMTsection[] pmTsections : pmts) {
            PMTsection pmt = pmTsections[0];
            for (PMTsection.Component component : pmt.getComponentenList()) {
                if (component.getElementaryPID() != thisPID) continue;
                return pmt;
            }
        }
        return null;
    }

    public TSPacket getTSPacket(int packetNo) {
        TSPacket packet = null;
        if (this.offsetHelper.getMaxPacket() > packetNo) {
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");){
                packet = this.readPacket(packetNo, randomAccessFile);
            }
            catch (IOException e) {
                logger.warning("IOException:" + String.valueOf(e));
            }
        } else {
            logger.warning(String.format("offsetHelper.getMaxPacket() (%d) < packetNo (%d)", this.offsetHelper.getMaxPacket(), packetNo));
        }
        return packet;
    }

    private TSPacket readPacket(int packetNo, RandomAccessFile randomAccessFile) throws IOException {
        TSPacket packet = null;
        long offset = this.offsetHelper.getOffset(packetNo);
        randomAccessFile.seek(offset);
        byte[] buf = new byte[this.packetLength];
        int bytesRead = randomAccessFile.read(buf);
        if (bytesRead == this.packetLength) {
            packet = this.isAVCHD() ? new AVCHDPacket(buf, packetNo, this) : new TSPacket(buf, packetNo, this);
            packet.setPacketOffset(offset);
        } else {
            logger.warning(String.format("read less then packetLenghth (%d) bytes, actual read: %d", this.packetLength, bytesRead));
        }
        return packet;
    }

    public long getAVCHDPacketTime(int packetNo) {
        if (this.isAVCHD() && this.packetATS != null) {
            if (this.enabledHumaxAtsFix) {
                return this.rollOverHelper.getRollOver(packetNo) * 0x200001L * 300L + (long)TransportStream.fixHumaxAts(this.packetATS[packetNo]) - (long)TransportStream.fixHumaxAts(this.packetATS[0]);
            }
            return this.rollOverHelper.getRollOver(packetNo) * 0x40000000L + (long)this.packetATS[packetNo] - (long)this.packetATS[0];
        }
        throw new RuntimeException("Not an AVCHD File!");
    }

    private static int fixHumaxAts(int ats) {
        int extension = ats & 0x1FF;
        int base = (ats & 0x3FFFFE00) >> 9;
        return base * 300 + extension;
    }

    public PID getPID(int p) {
        return this.pids[p];
    }

    public int getPacketLenghth() {
        return this.packetLength;
    }

    public long getLen() {
        return this.len;
    }

    public int getSync_errors() {
        return this.sync_errors;
    }

    public int getError_packets() {
        return this.error_packets;
    }

    List<LinkageDescriptor> getLinkageDescriptorsFromNitNetworkLoop() {
        NIT nit = this.psi.getNit();
        int actualNetworkID = nit.getActualNetworkID();
        List<Descriptor> descriptors = nit.getNetworkDescriptors(actualNetworkID);
        return Descriptor.findGenericDescriptorsInList(descriptors, LinkageDescriptor.class);
    }

    public boolean isONTSection(int pid) {
        NIT nit = this.psi.getNit();
        int actualNetworkID = nit.getActualNetworkID();
        List<LinkageDescriptor> linkageDescriptors = this.getLinkageDescriptorsFromNitNetworkLoop();
        int streamID = this.getStreamID();
        int originalNetworkID = nit.getOriginalNetworkID(actualNetworkID, streamID);
        for (LinkageDescriptor ld : linkageDescriptors) {
            if (ld.getLinkageType() != 141 || ld.getTransportStreamId() != streamID || ld.getOriginalNetworkId() != originalNetworkID || ld.getServiceId() != pid || !M7Fastscan.isValidM7Code(ld.getM7_code())) continue;
            return true;
        }
        return false;
    }

    public int getFirstAvchdPacketATS() {
        return this.packetATS[0];
    }
}

