/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.AbstractAC3SyncFrame;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AC3Descriptor
extends Descriptor {
    private final int component_type_flag;
    private final int bsid_flag;
    private final int mainid_flag;
    private final int asvc_flag;
    private final int reserved_flags;
    private int component_type;
    private int bsid;
    private int mainid;
    private int asvc;
    private byte[] additional_info;

    public AC3Descriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.component_type_flag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.bsid_flag = Utils.getInt(b, offset + 2, 1, 64) >> 6;
        this.mainid_flag = Utils.getInt(b, offset + 2, 1, 32) >> 5;
        this.asvc_flag = Utils.getInt(b, offset + 2, 1, 16) >> 4;
        this.reserved_flags = Utils.getInt(b, offset + 2, 1, 15);
        int t = offset + 3;
        if (this.component_type_flag != 0) {
            this.component_type = Utils.getInt(b, t++, 1, 255);
        }
        if (this.bsid_flag != 0) {
            this.bsid = Utils.getInt(b, t++, 1, 255);
        }
        if (this.mainid_flag != 0) {
            this.mainid = Utils.getInt(b, t++, 1, 255);
        }
        if (this.asvc_flag != 0) {
            this.asvc = Utils.getInt(b, t++, 1, 255);
        }
        if (t < this.descriptorLength) {
            this.additional_info = Utils.getBytes(b, t, this.descriptorLength - t);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("component_type_flag", this.component_type_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("bsid_flag", this.bsid_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("mainid_flag", this.mainid_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("asvc_flag", this.asvc_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_flags", this.reserved_flags, null)));
        if (this.component_type_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("component_type", this.component_type, AC3Descriptor.getComponentTypeString(this.component_type))));
        }
        if (this.bsid_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("bsid", this.bsid, AbstractAC3SyncFrame.getBsidString(this.bsid))));
        }
        if (this.mainid_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("mainid", this.mainid, null)));
        }
        if (this.asvc_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("asvc", this.asvc, null)));
        }
        if (this.additional_info != null) {
            t.add(new DefaultMutableTreeNode(new KVP("additional_info", this.additional_info, null)));
        }
        return t;
    }

    public static String getComponentTypeString(int type) {
        StringBuilder s = new StringBuilder();
        if ((type & 0x80) == 128) {
            s.append("Enhanced AC-3, ");
        } else {
            s.append("AC-3, ");
        }
        if ((type & 0x40) == 64) {
            s.append("stream is a full service, ");
        } else {
            s.append("stream is intended to be combined with another audio stream, ");
        }
        if ((type & 7) == 0) {
            s.append("Mono, ");
        } else if ((type & 7) == 1) {
            s.append("1+1 Mode, ");
        } else if ((type & 7) == 2) {
            s.append("2 channel (stereo), ");
        } else if ((type & 7) == 3) {
            s.append("2 channel Dolby Surround encoded (stereo), ");
        } else if ((type & 7) == 4) {
            s.append("Multichannel audio (> 2 channels), ");
        } else if ((type & 0x87) == 133) {
            s.append("Multichannel audio (> 5.1 channels), ");
        } else if ((type & 0x87) == 134) {
            s.append("Elementary stream contains multiple programmes carried in independent substreams, ");
        }
        if ((type & 0x78) == 64) {
            s.append("Complete Main");
        } else if ((type & 0x78) == 8) {
            s.append("Music and Effects");
        } else if ((type & 0x38) == 16) {
            s.append("Visually Impaired");
        } else if ((type & 0x38) == 24) {
            s.append("Hearing Impaired");
        } else if ((type & 0x78) == 32) {
            s.append("Dialogue");
        } else if ((type & 0x3F) == 40) {
            s.append("Commentary");
        } else if ((type & 0x7F) == 112) {
            s.append("Emergency");
        } else if ((type & 0x7F) == 120) {
            s.append("Voiceover");
        } else if ((type & 0x78) == 120) {
            s.append("Karaoke");
        }
        return s.toString();
    }
}

