/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AdaptationFieldDataDescriptor
extends Descriptor {
    private final int adaptationFieldDataIdentifier;

    public AdaptationFieldDataDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.adaptationFieldDataIdentifier = Utils.getInt(b, offset + 2, 1, 255);
    }

    @Override
    public String toString() {
        return super.toString() + "adaptationFieldDataIdentifier=" + this.adaptationFieldDataIdentifier;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("adaptation_field_data_identifier", this.adaptationFieldDataIdentifier, AdaptationFieldDataDescriptor.getAdaptationFieldDataIdentifierString(this.adaptationFieldDataIdentifier))));
        return t;
    }

    private static String getAdaptationFieldDataIdentifierString(int adaptationFieldDataIdentifier) {
        StringBuilder sb = new StringBuilder();
        if ((adaptationFieldDataIdentifier & 1) != 0) {
            sb.append("announcement switching data field");
        }
        if ((adaptationFieldDataIdentifier & 2) != 0) {
            sb.append("AU_information data field");
        }
        if ((adaptationFieldDataIdentifier & 4) != 0) {
            sb.append("PVR_assist_information_data_field");
        }
        return sb.toString();
    }
}

