/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ApplicationSignallingDescriptor
extends Descriptor {
    private List<ApplicationType> applicationTypeList = new ArrayList<ApplicationType>();

    public ApplicationSignallingDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int r = 0; r < this.descriptorLength; r += 3) {
            int application_type = Utils.getInt(b, offset + 2 + r, 2, Short.MAX_VALUE);
            int ait_version = Utils.getInt(b, offset + 4 + r, 1, 31);
            ApplicationType applicationEntry = new ApplicationType(application_type, ait_version);
            this.applicationTypeList.add(applicationEntry);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.applicationTypeList, modus, "Application Information Table");
        return t;
    }

    public List<ApplicationType> getApplicationTypeList() {
        return this.applicationTypeList;
    }

    public static class ApplicationType
    implements TreeNode {
        private final int applicationType;
        private final int aitVersionNumber;

        public ApplicationType(int applicationType, int versionNumber) {
            this.applicationType = applicationType;
            this.aitVersionNumber = versionNumber;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("AIT"));
            s.add(new DefaultMutableTreeNode(new KVP("application_type", this.applicationType, Utils.getAppTypeIDString(this.applicationType))));
            s.add(new DefaultMutableTreeNode(new KVP("AIT_version_number", this.aitVersionNumber, null)));
            return s;
        }

        public int getApplicationType() {
            return this.applicationType;
        }

        public int getAitVersionNumber() {
            return this.aitVersionNumber;
        }
    }
}

