/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AssociationTagDescriptor
extends Descriptor {
    private final int associationTag;
    private final int use;
    private long transactionId;
    private long timeout;
    private int selectorLength;
    private byte[] selectorByte;
    private final byte[] privateDataByte;

    public AssociationTagDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.associationTag = Utils.getInt(b, offset + 2, 2, 65535);
        this.use = Utils.getInt(b, offset + 4, 2, 65535);
        if (this.use == 0) {
            this.selectorLength = Utils.getInt(b, offset + 6, 1, 255);
            this.transactionId = Utils.getLong(b, offset + 7, 4, -1L);
            this.timeout = Utils.getLong(b, offset + 11, 4, -1L);
        } else if (this.use == 1) {
            this.selectorLength = Utils.getInt(b, offset + 6, 1, 255);
        } else {
            this.selectorLength = Utils.getInt(b, offset + 6, 1, 255);
            this.selectorByte = Utils.copyOfRange(b, offset + 7, offset + 7 + this.selectorLength);
        }
        this.privateDataByte = Utils.copyOfRange(b, offset + 7 + this.selectorLength, offset + 2 + this.descriptorLength);
    }

    @Override
    public String toString() {
        return super.toString() + "associationTag=" + this.associationTag;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("association_tag", this.associationTag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("use", this.use, this.getUseString(this.use))));
        if (this.use == 0) {
            t.add(new DefaultMutableTreeNode(new KVP("selector_length", this.selectorLength, null)));
            t.add(new DefaultMutableTreeNode(new KVP("transaction_id", this.transactionId, null)));
            t.add(new DefaultMutableTreeNode(new KVP("timeout", this.timeout, null)));
        } else if (this.use == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("selector_length", this.selectorLength, null)));
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("selector_length", this.selectorLength, null)));
            t.add(new DefaultMutableTreeNode(new KVP("id_selector_bytes", this.selectorByte, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        return t;
    }

    public int getAssociationTag() {
        return this.associationTag;
    }

    public int getUse() {
        return this.use;
    }

    public String getUseString(int use) {
        if (use == 0) {
            return "DSI with IOR of SGW";
        }
        if (use == 1) {
            return "General Object Carousel Data";
        }
        if (use >= 256 && use <= 8191) {
            return "DVB reserved";
        }
        if (use >= 8192 && use <= 65535) {
            return "user private";
        }
        return "unknown";
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getSelectorLength() {
        return this.selectorLength;
    }

    public byte[] getSelectorByte() {
        return this.selectorByte;
    }

    public byte[] getPrivateDataByte() {
        return this.privateDataByte;
    }
}

