/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class AudioStreamDescriptor
extends Descriptor {
    private final int freeFormatFlag;
    private final int id;
    private final int layer;
    private final int variableRateAudioIndicator;
    private final int reserved;

    public AudioStreamDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.freeFormatFlag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.id = Utils.getInt(b, offset + 2, 1, 64) >> 6;
        this.layer = Utils.getInt(b, offset + 2, 1, 48) >> 4;
        this.variableRateAudioIndicator = Utils.getInt(b, offset + 2, 1, 8) >> 3;
        this.reserved = Utils.getInt(b, offset + 2, 1, 7);
    }

    @Override
    public String toString() {
        return super.toString() + " freeFormatFlag" + this.freeFormatFlag;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("free_format_flag", this.freeFormatFlag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("ID", this.id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("layer", this.layer, null)));
        t.add(new DefaultMutableTreeNode(new KVP("variable_rate_audio_indicator", this.variableRateAudioIndicator, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        return t;
    }

    public int getFreeFormatFlag() {
        return this.freeFormatFlag;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getId() {
        return this.id;
    }

    public int getVariableRateAudioIndicator() {
        return this.variableRateAudioIndicator;
    }

    public int getReserved() {
        return this.reserved;
    }
}

