/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CAIdentifierDescriptor
extends Descriptor {
    private final List<CASystemId> CA_system_id = new ArrayList<CASystemId>();

    public CAIdentifierDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 2) {
            int caSystemID = Utils.getInt(b, offset + 2 + t, 2, 65535);
            CASystemId caID = new CASystemId(caSystemID);
            this.CA_system_id.add(caID);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.CA_system_id, modus, "CA_system_id");
        return t;
    }

    public static class CASystemId
    implements TreeNode {
        private final int ca_system_id;

        public CASystemId(int ca_system_id) {
            this.ca_system_id = ca_system_id;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            return new DefaultMutableTreeNode(new KVP("CA_system_id", this.ca_system_id, Utils.getCASystemIDString(this.ca_system_id)));
        }
    }
}

