/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ContentIdentifierDescriptor
extends Descriptor {
    private List<CridEntry> cridEntryList = new ArrayList<CridEntry>();

    public ContentIdentifierDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int r = 0;
        while (r < this.descriptorLength) {
            byte[] crid_byte = null;
            int crid_len = 0;
            int cridRef = 0;
            int type = Utils.getInt(b, offset + 2 + r, 1, 252) >> 2;
            int location = Utils.getInt(b, offset + 2 + r, 1, 3);
            if (location == 0) {
                crid_len = Utils.getInt(b, offset + 3 + r, 1, 255);
                crid_byte = Utils.copyOfRange(b, offset + 4 + r, offset + r + 4 + crid_len);
                r += 2 + crid_len;
            } else if (location == 1) {
                cridRef = Utils.getInt(b, offset + 3 + r, 2, 65535);
                r += 3;
            } else {
                r += 2;
                break;
            }
            CridEntry cridEntry = new CridEntry(type, location, crid_len, crid_byte, cridRef);
            this.cridEntryList.add(cridEntry);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.cridEntryList, modus, "Crid Entries");
        return t;
    }

    public static String getCridTypeString(int type) {
        switch (type) {
            case 0: {
                return "No type defined";
            }
            case 1: {
                return "CRID references the item of content that this event is an instance of.";
            }
            case 2: {
                return "CRID references a series that this event belongs to.";
            }
            case 3: {
                return "CRID references a recommendation. This CRID can be a group or a single item of content.";
            }
            case 49: {
                return "User private; DTG programme CRID (equivalent to type 0x01); CRID references the item of content that this event is an instance of.";
            }
            case 50: {
                return "User private; DTG series CRID (a restriction of type 0x02 to be used only for series); CRID references a series that this event belongs to.";
            }
            case 51: {
                return "User private; DTG recommendation CRID (equivalent to type 0x03); CRID references a recommendation. This CRID can be a group or a single item of content.";
            }
        }
        if (4 <= type && type <= 31) {
            return "DVB reserved";
        }
        if (32 <= type && type <= 63) {
            return "User private";
        }
        return "Illegal value";
    }

    public static String getCridLocationString(int type) {
        switch (type) {
            case 0: {
                return "Carried explicitly within descriptor";
            }
            case 1: {
                return "Carried in Content Identifier Table (CIT)";
            }
            case 2: {
                return "DVB reserved";
            }
            case 3: {
                return "DVB reserved";
            }
        }
        return "Illegal value";
    }

    public static class CridEntry
    implements TreeNode {
        private final int cridType;
        private final int cridLocation;
        private final int cridLength;
        private final byte[] cridByte;
        private final int cridRef;

        public CridEntry(int cridType, int cridLocation, int cridLength, byte[] cridByte, int cridRef) {
            this.cridType = cridType;
            this.cridLocation = cridLocation;
            this.cridLength = cridLength;
            this.cridByte = cridByte;
            this.cridRef = cridRef;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("CRID"));
            s.add(new DefaultMutableTreeNode(new KVP("crid_type", this.cridType, ContentIdentifierDescriptor.getCridTypeString(this.cridType))));
            s.add(new DefaultMutableTreeNode(new KVP("crid_location", this.cridLocation, ContentIdentifierDescriptor.getCridLocationString(this.cridLocation))));
            if (this.cridLocation == 0) {
                s.add(new DefaultMutableTreeNode(new KVP("crid_length", this.cridLength, null)));
                s.add(new DefaultMutableTreeNode(new KVP("crid_byte", this.cridByte, null)));
            } else if (this.cridLocation == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("crid_ref", this.cridRef, null)));
            }
            return s;
        }
    }
}

