/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class CountryAvailabilityDescriptor
extends Descriptor {
    private final int country_availability_flag;
    private final List<Country> countryList = new ArrayList<Country>();

    public CountryAvailabilityDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.country_availability_flag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        for (int t = 0; t < this.descriptorLength - 1; t += 3) {
            String languageCode = Utils.getISO8859_1String(b, offset + t + 3, 3);
            Country s = new Country(languageCode);
            this.countryList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (Country country : this.countryList) {
            buf.append(country.toString());
        }
        return buf.toString();
    }

    public static String getCountryAvailabilityFlagString(int flag) {
        return switch (flag) {
            case 0 -> "reception of the service is not intended";
            case 1 -> "reception of the service is intended";
            default -> "Illegal value";
        };
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("country_availability_flag", this.country_availability_flag, CountryAvailabilityDescriptor.getCountryAvailabilityFlagString(this.country_availability_flag))));
        Utils.addListJTree(t, this.countryList, modus, "country_list");
        return t;
    }

    public static class Country
    implements TreeNode {
        private final String countryCode;

        public Country(String lCode) {
            this.countryCode = lCode;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("country"));
            s.add(new DefaultMutableTreeNode(new KVP("country_code", this.countryCode, null)));
            return s;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String toString() {
            return "code:'" + this.countryCode;
        }
    }
}

