/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class DataBroadcastDescriptor
extends Descriptor {
    private final int dataBroadcastId;
    private final int componentTag;
    private final int selectorLength;
    private final byte[] selectorByte;
    private final String iso639LanguageCode;
    private int MAC_address_range;
    private int MAC_IP_mapping_flag;
    private int alignment_indicator;
    private int max_sections_per_datagram;
    private final int textLength;
    private final byte[] text;

    public DataBroadcastDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.dataBroadcastId = Utils.getInt(b, offset + 2, 2, 65535);
        this.componentTag = Utils.getInt(b, offset + 4, 1, 255);
        this.selectorLength = Utils.getInt(b, offset + 5, 1, 255);
        this.selectorByte = Utils.copyOfRange(b, offset + 6, offset + 6 + this.selectorLength);
        if (this.dataBroadcastId == 5) {
            this.MAC_address_range = Utils.getInt(b, offset + 6, 1, 224) >>> 5;
            this.MAC_IP_mapping_flag = Utils.getInt(b, offset + 6, 1, 16) >>> 4;
            this.alignment_indicator = Utils.getInt(b, offset + 6, 1, 8) >>> 3;
            this.max_sections_per_datagram = Utils.getInt(b, offset + 7, 1, 255);
        }
        this.iso639LanguageCode = Utils.getISO8859_1String(b, offset + 6 + this.selectorLength, 3);
        this.textLength = Utils.getInt(b, offset + 9 + this.selectorLength, 1, 255);
        this.text = Utils.copyOfRange(b, offset + 10 + this.selectorLength, offset + 10 + this.selectorLength + this.textLength);
    }

    @Override
    public String toString() {
        return super.toString() + "dataBroadcastId=" + this.dataBroadcastId;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("data_broadcast_id", this.dataBroadcastId, Utils.getDataBroadCastIDString(this.dataBroadcastId))));
        t.add(new DefaultMutableTreeNode(new KVP("component_tag", this.componentTag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("selector_length", this.selectorLength, null)));
        if (this.dataBroadcastId == 5) {
            t.add(new DefaultMutableTreeNode(new KVP("MAC_address_range", this.MAC_address_range, DataBroadcastDescriptor.getvalidMACaddressBytesString(this.MAC_address_range))));
            t.add(new DefaultMutableTreeNode(new KVP("MAC_IP_mapping_flag", this.MAC_IP_mapping_flag, this.MAC_IP_mapping_flag == 1 ? "uses IP to MAC mapping as described in RFC 1112 and RFC 2464" : "mapping not defined")));
            t.add(new DefaultMutableTreeNode(new KVP("alignment_indicator", this.alignment_indicator, this.alignment_indicator == 1 ? "alignment in bits: 32" : "alignment in bits: 8 (default)")));
            t.add(new DefaultMutableTreeNode(new KVP("max_sections_per_datagram", this.max_sections_per_datagram, null)));
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("selector_bytes", this.selectorByte, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("ISO_639_language_code", this.iso639LanguageCode, null)));
        t.add(new DefaultMutableTreeNode(new KVP("text_length", this.textLength, null)));
        t.add(new DefaultMutableTreeNode(new KVP("text_char", this.text, null)));
        return t;
    }

    public static String getvalidMACaddressBytesString(int adresReange) {
        switch (adresReange) {
            case 0: {
                return "reserved";
            }
            case 1: {
                return "valid MAC_address bytes: 6";
            }
            case 2: {
                return "valid MAC_address bytes: 6,5";
            }
            case 3: {
                return "valid MAC_address bytes: 6,5,4";
            }
            case 4: {
                return "valid MAC_address bytes: 6,5,4,3";
            }
            case 5: {
                return "valid MAC_address bytes: 6,5,4,3,2";
            }
            case 6: {
                return "valid MAC_address bytes: 6,5,4,3,2,1";
            }
        }
        return "reserved";
    }
}

