/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DataBroadcastDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class DataBroadcastIDDescriptor
extends Descriptor {
    private final List<OUIEntry> ouiList = new ArrayList<OUIEntry>();
    private final List<ApplicationType> applicationTypeList = new ArrayList<ApplicationType>();
    private final List<MHEG5ApplicationType> mheg5ApplicationTypeList = new ArrayList<MHEG5ApplicationType>();
    private final List<Platform> platformList = new ArrayList<Platform>();
    private static Set<Integer> BROADCASTIDS_WITH_OBJECT_CAROUSEL = Set.of(Integer.valueOf(7), Integer.valueOf(240), Integer.valueOf(262), Integer.valueOf(291), Integer.valueOf(336), Integer.valueOf(48050));
    private final int dataBroadcastId;
    private int OUI_data_length;
    private int platform_id_data_length;
    private byte[] selectorByte;
    private byte[] privateDataByte;
    private int MAC_address_range;
    private int MAC_IP_mapping_flag;
    private int alignment_indicator;
    private int max_sections_per_datagram;

    public DataBroadcastIDDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.dataBroadcastId = Utils.getInt(b, offset + 2, 2, 65535);
        if (this.dataBroadcastId == 5) {
            this.MAC_address_range = Utils.getInt(b, offset + 4, 1, 224) >>> 5;
            this.MAC_IP_mapping_flag = Utils.getInt(b, offset + 4, 1, 16) >>> 4;
            this.alignment_indicator = Utils.getInt(b, offset + 4, 1, 8) >>> 3;
            this.max_sections_per_datagram = Utils.getInt(b, offset + 5, 1, 255);
        } else if (this.dataBroadcastId == 10) {
            this.OUI_data_length = Utils.getInt(b, offset + 4, 1, 255);
            int r = 0;
            while (r < this.OUI_data_length) {
                int oui = Utils.getInt(b, offset + 5 + r, 3, 0xFFFFFF);
                int updateType = Utils.getInt(b, offset + 8 + r, 1, 15);
                int updateVersioningFlag = Utils.getInt(b, offset + 9 + r, 1, 32) >> 5;
                int updateVersion = Utils.getInt(b, offset + 9 + r, 1, 31);
                int selectorLength = Utils.getInt(b, offset + r + 10, 1, 255);
                byte[] selector_byte = Arrays.copyOfRange(b, offset + r + 11, offset + r + 11 + selectorLength);
                OUIEntry ouiEntry = new OUIEntry(oui, updateType, updateVersioningFlag, updateVersion, selectorLength, selector_byte);
                this.ouiList.add(ouiEntry);
                r = r + 6 + selectorLength;
            }
            this.privateDataByte = Arrays.copyOfRange(b, offset + 5 + r, offset + this.descriptorLength + 2);
        } else if (this.dataBroadcastId == 11) {
            int r;
            this.platform_id_data_length = Utils.getInt(b, offset + 4, 1, 255);
            for (r = 0; r < this.platform_id_data_length; r += 5) {
                int platform_id = Utils.getInt(b, offset + 5 + r, 3, 0xFFFFFF);
                int action_type = Utils.getInt(b, offset + 8 + r, 1, 255);
                int INT_versioning_flag = Utils.getInt(b, offset + 9 + r, 1, 32) >>> 5;
                int INT_version = Utils.getInt(b, offset + 9 + r, 1, 31);
                Platform p = new Platform(platform_id, action_type, INT_versioning_flag, INT_version);
                this.platformList.add(p);
            }
            this.privateDataByte = Arrays.copyOfRange(b, offset + 5 + r, offset + this.descriptorLength + 2);
        } else if (this.dataBroadcastId == 240 || this.dataBroadcastId == 241) {
            for (int r = 0; r < this.descriptorLength - 2; r += 2) {
                int at = Utils.getInt(b, offset + 4 + r, 2, Short.MAX_VALUE);
                ApplicationType appT = new ApplicationType(at);
                this.applicationTypeList.add(appT);
            }
        } else if (this.dataBroadcastId == 262) {
            int r = 0;
            while (r < this.descriptorLength - 2) {
                int at = Utils.getInt(b, offset + 4 + r, 2, 65535);
                int bootPrio = Utils.getInt(b, offset + 6 + r, 1, 255);
                int appDataLen = Utils.getInt(b, offset + 7 + r, 1, 255);
                byte[] appData = Arrays.copyOfRange(b, offset + r + 8, offset + r + 8 + appDataLen);
                MHEG5ApplicationType mheg5App = new MHEG5ApplicationType(at, bootPrio, appDataLen, appData);
                this.mheg5ApplicationTypeList.add(mheg5App);
                r = r + 4 + appDataLen;
            }
        } else {
            this.selectorByte = Arrays.copyOfRange(b, offset + 4, offset + this.descriptorLength + 2);
        }
    }

    public String getUpdateTypeString(int updateType) {
        switch (updateType) {
            case 0: {
                return "proprietary update solution";
            }
            case 1: {
                return "standard update carousel (i.e. without notification table) via broadcast";
            }
            case 2: {
                return "system software Update with Notification Table (UNT) via broadcast";
            }
            case 3: {
                return "system software update using return channel with UNT";
            }
        }
        return "reserved for future use";
    }

    @Override
    public String toString() {
        return super.toString() + "dataBroadcastId=" + this.dataBroadcastId;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("data_broadcast_id", this.dataBroadcastId, Utils.getDataBroadCastIDString(this.dataBroadcastId))));
        if (this.dataBroadcastId == 5) {
            t.add(new DefaultMutableTreeNode(new KVP("MAC_address_range", this.MAC_address_range, DataBroadcastDescriptor.getvalidMACaddressBytesString(this.MAC_address_range))));
            t.add(new DefaultMutableTreeNode(new KVP("MAC_IP_mapping_flag", this.MAC_IP_mapping_flag, this.MAC_IP_mapping_flag == 1 ? "uses IP to MAC mapping as described in RFC 1112 and RFC 2464" : "mapping not defined")));
            t.add(new DefaultMutableTreeNode(new KVP("alignment_indicator", this.alignment_indicator, this.alignment_indicator == 1 ? "alignment in bits: 32" : "alignment in bits: 8 (default)")));
            t.add(new DefaultMutableTreeNode(new KVP("max_sections_per_datagram", this.max_sections_per_datagram, null)));
        } else if (this.dataBroadcastId == 10) {
            Utils.addListJTree(t, this.ouiList, modus, "Systems Software Update");
            t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        } else if (this.dataBroadcastId == 11) {
            Utils.addListJTree(t, this.platformList, modus, "IP/MAC platform");
            t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.privateDataByte, null)));
        } else if (this.dataBroadcastId == 240 || this.dataBroadcastId == 241) {
            Utils.addListJTree(t, this.applicationTypeList, modus, "application_type");
        } else if (this.dataBroadcastId == 262) {
            Utils.addListJTree(t, this.mheg5ApplicationTypeList, modus, "MHEG5 Applications");
        } else {
            t.add(new DefaultMutableTreeNode(new KVP("id_selector_bytes", this.selectorByte, null)));
        }
        return t;
    }

    public boolean describesObjectCarousel() {
        return BROADCASTIDS_WITH_OBJECT_CAROUSEL.contains(this.getDataBroadcastId());
    }

    public boolean describesSSU() {
        if (this.getDataBroadcastId() == 10) {
            for (OUIEntry entry : this.ouiList) {
                if (entry.getUpdateType() != 1 && entry.getUpdateType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    public int getAlignment_indicator() {
        return this.alignment_indicator;
    }

    public List<ApplicationType> getApplicationTypeList() {
        return this.applicationTypeList;
    }

    public int getDataBroadcastId() {
        return this.dataBroadcastId;
    }

    public int getMAC_address_range() {
        return this.MAC_address_range;
    }

    public int getMAC_IP_mapping_flag() {
        return this.MAC_IP_mapping_flag;
    }

    public int getMax_sections_per_datagram() {
        return this.max_sections_per_datagram;
    }

    public int getOUI_data_length() {
        return this.OUI_data_length;
    }

    public List<OUIEntry> getOuiList() {
        return this.ouiList;
    }

    public int getPlatform_id_data_length() {
        return this.platform_id_data_length;
    }

    public List<Platform> getPlatformList() {
        return this.platformList;
    }

    public byte[] getPrivateDataByte() {
        return this.privateDataByte;
    }

    public byte[] getSelectorByte() {
        return this.selectorByte;
    }

    public static String getMHEG5ApplicationTypeString(int appType) {
        switch (appType) {
            case 0: {
                return "NULL_APPLICATION_TYPE";
            }
            case 257: {
                return "UK_PROFILE_LAUNCH";
            }
            case 1285: {
                return "UK_PROFILE_BASELINE_1";
            }
        }
        return "unknown";
    }

    public class OUIEntry
    implements TreeNode {
        private final int oui;
        private final int updateType;
        private final int updateVersioningFlag;
        private final int updateVersion;
        private final int selectorLength;
        private final byte[] ouiSelectorBytes;

        public OUIEntry(int oui, int updateType, int updateVersioningFlag, int updateVersion, int selectorLength, byte[] selectorByte) {
            this.oui = oui;
            this.updateType = updateType;
            this.updateVersioningFlag = updateVersioningFlag;
            this.updateVersion = updateVersion;
            this.selectorLength = selectorLength;
            this.ouiSelectorBytes = selectorByte;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("OUI"));
            s.add(new DefaultMutableTreeNode(new KVP("oui", this.oui, Utils.getOUIString(this.oui))));
            s.add(new DefaultMutableTreeNode(new KVP("update_type", this.updateType, DataBroadcastIDDescriptor.this.getUpdateTypeString(this.updateType))));
            s.add(new DefaultMutableTreeNode(new KVP("update_versioning_flag", this.updateVersioningFlag, this.updateVersioningFlag == 0 ? "no relevant versioning information is carried in the version field" : "version field reflects changes in the system software update service component")));
            s.add(new DefaultMutableTreeNode(new KVP("update_version", this.updateVersion, null)));
            s.add(new DefaultMutableTreeNode(new KVP("selector_length", this.selectorLength, null)));
            s.add(new DefaultMutableTreeNode(new KVP("selector_bytes", this.ouiSelectorBytes, null)));
            return s;
        }

        public int getOui() {
            return this.oui;
        }

        public byte[] getSelectorByte() {
            return this.ouiSelectorBytes;
        }

        public int getSelectorLength() {
            return this.selectorLength;
        }

        public int getUpdateType() {
            return this.updateType;
        }

        public int getUpdateVersion() {
            return this.updateVersion;
        }

        public int getUpdateVersioningFlag() {
            return this.updateVersioningFlag;
        }
    }

    public static class Platform
    implements TreeNode {
        private final int platform_id;
        private final int action_type;
        private final int INT_versioning_flag;
        private final int INT_version;

        public Platform(int platform_id, int action_type, int int_versioning_flag, int int_version) {
            this.platform_id = platform_id;
            this.action_type = action_type;
            this.INT_versioning_flag = int_versioning_flag;
            this.INT_version = int_version;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("platforms"));
            s.add(new DefaultMutableTreeNode(new KVP("platform_id", this.platform_id, Utils.getPlatformIDString(this.platform_id))));
            s.add(new DefaultMutableTreeNode(new KVP("action_type", this.action_type, Utils.getActionTypeString(this.action_type))));
            s.add(new DefaultMutableTreeNode(new KVP("INT_versioning_flag", this.INT_versioning_flag, null)));
            s.add(new DefaultMutableTreeNode(new KVP("INT_version", this.INT_version, null)));
            return s;
        }
    }

    public static class ApplicationType
    implements TreeNode {
        private final int applicationType;

        public ApplicationType(int applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            return new DefaultMutableTreeNode(new KVP("application_type", this.applicationType, Utils.getAppTypeIDString(this.applicationType)));
        }
    }

    public static class MHEG5ApplicationType
    implements TreeNode {
        private final int applicationTypeCode;
        private final int boot_priority_hint;
        private final int application_specific_data_length;
        private final byte[] application_specific_data_byte;

        public MHEG5ApplicationType(int applicationType, int bootPriorityHint, int applicationSpecificDataLength, byte[] data) {
            this.applicationTypeCode = applicationType;
            this.boot_priority_hint = bootPriorityHint;
            this.application_specific_data_length = applicationSpecificDataLength;
            this.application_specific_data_byte = data;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("MHEG5ApplicationType"));
            s.add(new DefaultMutableTreeNode(new KVP("application_type_code", this.applicationTypeCode, DataBroadcastIDDescriptor.getMHEG5ApplicationTypeString(this.applicationTypeCode))));
            s.add(new DefaultMutableTreeNode(new KVP("boot_priority_hint", this.boot_priority_hint, null)));
            s.add(new DefaultMutableTreeNode(new KVP("application_specific_data_length", this.application_specific_data_length, null)));
            s.add(new DefaultMutableTreeNode(new KVP("application_specific_data_byte", this.application_specific_data_byte, null)));
            return s;
        }
    }
}

