/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class DataStreamAlignmentDescriptor
extends Descriptor {
    private final int alignmentType;

    public DataStreamAlignmentDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.alignmentType = Utils.getInt(b, offset + 2, 1, 255);
    }

    public int getAlignmentType() {
        return this.alignmentType;
    }

    public String getAlignmentTypeString(int alignment) {
        switch (alignment) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "Slice, or video access unit";
            }
            case 2: {
                return "Video access unit";
            }
            case 3: {
                return "GOP, or SEQ";
            }
            case 4: {
                return "SEQ";
            }
        }
        return "Reserved";
    }

    @Override
    public String toString() {
        return super.toString() + "alignmentType=" + this.alignmentType;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("alignmentType", this.alignmentType, this.getAlignmentTypeString(this.alignmentType))));
        return t;
    }
}

