/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.AC3Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.AbstractAC3SyncFrame;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class EnhancedAC3Descriptor
extends Descriptor {
    private final int component_type_flag;
    private final int bsid_flag;
    private final int mainid_flag;
    private final int asvc_flag;
    private final int mixinfoexists;
    private final int substream1_flag;
    private final int substream2_flag;
    private final int substream3_flag;
    private int component_type;
    private int bsid;
    private int mainid;
    private int asvc;
    private int substream1;
    private int substream2;
    private int substream3;
    private byte[] additional_info;

    public EnhancedAC3Descriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.component_type_flag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.bsid_flag = Utils.getInt(b, offset + 2, 1, 64) >> 6;
        this.mainid_flag = Utils.getInt(b, offset + 2, 1, 32) >> 5;
        this.asvc_flag = Utils.getInt(b, offset + 2, 1, 16) >> 4;
        this.mixinfoexists = Utils.getInt(b, offset + 2, 1, 8) >> 3;
        this.substream1_flag = Utils.getInt(b, offset + 2, 1, 4) >> 2;
        this.substream2_flag = Utils.getInt(b, offset + 2, 1, 2) >> 1;
        this.substream3_flag = Utils.getInt(b, offset + 2, 1, 1);
        int t = offset + 3;
        if (this.component_type_flag != 0) {
            this.component_type = Utils.getInt(b, t++, 1, 255);
        }
        if (this.bsid_flag != 0) {
            this.bsid = Utils.getInt(b, t++, 1, 255);
        }
        if (this.mainid_flag != 0) {
            this.mainid = Utils.getInt(b, t++, 1, 255);
        }
        if (this.asvc_flag != 0) {
            this.asvc = Utils.getInt(b, t++, 1, 255);
        }
        if (this.substream1_flag != 0) {
            this.substream1 = Utils.getInt(b, t++, 1, 255);
        }
        if (this.substream2_flag != 0) {
            this.substream2 = Utils.getInt(b, t++, 1, 255);
        }
        if (this.substream3_flag != 0) {
            this.substream3 = Utils.getInt(b, t++, 1, 255);
        }
        if (t < this.descriptorLength) {
            this.additional_info = Utils.getBytes(b, t, this.descriptorLength - t);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("component_type_flag", this.component_type_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("bsid_flag", this.bsid_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("mainid_flag", this.mainid_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("asvc_flag", this.asvc_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("mixinfoexists", this.mixinfoexists, null)));
        t.add(new DefaultMutableTreeNode(new KVP("substream1_flag", this.substream1_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("substream2_flag", this.substream2_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("substream3_flag", this.substream3_flag, null)));
        if (this.component_type_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("component_type", this.component_type, AC3Descriptor.getComponentTypeString(this.component_type))));
        }
        if (this.bsid_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("bsid", this.bsid, AbstractAC3SyncFrame.getBsidString(this.bsid))));
        }
        if (this.mainid_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("mainid", this.mainid, null)));
        }
        if (this.asvc_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("asvc", this.asvc, null)));
        }
        if (this.substream1_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("substream1", this.substream1, "type of audio carried in independent substream 1 of the Enhanced AC-3 elementary stream")));
        }
        if (this.substream2_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("substream2", this.substream2, "type of audio carried in independent substream 2 of the Enhanced AC-3 elementary stream")));
        }
        if (this.substream3_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("substream3", this.substream3, "type of audio carried in independent substream 3 of the Enhanced AC-3 elementary stream")));
        }
        if (this.additional_info != null) {
            t.add(new DefaultMutableTreeNode(new KVP("additional_info", this.additional_info, null)));
        }
        return t;
    }
}

