/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.LanguageDependentEitDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ExtendedEventDescriptor
extends LanguageDependentEitDescriptor {
    private final int descriptorNumber;
    private final int lastDescriptorNumber;
    private String iso639LanguageCode;
    private final int lengthOfItems;
    private final List<Item> itemList = new ArrayList<Item>();
    private final DVBString text;

    public ExtendedEventDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int item_length;
        int item_description_length;
        this.descriptorNumber = Utils.getInt(b, 2, 1, 240) >> 4;
        this.lastDescriptorNumber = Utils.getInt(b, 2, 1, 15);
        this.iso639LanguageCode = Utils.getISO8859_1String(b, 3, 3);
        this.lengthOfItems = Utils.getInt(b, 6, 1, 255);
        for (int t = 7; t < this.lengthOfItems + 7; t += 2 + item_description_length + item_length) {
            item_description_length = Utils.getInt(b, t, 1, 255);
            DVBString item_descripton = new DVBString(b, t);
            item_length = Utils.getInt(b, t + 1 + item_description_length, 1, 255);
            DVBString item = new DVBString(b, t + 1 + item_description_length);
            Item i = new Item(item_descripton, item);
            this.itemList.add(i);
        }
        this.text = new DVBString(b, 7 + this.lengthOfItems);
    }

    @Override
    public String getIso639LanguageCode() {
        return this.iso639LanguageCode;
    }

    @Override
    public String toString() {
        return super.toString() + " text=" + String.valueOf(this.text);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        if (Utils.simpleModus(modus)) {
            t.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            Utils.addListJTree(t, this.itemList, modus, "items");
            if (this.text.getLength() > 0) {
                t.add(new KVP("text", this.text));
            }
        } else {
            t.add(new KVP("descriptor_number", this.descriptorNumber));
            t.add(new KVP("last_descriptor_number", this.lastDescriptorNumber));
            t.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            t.add(new KVP("length_of_items", this.lengthOfItems));
            Utils.addListJTree(t, this.itemList, modus, "items");
            t.add(new KVP("text", this.text));
        }
        return t;
    }

    public int getDescriptorNumber() {
        return this.descriptorNumber;
    }

    public int getLastDescriptorNumber() {
        return this.lastDescriptorNumber;
    }

    public int getLengthOfItems() {
        return this.lengthOfItems;
    }

    public List<Item> getItemList() {
        return this.itemList;
    }

    public DVBString getText() {
        return this.text;
    }

    public record Item(DVBString itemDescription, DVBString item) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s;
            if (Utils.simpleModus(modus)) {
                s = new KVP("item", String.valueOf(this.itemDescription) + ": " + String.valueOf(this.item), null);
            } else {
                s = new KVP("item");
                s.add(new KVP("item_description", this.itemDescription));
                s.add(new KVP("item", this.item));
            }
            return s;
        }
    }
}

