/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class FTAContentManagmentDescriptor
extends Descriptor {
    private final int user_defined;
    private int reserved_future_use;
    private int do_not_scramble;
    private int control_remote_access_over_internet;
    private int do_not_apply_revocation;

    public FTAContentManagmentDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.user_defined = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.reserved_future_use = Utils.getInt(b, offset + 2, 1, 112) >> 4;
        this.do_not_scramble = Utils.getInt(b, offset + 2, 1, 8) >> 3;
        this.control_remote_access_over_internet = Utils.getInt(b, offset + 2, 1, 6) >> 1;
        this.do_not_apply_revocation = Utils.getInt(b, offset + 2, 1, 1);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("user_defined", this.user_defined, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_future_use", this.reserved_future_use, null)));
        t.add(new DefaultMutableTreeNode(new KVP("do_not_scramble", this.do_not_scramble, this.do_not_scramble == 1 ? "scrambling shall not be appied for the purpose of content protection" : "scrambling shall be appied where applicable for content protection")));
        t.add(new DefaultMutableTreeNode(new KVP("control_remote_access_over_internet", this.control_remote_access_over_internet, FTAContentManagmentDescriptor.getControlRemoteAccesOverInternetString(this.control_remote_access_over_internet))));
        t.add(new DefaultMutableTreeNode(new KVP("do_not_apply_revocation", this.do_not_apply_revocation, this.do_not_apply_revocation == 1 ? "content revocation process shall not be applied" : "content revocation process shall be applied")));
        return t;
    }

    public static String getControlRemoteAccesOverInternetString(int control_remote_access_over_internet) {
        switch (control_remote_access_over_internet) {
            case 0: {
                return "Redistribution over the Internet is enabled";
            }
            case 1: {
                return "Redistribution over the Internet is enabled but only within a managed domain";
            }
            case 2: {
                return "Redistribution over the Internet is enabled but only within a managed domain and after a certain short period of time (e.g. 24 hours)";
            }
            case 3: {
                return "Redistribution over the Internet is not allowed with the following exception: Redistribution over the Internet within a managed domain is enabled after a specified long (possibly indefinite) period of time";
            }
        }
        return "Illegal value";
    }
}

