/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class IBPDescriptor
extends Descriptor {
    private int closed_gop_flag;
    private int identical_gop_flag;
    private int max_gop_length;

    public IBPDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.closed_gop_flag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.identical_gop_flag = Utils.getInt(b, offset + 2, 1, 64) >> 6;
        this.max_gop_length = Utils.getInt(b, offset + 2, 2, 16383);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("closed_gop_flag", this.closed_gop_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("identical_gop_flag", this.identical_gop_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("max_gop_length", this.max_gop_length, null)));
        return t;
    }

    public int getClosed_gop_flag() {
        return this.closed_gop_flag;
    }

    public int getIdentical_gop_flag() {
        return this.identical_gop_flag;
    }

    public int getMax_gop_length() {
        return this.max_gop_length;
    }
}

