/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class JPEG2000VideoDescriptor
extends Descriptor {
    private int profile_and_level;
    private int horizontal_size;
    private int vertical_size;
    private int max_bit_rate;
    private int max_buffer_size;
    private int DEN_frame_rate;
    private int NUM_frame_rate;
    private int color_specification;
    private int still_mode;
    private int interlaced_video;
    private int reserved;
    private byte[] private_data_byte = new byte[0];

    public JPEG2000VideoDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int byteOffset = offset + 2;
        this.profile_and_level = Utils.getInt(b, byteOffset, 2, 65535);
        this.horizontal_size = Utils.getInt(b, byteOffset += 2, 4, -1);
        this.vertical_size = Utils.getInt(b, byteOffset += 4, 4, -1);
        this.max_bit_rate = Utils.getInt(b, byteOffset += 4, 4, -1);
        this.max_buffer_size = Utils.getInt(b, byteOffset += 4, 4, -1);
        this.DEN_frame_rate = Utils.getInt(b, byteOffset += 4, 2, 65535);
        this.NUM_frame_rate = Utils.getInt(b, byteOffset += 2, 2, 65535);
        this.color_specification = Utils.getInt(b, byteOffset += 2, 1, 65535);
        byte aByte = (byte)Utils.getInt(b, ++byteOffset, 1, 65535);
        this.still_mode = Utils.getBit(aByte, 1);
        this.interlaced_video = Utils.getBit(aByte, 2);
        this.reserved = Utils.getBits(aByte, 3, 6);
        if (++byteOffset < this.descriptorLength) {
            this.private_data_byte = Utils.getBytes(b, byteOffset, this.descriptorLength - byteOffset);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " profile_and_level" + this.profile_and_level;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("profile_and_level", this.profile_and_level, JPEG2000VideoDescriptor.getProfile_and_levelString(this.profile_and_level))));
        t.add(new DefaultMutableTreeNode(new KVP("horizontal_size", this.horizontal_size, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vertical_size", this.vertical_size, null)));
        t.add(new DefaultMutableTreeNode(new KVP("max_bit_rate", this.max_bit_rate, null)));
        t.add(new DefaultMutableTreeNode(new KVP("max_buffer_size", this.max_buffer_size, null)));
        t.add(new DefaultMutableTreeNode(new KVP("DEN_frame_rate", this.DEN_frame_rate, null)));
        t.add(new DefaultMutableTreeNode(new KVP("NUM_frame_rate", this.NUM_frame_rate, null)));
        t.add(new DefaultMutableTreeNode(new KVP("color_specification", this.color_specification, null)));
        t.add(new DefaultMutableTreeNode(new KVP("still_mode", this.still_mode, null)));
        t.add(new DefaultMutableTreeNode(new KVP("interlaced_video", this.interlaced_video, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.private_data_byte, null)));
        return t;
    }

    public int getProfile_and_level() {
        return this.profile_and_level;
    }

    public static String getProfile_and_levelString(int profile_and_level) {
        return "";
    }

    public void setProfile_and_level(int serviceType) {
        this.profile_and_level = serviceType;
    }

    public int getVertical_size() {
        return this.vertical_size;
    }

    public void setVertical_size(int serviceNameLength) {
        this.vertical_size = serviceNameLength;
    }

    public int getHorizontal_size() {
        return this.horizontal_size;
    }

    public void setHorizontal_size(int serviceProviderNameLength) {
        this.horizontal_size = serviceProviderNameLength;
    }

    public int getNUM_frame_rate() {
        return this.NUM_frame_rate;
    }

    public void setNUM_frame_rate(int NUM_frame_rate) {
        this.NUM_frame_rate = NUM_frame_rate;
    }

    public int getMax_bit_rate() {
        return this.max_bit_rate;
    }

    public void setMax_bit_rate(int max_bit_rate) {
        this.max_bit_rate = max_bit_rate;
    }

    public int getColor_specification() {
        return this.color_specification;
    }

    public void setColor_specification(int color_specification) {
        this.color_specification = color_specification;
    }

    public int getDEN_frame_rate() {
        return this.DEN_frame_rate;
    }

    public void setDEN_frame_rate(int DEN_frame_rate) {
        this.DEN_frame_rate = DEN_frame_rate;
    }

    public int getStill_mode() {
        return this.still_mode;
    }

    public void setStill_mode(int still_mode) {
        this.still_mode = still_mode;
    }

    public int getMax_buffer_size() {
        return this.max_buffer_size;
    }

    public void setMax_buffer_size(int max_buffer_size) {
        this.max_buffer_size = max_buffer_size;
    }

    public int getInterlaced_video() {
        return this.interlaced_video;
    }

    public void setInterlaced_video(int interlaced_video) {
        this.interlaced_video = interlaced_video;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public byte[] getPrivate_data_byte() {
        return this.private_data_byte;
    }

    public void setPrivate_data_byte(byte[] private_data_byte) {
        this.private_data_byte = private_data_byte;
    }
}

