/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class LocalTimeOffsetDescriptor
extends Descriptor {
    private List<LocalTimeOffset> offsetList = new ArrayList<LocalTimeOffset>();

    public LocalTimeOffsetDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 13) {
            String countryCode = Utils.getISO8859_1String(b, offset + 2 + t, 3);
            int countryRegionId = Utils.getInt(b, offset + t + 5, 1, 252) >> 2;
            int localTimeOffsetPolarity = Utils.getInt(b, offset + t + 5, 1, 1);
            byte[] localTimeOffset = Arrays.copyOfRange(b, offset + t + 6, offset + t + 8);
            byte[] timeOfChange = Arrays.copyOfRange(b, offset + t + 8, offset + t + 13);
            byte[] nextTimeOffset = Arrays.copyOfRange(b, offset + t + 13, offset + t + 15);
            LocalTimeOffset s = new LocalTimeOffset(countryCode, countryRegionId, localTimeOffsetPolarity, localTimeOffset, timeOfChange, nextTimeOffset);
            this.offsetList.add(s);
        }
    }

    public int getNoServices() {
        return this.offsetList.size();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (int i = 0; i < this.getNoServices(); ++i) {
            LocalTimeOffset s = this.offsetList.get(i);
            buf.append("(").append(i).append(";").append(s.getCountryCode()).append(", time of next change").append(s.getTimeOfChangeString());
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.offsetList, modus, "time_offset");
        return t;
    }

    public List<LocalTimeOffset> getOffsetList() {
        return this.offsetList;
    }

    public static class LocalTimeOffset
    implements TreeNode {
        private final String countryCode;
        private final int countryRegionId;
        private final int localTimeOffsetPolarity;
        private final byte[] localTimeOffset;
        private final byte[] timeOfChange;
        private final String timeOfChangeString;
        private final byte[] nextTimeOffset;

        public LocalTimeOffset(String c, int id, int localPolarity, byte[] localOffset, byte[] timeChange, byte[] nextOffset) {
            this.countryCode = c;
            this.countryRegionId = id;
            this.localTimeOffsetPolarity = localPolarity;
            this.localTimeOffset = localOffset;
            this.timeOfChange = timeChange;
            this.timeOfChangeString = Utils.getUTCFormattedString(this.timeOfChange);
            this.nextTimeOffset = nextOffset;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public int getCountryRegionId() {
            return this.countryRegionId;
        }

        public int getLocalTimeOffsetPolarity() {
            return this.localTimeOffsetPolarity;
        }

        public byte[] getTimeOfChange() {
            return this.timeOfChange;
        }

        public String getTimeOfChangeString() {
            return this.timeOfChangeString;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("time_offset"));
            s.add(new DefaultMutableTreeNode(new KVP("country_code", this.countryCode, null)));
            s.add(new DefaultMutableTreeNode(new KVP("country_region_id", this.countryRegionId, null)));
            s.add(new DefaultMutableTreeNode(new KVP("local_time_offset_polarity", this.localTimeOffsetPolarity, null)));
            s.add(new DefaultMutableTreeNode(new KVP("local_time_offset", this.localTimeOffset, null)));
            s.add(new DefaultMutableTreeNode(new KVP("time_of_change", this.timeOfChange, this.timeOfChangeString)));
            s.add(new DefaultMutableTreeNode(new KVP("next_time_offset", this.nextTimeOffset, null)));
            return s;
        }

        public byte[] getLocalTimeOffset() {
            return this.localTimeOffset;
        }

        public byte[] getNextTimeOffset() {
            return this.nextTimeOffset;
        }

        public String getLocalOffsetString() {
            StringBuilder sb = new StringBuilder();
            if (this.localTimeOffsetPolarity == 0) {
                sb.append("+");
            } else {
                sb.append("-");
            }
            sb.append(Utils.getBCD(this.localTimeOffset, 0, 2)).append(":").append(Utils.getBCD(this.localTimeOffset, 2, 2));
            return sb.toString();
        }

        public String getNextTimeOffsetString() {
            StringBuilder sb = new StringBuilder();
            if (this.localTimeOffsetPolarity == 0) {
                sb.append("+");
            } else {
                sb.append("-");
            }
            sb.append(Utils.getBCD(this.nextTimeOffset, 0, 2)).append(":").append(Utils.getBCD(this.nextTimeOffset, 2, 2));
            return sb.toString();
        }
    }
}

