/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MaximumBitrateDescriptor
extends Descriptor {
    private int reserved;
    private int maximumBitrate;

    public MaximumBitrateDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.reserved = Utils.getInt(b, offset + 2, 2, 3);
        this.maximumBitrate = Utils.getInt(b, offset + 2, 3, 0x3FFFFF);
    }

    @Override
    public String toString() {
        return super.toString() + "maximumBitrate=" + this.maximumBitrate;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("maximum_bitrate", this.maximumBitrate, KVP.formatInt(this.maximumBitrate * 50) + " bytes/second")));
        return t;
    }

    public int getMaximumBitrate() {
        return this.maximumBitrate;
    }

    public void setMaximumBitrate(int maximumBitrate) {
        this.maximumBitrate = maximumBitrate;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserverd) {
        this.reserved = reserverd;
    }
}

