/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class MetaDataDescriptor
extends Descriptor {
    private static LookUpList decoder_config_flags_list = new LookUpList.Builder().add(0, "No decoder configuration is needed").add(1, "The decoder configuration is carried in this descriptor in the decoder_config_byte field").add(2, "The decoder configuration is carried in the same metadata service as to which this metadata descriptor applies").add(3, "The decoder configuration is carried in a DSM-CC carousel. This value shall only be used if the metadata service to which this descriptor applies is using the same type of DSM-CC carousel").add(4, "The decoder configuration is carried in another metadata service within the same program, as identified by the decoder_config_metadata_service_id field in this metadata descriptor").add(5, 6, "Reserved").add(7, "Privately defined").build();
    private int metadata_application_format;
    private long metadata_application_format_identifier;
    private int metadata_format;
    private long metadata_format_identifier;
    private int metadata_service_id;
    private int decoder_config_flags;
    private int dsm_cc_flag;
    private int reserved;
    private int service_identification_length = 0;
    private byte[] service_identification_record_byte;
    private int decoder_config_length;
    private byte[] decoder_config_byte;
    private byte[] dec_config_identification_record_byte;
    private int dec_config_identification_record_length;
    private int decoder_config_metadata_service_id;
    private int reserved_data_length;
    private byte[] reserved2;
    private byte[] private_data_byte;

    public MetaDataDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int localOffset = offset + 2;
        this.metadata_application_format = Utils.getInt(b, localOffset, 2, 65535);
        localOffset += 2;
        if (this.metadata_application_format == 65535) {
            this.metadata_application_format_identifier = Utils.getLong(b, localOffset, 4, -1L);
            localOffset += 4;
        }
        this.metadata_format = Utils.getInt(b, localOffset++, 1, 255);
        if (this.metadata_format == 255) {
            this.metadata_format_identifier = Utils.getLong(b, localOffset, 4, -1L);
            localOffset += 4;
        }
        this.metadata_service_id = Utils.getInt(b, localOffset++, 1, 255);
        this.decoder_config_flags = Utils.getInt(b, localOffset, 1, 224) >> 5;
        this.dsm_cc_flag = Utils.getInt(b, localOffset, 1, 16) >> 4;
        this.reserved = Utils.getInt(b, localOffset++, 1, 15);
        if (this.dsm_cc_flag == 1) {
            this.service_identification_length = Utils.getInt(b, localOffset++, 1, 255);
            this.service_identification_record_byte = Utils.getBytes(b, localOffset, this.service_identification_length);
            localOffset += this.service_identification_length;
        }
        if (this.decoder_config_flags == 1) {
            this.decoder_config_length = Utils.getInt(b, localOffset++, 1, 255);
            this.decoder_config_byte = Utils.getBytes(b, localOffset, this.decoder_config_length);
            localOffset += this.decoder_config_length;
        }
        if (this.decoder_config_flags == 3) {
            this.dec_config_identification_record_length = Utils.getInt(b, localOffset++, 1, 255);
            this.dec_config_identification_record_byte = Utils.getBytes(b, localOffset, this.dec_config_identification_record_length);
            localOffset += this.dec_config_identification_record_length;
        }
        if (this.decoder_config_flags == 4) {
            this.decoder_config_metadata_service_id = Utils.getInt(b, localOffset++, 1, 255);
        }
        if (this.decoder_config_flags == 5 || this.decoder_config_flags == 6) {
            this.reserved_data_length = Utils.getInt(b, localOffset++, 1, 255);
            this.reserved2 = Utils.getBytes(b, localOffset, this.dec_config_identification_record_length);
            localOffset += this.reserved_data_length;
        }
        this.private_data_byte = Utils.copyOfRange(b, localOffset, offset + this.descriptorLength + 2);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("metadata_application_format", this.metadata_application_format, MetaDataDescriptor.getMetaDataApplicationFormatString(this.metadata_application_format))));
        if (this.metadata_application_format == 65535) {
            t.add(new DefaultMutableTreeNode(new KVP("metadata_application_format_identifier", this.metadata_application_format_identifier, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("metadata_format", this.metadata_format, MetaDataDescriptor.getMetaDataFormatString(this.metadata_format))));
        if (this.metadata_format == 255) {
            t.add(new DefaultMutableTreeNode(new KVP("metadata_format_identifier", this.metadata_format_identifier, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("metadata_service_id", this.metadata_service_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("decoder_config_flags", this.decoder_config_flags, MetaDataDescriptor.getDecoderConfigFlagsString(this.decoder_config_flags))));
        t.add(new DefaultMutableTreeNode(new KVP("DSM-CC_flag", this.dsm_cc_flag, this.dsm_cc_flag == 1 ? "the stream with which this descriptor is associated is carried in an ISO/IEC 13818-6 data or object carousel" : null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        if (this.dsm_cc_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("service_identification_length", this.service_identification_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("service_identification_record_byte", this.service_identification_record_byte, null)));
        }
        if (this.decoder_config_flags == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("decoder_config_length", this.decoder_config_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("decoder_config_byte", this.decoder_config_byte, null)));
        }
        if (this.decoder_config_flags == 3) {
            t.add(new DefaultMutableTreeNode(new KVP("dec_config_identification_record_length", this.dec_config_identification_record_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("dec_config_identification_record_byte", this.dec_config_identification_record_byte, null)));
        }
        if (this.decoder_config_flags == 4) {
            t.add(new DefaultMutableTreeNode(new KVP("decoder_config_metadata_service_id", this.decoder_config_metadata_service_id, null)));
        }
        if (this.decoder_config_flags == 5 || this.decoder_config_flags == 6) {
            t.add(new DefaultMutableTreeNode(new KVP("reserved_data_length", this.reserved_data_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.private_data_byte, null)));
        return t;
    }

    public static String getDecoderConfigFlagsString(int decoder_config_flags) {
        return decoder_config_flags_list.get(decoder_config_flags);
    }
}

