/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MetaDataPointerDescriptor
extends Descriptor {
    private int metadata_application_format;
    private long metadata_application_format_identifier;
    private int metadata_format;
    private long metadata_format_identifier;
    private int metadata_service_id;
    private int metadata_locator_record_flag;
    private int reserved;
    private byte[] private_data_byte;
    private int MPEG_carriage_flags;
    private int metadata_locator_record_length;
    private byte[] metadata_locator_record_byte;
    private int program_number;
    private int transport_stream_location;
    private int transport_stream_id;

    public MetaDataPointerDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int localOffset = offset + 2;
        this.metadata_application_format = Utils.getInt(b, localOffset, 2, 65535);
        localOffset += 2;
        if (this.metadata_application_format == 65535) {
            this.metadata_application_format_identifier = Utils.getLong(b, localOffset, 4, -1L);
            localOffset += 4;
        }
        this.metadata_format = Utils.getInt(b, localOffset++, 1, 255);
        if (this.metadata_format == 255) {
            this.metadata_format_identifier = Utils.getLong(b, localOffset, 4, -1L);
            localOffset += 4;
        }
        this.metadata_service_id = Utils.getInt(b, localOffset++, 1, 255);
        this.metadata_locator_record_flag = Utils.getInt(b, localOffset, 1, 128) >> 7;
        this.MPEG_carriage_flags = Utils.getInt(b, localOffset, 1, 96) >> 5;
        this.reserved = Utils.getInt(b, localOffset++, 1, 31);
        if (this.metadata_locator_record_flag == 1) {
            this.metadata_locator_record_length = Utils.getInt(b, localOffset++, 1, 255);
            this.metadata_locator_record_byte = Utils.getBytes(b, localOffset, this.metadata_locator_record_length);
            localOffset += this.metadata_locator_record_length;
        }
        if (this.MPEG_carriage_flags != 3) {
            this.program_number = Utils.getInt(b, localOffset, 2, 65535);
            localOffset += 2;
        }
        if (this.MPEG_carriage_flags == 1) {
            this.transport_stream_location = Utils.getInt(b, localOffset, 2, 65535);
            this.transport_stream_id = Utils.getInt(b, localOffset += 2, 2, 65535);
            localOffset += 2;
        }
        this.private_data_byte = Arrays.copyOfRange(b, localOffset, offset + this.descriptorLength + 2);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("metadata_application_format", this.metadata_application_format, MetaDataPointerDescriptor.getMetaDataApplicationFormatString(this.metadata_application_format))));
        if (this.metadata_application_format == 65535) {
            t.add(new DefaultMutableTreeNode(new KVP("metadata_application_format_identifier", this.metadata_application_format_identifier, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("metadata_format", this.metadata_format, MetaDataPointerDescriptor.getMetaDataFormatString(this.metadata_format))));
        if (this.metadata_format == 255) {
            t.add(new DefaultMutableTreeNode(new KVP("metadata_format_identifier", this.metadata_format_identifier, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("metadata_service_id", this.metadata_service_id, this.metadata_service_id == 255 ? "the metadata is carried in a carousel." : null)));
        t.add(new DefaultMutableTreeNode(new KVP("metadata_locator_record_flag", this.metadata_locator_record_flag, this.metadata_locator_record_flag == 1 ? "associated metadata is available on a location outside of a Rec. ITU-T H.222.0 | ISO/IEC 13818-1 stream, specified in a metadata_locator_record" : null)));
        t.add(new DefaultMutableTreeNode(new KVP("MPEG_carriage_flags", this.MPEG_carriage_flags, MetaDataPointerDescriptor.getMPEGCarriageFlagsString(this.MPEG_carriage_flags))));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        if (this.metadata_locator_record_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("metadata_locator_record_length", this.metadata_locator_record_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("metadata_locator_record_byte", this.metadata_locator_record_byte, null)));
        }
        if (this.MPEG_carriage_flags != 3) {
            String serviceName = this.MPEG_carriage_flags == 1 ? this.getPSI().getSdt().getServiceName(this.transport_stream_location, this.transport_stream_id, this.program_number) : this.getPSI().getSdt().getServiceNameForActualTransportStream(this.program_number);
            t.add(new DefaultMutableTreeNode(new KVP("program_number", this.program_number, serviceName)));
        }
        if (this.MPEG_carriage_flags == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("transport_stream_location", this.transport_stream_location, null)));
            t.add(new DefaultMutableTreeNode(new KVP("transport_stream_id", this.transport_stream_id, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("private_data_byte", this.private_data_byte, null)));
        return t;
    }
}

