/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MultilingualServiceNameDescriptor
extends Descriptor {
    private final List<ServiceName> serviceNameList = new ArrayList<ServiceName>();

    public MultilingualServiceNameDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int service_name_length;
        int service_provider_name_length;
        for (int t = 2; t < this.descriptorLength + 2; t += 5 + service_provider_name_length + service_name_length) {
            String languageCode = Utils.getISO8859_1String(b, t, 3);
            service_provider_name_length = Utils.getInt(b, t + 3, 1, 255);
            DVBString service_provider_name = new DVBString(b, t + 3);
            service_name_length = Utils.getInt(b, t + 4 + service_provider_name_length, 1, 255);
            DVBString service_name = new DVBString(b, t + 4 + service_provider_name_length);
            ServiceName s = new ServiceName(languageCode, service_provider_name, service_name);
            this.serviceNameList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (ServiceName serviceName : this.serviceNameList) {
            buf.append(serviceName.toString());
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.serviceNameList, modus, "service_name_list");
        return t;
    }

    public List<ServiceName> getServiceNameList() {
        return this.serviceNameList;
    }

    public record ServiceName(String iso639LanguageCode, DVBString service_provider_name, DVBString service_name) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("service_name");
            s.add(new KVP("ISO_639_language_code", this.iso639LanguageCode));
            s.add(new KVP("service_provider_name", this.service_provider_name));
            s.add(new KVP("service_name", this.service_name));
            return s;
        }
    }
}

