/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class MultiplexBufferUtilizationDescriptor
extends Descriptor {
    private final int boundValidFlag;
    private final int ltwOffsetLowerBound;
    private final int ltwOffsetUpperBound;

    public MultiplexBufferUtilizationDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.boundValidFlag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.ltwOffsetLowerBound = Utils.getInt(b, offset + 2, 2, Short.MAX_VALUE);
        this.ltwOffsetUpperBound = Utils.getInt(b, offset + 4, 2, Short.MAX_VALUE);
    }

    @Override
    public String toString() {
        return super.toString() + "ltwOffsetLowerBound=" + this.ltwOffsetLowerBound;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("bound_valid_flag", this.boundValidFlag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("LTW_offset_lower_bound", this.ltwOffsetLowerBound, null)));
        t.add(new DefaultMutableTreeNode(new KVP("LTW_offset_upper_bound", this.ltwOffsetUpperBound, null)));
        return t;
    }

    public int getLtwOffsetLowerBound() {
        return this.ltwOffsetLowerBound;
    }

    public int getBoundValidFlag() {
        return this.boundValidFlag;
    }

    public int getLtwOffsetUpperBound() {
        return this.ltwOffsetUpperBound;
    }
}

