/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class PartialTransportStreamDescriptor
extends Descriptor {
    private final int reserved1;
    private final int peakRate;
    private final int reserved2;
    private final int minimumOveralSmoothingRate;
    private final int reserved3;
    private final int maximumOveralSmoothingBuffer;

    public PartialTransportStreamDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.reserved1 = Utils.getInt(b, offset + 2, 1, 192) >> 6;
        this.peakRate = Utils.getInt(b, offset + 2, 3, 0x3FFFFF);
        this.reserved2 = Utils.getInt(b, offset + 5, 1, 192) >> 6;
        this.minimumOveralSmoothingRate = Utils.getInt(b, offset + 5, 3, 0x3FFFFF);
        this.reserved3 = Utils.getInt(b, offset + 8, 1, 192) >> 6;
        this.maximumOveralSmoothingBuffer = Utils.getInt(b, offset + 8, 2, 16383);
    }

    @Override
    public String toString() {
        return super.toString() + "peakRate=" + this.peakRate + ",minimum_overal_smoothing_rate=" + this.minimumOveralSmoothingRate + ",maximum_overal_smoothing_buffer=" + this.maximumOveralSmoothingBuffer;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("DVB_reserved_future_use", this.reserved1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("peak_rate", this.peakRate, PartialTransportStreamDescriptor.getPeakRateString(this.peakRate))));
        t.add(new DefaultMutableTreeNode(new KVP("DVB_reserved_future_use", this.reserved2, null)));
        t.add(new DefaultMutableTreeNode(new KVP("minimum_overal_smoothing_rate", this.minimumOveralSmoothingRate, this.getMinimumOveralSmoothingRateString(this.minimumOveralSmoothingRate))));
        t.add(new DefaultMutableTreeNode(new KVP("DVB_reserved_future_use", this.reserved3, null)));
        t.add(new DefaultMutableTreeNode(new KVP("maximum_overal_smoothing_buffer", this.maximumOveralSmoothingBuffer, PartialTransportStreamDescriptor.getMaximumOveralSmoothingBufferString(this.maximumOveralSmoothingBuffer))));
        return t;
    }

    private static String getPeakRateString(int peakRate2) {
        return peakRate2 * 400 + " bit/s";
    }

    private String getMinimumOveralSmoothingRateString(int minimumOveralSmoothingRate2) {
        if (minimumOveralSmoothingRate2 == 0x3FFFFF) {
            return "undefined";
        }
        return this.minimumOveralSmoothingRate * 400 + " bit/s";
    }

    private static String getMaximumOveralSmoothingBufferString(int maximumOveralSmoothingBuffer2) {
        if (maximumOveralSmoothingBuffer2 == 16383) {
            return "undefined";
        }
        return maximumOveralSmoothingBuffer2 + " bytes";
    }
}

