/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class PrivateDataSpecifierDescriptor
extends Descriptor {
    private long privateDataSpecifier;

    public PrivateDataSpecifierDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.privateDataSpecifier = Utils.getLong(b, offset + 2, 4, -1L);
    }

    @Override
    public String toString() {
        return super.toString() + "privateDataSpecifier=" + this.privateDataSpecifier + " (" + Utils.getPrivateDataSpecString(this.privateDataSpecifier) + ") ";
    }

    public long getPrivateDataSpecifier() {
        return this.privateDataSpecifier;
    }

    public void setPrivateDataSpecifier(int privateDataSpecifier) {
        this.privateDataSpecifier = privateDataSpecifier;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("private_data_specifier", this.privateDataSpecifier, Utils.getPrivateDataSpecString(this.privateDataSpecifier))));
        return t;
    }
}

