/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class S2SatelliteDeliverySystemDescriptor
extends Descriptor {
    private final int scrambling_sequence_selector;
    private final int multiple_input_stream_flag;
    private final int backwards_compatibility_indicator;
    private int scrambling_sequence_index = 0;
    private int input_stream_identifier = 0;

    public S2SatelliteDeliverySystemDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.scrambling_sequence_selector = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.multiple_input_stream_flag = Utils.getInt(b, offset + 2, 1, 64) >> 6;
        this.backwards_compatibility_indicator = Utils.getInt(b, offset + 2, 1, 32) >> 5;
        int off = offset + 3;
        if (this.scrambling_sequence_selector == 1) {
            this.scrambling_sequence_index = Utils.getInt(b, off, 3, 262143);
            off += 3;
        }
        if (this.multiple_input_stream_flag == 1) {
            this.input_stream_identifier = Utils.getInt(b, off, 1, 255);
            ++off;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("scrambling_sequence_selector", this.scrambling_sequence_selector, this.scrambling_sequence_selector == 1 ? "default scrambling sequence is not used" : "default DVB-S2 physical layer scrambling sequence of index n = 0 is used")));
        t.add(new DefaultMutableTreeNode(new KVP("multiple_input_stream_flag", this.multiple_input_stream_flag, this.multiple_input_stream_flag == 1 ? "multiple transport streams are conveyed" : "single transport stream is carried")));
        t.add(new DefaultMutableTreeNode(new KVP("backwards_compatibility_indicator", this.backwards_compatibility_indicator, null)));
        if (this.scrambling_sequence_selector == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("scrambling_sequence_index", this.scrambling_sequence_index, null)));
        }
        if (this.multiple_input_stream_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("input_stream_identifier", this.input_stream_identifier, null)));
        }
        return t;
    }
}

