/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SatelliteDeliverySystemDescriptor
extends Descriptor {
    private String frequency;
    private final String orbitalPosition;
    private final int westEastFlag;
    private final int polarization;
    private final int rollOff;
    private final int modulationSystem;
    private final int modulationType;
    private String symbol_rate;
    private int FEC_inner;

    public SatelliteDeliverySystemDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.frequency = Utils.getBCD(b, offset * 2 + 4, 8);
        this.orbitalPosition = Utils.getBCD(b, offset * 2 + 12, 4);
        this.westEastFlag = Utils.getInt(b, offset + 8, 1, 128) >> 7;
        this.polarization = Utils.getInt(b, offset + 8, 1, 96) >> 5;
        this.rollOff = Utils.getInt(b, offset + 8, 1, 24) >> 3;
        this.modulationSystem = Utils.getInt(b, offset + 8, 1, 4) >> 2;
        this.modulationType = Utils.getInt(b, offset + 8, 1, 3);
        this.symbol_rate = Utils.getBCD(b, offset * 2 + 18, 7);
        this.FEC_inner = Utils.getInt(b, offset + 12, 1, 15);
    }

    public int getFEC_inner() {
        return this.FEC_inner;
    }

    public void setFEC_inner(int fec_inner) {
        this.FEC_inner = fec_inner;
    }

    public static String getModulationString(int mod) {
        switch (mod) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "QPSK";
            }
            case 2: {
                return "8PSK";
            }
            case 3: {
                return "16-QAM";
            }
        }
        return "illegal value";
    }

    public static String getPolarizationString(int pol) {
        switch (pol) {
            case 0: {
                return "linear - horizontal";
            }
            case 1: {
                return "linear - vertical";
            }
            case 2: {
                return "Circular - left";
            }
            case 3: {
                return "Circular - right";
            }
        }
        return "illegal value";
    }

    public static String getRollOffString(int pol) {
        switch (pol) {
            case 0: {
                return "\u03b1 = 0,35";
            }
            case 1: {
                return "\u03b1 = 0,25";
            }
            case 2: {
                return "\u03b1 = 0,20";
            }
            case 3: {
                return "reserved";
            }
        }
        return "illegal value";
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getSymbol_rate() {
        return this.symbol_rate;
    }

    public void setSymbol_rate(String symbol_rate) {
        this.symbol_rate = symbol_rate;
    }

    @Override
    public String toString() {
        return super.toString() + "Frequency=" + this.getFrequency() + ", FEC_inner=" + Descriptor.getFEC_innerString(this.FEC_inner);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("frequency", this.frequency, Descriptor.formatSatelliteFrequency(this.frequency))));
        t.add(new DefaultMutableTreeNode(new KVP("orbital_position", this.orbitalPosition, Descriptor.formatOrbitualPosition(this.orbitalPosition))));
        t.add(new DefaultMutableTreeNode(new KVP("west_east_flag", this.westEastFlag, this.getWestEastFlagString())));
        t.add(new DefaultMutableTreeNode(new KVP("polarization", this.polarization, SatelliteDeliverySystemDescriptor.getPolarizationString(this.polarization))));
        t.add(new DefaultMutableTreeNode(new KVP("modulation_system", this.modulationSystem, this.getModulationSystemString())));
        if (this.modulationSystem == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("roll_off", this.rollOff, SatelliteDeliverySystemDescriptor.getRollOffString(this.rollOff))));
        }
        t.add(new DefaultMutableTreeNode(new KVP("modulation_type", this.modulationType, SatelliteDeliverySystemDescriptor.getModulationString(this.modulationType))));
        t.add(new DefaultMutableTreeNode(new KVP("symbol_rate", this.symbol_rate, Descriptor.formatSymbolRate(this.symbol_rate))));
        t.add(new DefaultMutableTreeNode(new KVP("FEC_inner", this.FEC_inner, Descriptor.getFEC_innerString(this.FEC_inner))));
        return t;
    }

    public String getModulationSystemString() {
        return this.modulationSystem == 1 ? "DVB-S2" : "DVB-S";
    }

    public String getWestEastFlagString() {
        return this.westEastFlag == 1 ? "east" : "west";
    }

    public String getOrbitalPosition() {
        return this.orbitalPosition;
    }

    public int getWestEastFlag() {
        return this.westEastFlag;
    }

    public int getPolarization() {
        return this.polarization;
    }

    public int getRollOff() {
        return this.rollOff;
    }

    public int getModulationSystem() {
        return this.modulationSystem;
    }

    public int getModulationType() {
        return this.modulationType;
    }
}

