/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ServiceDescriptor
extends Descriptor {
    private final int serviceType;
    private final DVBString serviceProviderName;
    private final DVBString serviceName;

    public ServiceDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.serviceType = Utils.getInt(b, 2, 1, 255);
        this.serviceProviderName = new DVBString(b, 3);
        this.serviceName = new DVBString(b, 4 + this.serviceProviderName.getLength());
    }

    public DVBString getServiceProviderName() {
        return this.serviceProviderName;
    }

    @Override
    public String toString() {
        return super.toString() + " service_type" + this.serviceType + "(" + ServiceDescriptor.getServiceTypeString(this.serviceType) + "), serviceProviderName=" + String.valueOf(this.serviceProviderName) + "serviceName=" + String.valueOf(this.serviceName);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("service_type", this.serviceType).setDescription(ServiceDescriptor.getServiceTypeString(this.serviceType)));
        t.add(new KVP("service_provider_name", this.serviceProviderName));
        t.add(new KVP("service_name", this.serviceName));
        return t;
    }

    public DVBString getServiceName() {
        return this.serviceName;
    }

    public int getServiceType() {
        return this.serviceType;
    }
}

