/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SmoothingBufferDescriptor
extends Descriptor {
    private int reserved;
    private int sbLeakRate;
    private int reserved2;
    private int sbSize;

    public SmoothingBufferDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.reserved = Utils.getInt(b, offset + 2, 2, 3);
        this.sbLeakRate = Utils.getInt(b, offset + 2, 3, 0x3FFFFF);
        this.reserved2 = Utils.getInt(b, offset + 5, 2, 3);
        this.sbSize = Utils.getInt(b, offset + 5, 3, 0x3FFFFF);
    }

    @Override
    public String toString() {
        return super.toString() + "sbLeakRate=" + this.sbLeakRate;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sb_leak_rate", this.sbLeakRate, KVP.formatInt(this.sbLeakRate * 400) + " bits/second")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sb_size", this.sbSize, " byte")));
        return t;
    }

    public int getSbLeakRate() {
        return this.sbLeakRate;
    }

    public void setSbLeakRate(int maximumBitrate) {
        this.sbLeakRate = maximumBitrate;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserverd) {
        this.reserved = reserverd;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(int reserved2) {
        this.reserved2 = reserved2;
    }

    public int getSbSize() {
        return this.sbSize;
    }

    public void setSbSize(int sbSize) {
        this.sbSize = sbSize;
    }
}

