/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SubtitlingDescriptor
extends Descriptor {
    private final List<Subtitle> subtitleList = new ArrayList<Subtitle>();

    public SubtitlingDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        for (int t = 0; t < this.descriptorLength; t += 8) {
            String languageCode = Utils.getISO8859_1String(b, offset + 2 + t, 3);
            int subtitling_type = Utils.getInt(b, offset + 5 + t, 1, 255);
            int composition_page_id = Utils.getInt(b, offset + 6 + t, 2, 65535);
            int ancillary_page_id = Utils.getInt(b, offset + 8 + t, 2, 65535);
            Subtitle s = new Subtitle(languageCode, subtitling_type, composition_page_id, ancillary_page_id);
            this.subtitleList.add(s);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (Subtitle subtitle : this.subtitleList) {
            buf.append(subtitle.toString());
        }
        return buf.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.subtitleList, modus, "subtitle_list");
        return t;
    }

    public List<Subtitle> getSubtitleList() {
        return this.subtitleList;
    }

    public static class Subtitle
    implements TreeNode {
        private final String iso639LanguageCode;
        private final int subtitlingType;
        private final int compositionPageId;
        private final int ancillaryPageId;

        public Subtitle(String lCode, int sType, int sCompositionPageDd, int aPageId) {
            this.iso639LanguageCode = lCode;
            this.subtitlingType = sType;
            this.compositionPageId = sCompositionPageDd;
            this.ancillaryPageId = aPageId;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("subtitle"));
            s.add(new DefaultMutableTreeNode(new KVP("ISO_639_language_code", this.iso639LanguageCode, null)));
            s.add(new DefaultMutableTreeNode(new KVP("subtitling_type", this.subtitlingType, Descriptor.getComponentType0x03String(this.subtitlingType))));
            s.add(new DefaultMutableTreeNode(new KVP("composition_page_id", this.compositionPageId, null)));
            s.add(new DefaultMutableTreeNode(new KVP("ancillary_page_id", this.ancillaryPageId, null)));
            return s;
        }

        public String toString() {
            return "code:'" + this.iso639LanguageCode;
        }

        public String getIso639LanguageCode() {
            return this.iso639LanguageCode;
        }

        public int getSubtitlingType() {
            return this.subtitlingType;
        }

        public int getCompositionPageId() {
            return this.compositionPageId;
        }

        public int getAncillaryPageId() {
            return this.ancillaryPageId;
        }
    }
}

