/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class SystemClockDescriptor
extends Descriptor {
    private int externalClockReferenceIndicator;
    private int reserved;
    private int clockAccuracyInteger;
    private int clockAccuracyExponent;
    private int reserved2;

    public SystemClockDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.externalClockReferenceIndicator = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.reserved = Utils.getInt(b, offset + 2, 1, 64) >> 6;
        this.clockAccuracyInteger = Utils.getInt(b, offset + 2, 1, 63);
        this.clockAccuracyExponent = Utils.getInt(b, offset + 3, 1, 224) >> 5;
        this.reserved2 = Utils.getInt(b, offset + 3, 1, 31);
    }

    @Override
    public String toString() {
        return super.toString() + "externalClockReferenceIndicator=" + this.externalClockReferenceIndicator;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("external_clock_reference_indicator", this.externalClockReferenceIndicator, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("clock_accuracy_integer", this.clockAccuracyInteger, null)));
        t.add(new DefaultMutableTreeNode(new KVP("clock_accuracy_exponent", this.clockAccuracyExponent, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
        return t;
    }

    public int getClockAccuracyExponent() {
        return this.clockAccuracyExponent;
    }

    public void setClockAccuracyExponent(int clockAccuracyExponent) {
        this.clockAccuracyExponent = clockAccuracyExponent;
    }

    public int getClockAccuracyInteger() {
        return this.clockAccuracyInteger;
    }

    public void setClockAccuracyInteger(int clockAccuracyInteger) {
        this.clockAccuracyInteger = clockAccuracyInteger;
    }

    public int getExternalClockReferenceIndicator() {
        return this.externalClockReferenceIndicator;
    }

    public void setExternalClockReferenceIndicator(int externalClockReferenceIndicator) {
        this.externalClockReferenceIndicator = externalClockReferenceIndicator;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(int reserved2) {
        this.reserved2 = reserved2;
    }
}

