/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class TeletextDescriptor
extends Descriptor {
    private final List<Teletext> teletextList = new ArrayList<Teletext>();

    public TeletextDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int t = 0;
        while (t + 4 < this.descriptorLength) {
            String languageCode = Utils.getISO8859_1String(b, offset + 2 + t, 3);
            int teletext_type = Utils.getInt(b, offset + t + 5, 1, 248) >> 3;
            int teletext_magazine_number = Utils.getInt(b, offset + t + 5, 1, 7);
            int teletext__page_number = Utils.getInt(b, offset + t + 6, 1, 255);
            Teletext s = new Teletext(languageCode, teletext_type, teletext_magazine_number, teletext__page_number);
            this.teletextList.add(s);
            t += 5;
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        for (Teletext teletext : this.teletextList) {
            buf.append(teletext.toString());
        }
        return buf.toString();
    }

    public static String getTeletextTypeString(int type) {
        switch (type) {
            case 0: {
                return "reserved for future use";
            }
            case 1: {
                return "initial Teletext page";
            }
            case 2: {
                return "Teletext subtitle page";
            }
            case 3: {
                return "additional information page";
            }
            case 4: {
                return "programme schedule page";
            }
            case 5: {
                return "Teletext subtitle page for hearing impaired people";
            }
        }
        return "reserved for future use";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.teletextList, modus, "teletext_list");
        return t;
    }

    public List<Teletext> getTeletextList() {
        return this.teletextList;
    }

    public static class Teletext
    implements TreeNode {
        private final String iso639LanguageCode;
        private final int teletextType;
        private final int teletextMagazineNumber;
        private final int teletextPageNumber;

        public Teletext(String lCode, int tType, int tMagazine, int tPage) {
            this.iso639LanguageCode = lCode;
            this.teletextType = tType;
            this.teletextMagazineNumber = tMagazine;
            this.teletextPageNumber = tPage;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("teletext"));
            s.add(new DefaultMutableTreeNode(new KVP("ISO_639_language_code", this.iso639LanguageCode, null)));
            s.add(new DefaultMutableTreeNode(new KVP("teletext_type", this.teletextType, TeletextDescriptor.getTeletextTypeString(this.teletextType))));
            s.add(new DefaultMutableTreeNode(new KVP("teletext_magazine_number", this.teletextMagazineNumber, null)));
            s.add(new DefaultMutableTreeNode(new KVP("teletext_page_number", this.teletextPageNumber, null)));
            return s;
        }

        public String toString() {
            return "code:'" + this.iso639LanguageCode;
        }

        public int getTeletextType() {
            return this.teletextType;
        }

        public int getTeletextMagazineNumber() {
            return this.teletextMagazineNumber;
        }

        public int getTeletextPageNumber() {
            return this.teletextPageNumber;
        }

        public String getIso639LanguageCode() {
            return this.iso639LanguageCode;
        }
    }
}

