/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class VBIDataDescriptor
extends Descriptor {
    private List<DataService> serviceList = new ArrayList<DataService>();

    public VBIDataDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int serviceLength;
        for (int t = 0; t < this.descriptorLength; t += 2 + serviceLength) {
            int serviceId = Utils.getInt(b, offset + t + 2, 1, 255);
            serviceLength = Utils.getInt(b, offset + t + 3, 1, 255);
            DataService s = new DataService(serviceId, serviceLength, Utils.getBytes(b, offset + t + 4, serviceLength));
            this.serviceList.add(s);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.serviceList, modus, "data_service");
        return t;
    }

    public static String getDataServiceIDString(int dataServiceID) {
        switch (dataServiceID) {
            case 0: {
                return "reserved for future use";
            }
            case 1: {
                return "EBU teletext (Requires additional teletext_descriptor)";
            }
            case 2: {
                return "inverted teletext";
            }
            case 3: {
                return "reserved";
            }
            case 4: {
                return "VPS";
            }
            case 5: {
                return "WSS";
            }
            case 6: {
                return "Closed Captioning";
            }
            case 7: {
                return "monochrome 4:2:2 samples";
            }
        }
        return "reserved for future use";
    }

    public static class DataService
    implements TreeNode {
        private final int dataServiceId;
        private final int dataServiceDescriptorLength;
        private List<VBILine> linesList;
        private byte[] reserved;

        DataService(int id, int length, byte[] data) {
            this.dataServiceId = id;
            this.dataServiceDescriptorLength = length;
            if (this.dataServiceId == 1 || this.dataServiceId == 2 || this.dataServiceId == 4 || this.dataServiceId == 5 || this.dataServiceId == 6 || this.dataServiceId == 7) {
                this.linesList = new ArrayList<VBILine>();
                for (int i = 0; i < data.length; ++i) {
                    VBILine line = new VBILine(Utils.getInt(data, i, 1, 255));
                    this.linesList.add(line);
                }
            } else {
                this.reserved = data;
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("data_service"));
            s.add(new DefaultMutableTreeNode(new KVP("data_service_id", this.dataServiceId, VBIDataDescriptor.getDataServiceIDString(this.dataServiceId))));
            s.add(new DefaultMutableTreeNode(new KVP("data_service_descriptor_length", this.dataServiceDescriptorLength, null)));
            if (this.linesList != null) {
                Utils.addListJTree(s, this.linesList, modus, "vbi_lines");
            } else {
                s.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            }
            return s;
        }

        public static class VBILine
        implements TreeNode {
            private final int reserved;
            private final int fieldParity;
            private final int lineOffset;

            VBILine(int t) {
                this.reserved = (t & 0xC0) >> 6;
                this.fieldParity = (t & 0x20) >> 5;
                this.lineOffset = t & 0x1F;
            }

            @Override
            public DefaultMutableTreeNode getJTreeNode(int modus) {
                DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("vbi_line"));
                s.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
                s.add(new DefaultMutableTreeNode(new KVP("field_parity", this.fieldParity, null)));
                s.add(new DefaultMutableTreeNode(new KVP("line_offset", this.lineOffset, null)));
                return s;
            }
        }
    }
}

