/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.ProfileTierLevel;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class VVCVideoDescriptor
extends Descriptor {
    private static final LookUpList hdr_wgc_idc_list = new LookUpList.Builder().add(0, "SDR").add(1, "WCG only").add(2, "Both HDR and WCG").add(3, "No indication is made regarding HDR/WCG or SDR").build();
    private static final LookUpList video_properties_sdr_list = new LookUpList.Builder().add(0, "Video property CICP combination not specified or unknown").add(1, "[1,1,1,0]- BT709_YCC").add(2, "[1,1,0,0]- BT709_RGB").add(3, "[6,6,6,0]- BT601_525").add(4, "[5,6,5,0]- BT601_625").add(5, "[1,1,0,1]- FR709_RGB").add(6, 15, "Reserved").build();
    private static final LookUpList video_properties_wgc_list = new LookUpList.Builder().add(0, "Video property CICP combination not specified or unknown").add(1, "[9,14,9,0]- BT2020_YCC_NCL").add(2, "[9,14,0,0]- BT2020_RGB").add(3, "[9,14,0,1]- FR2020_RGB").add(4, "[12,1,6,1]- FRP3D65_YCC").add(5, 15, "Reserved").build();
    private static final LookUpList video_properties_hdr_wgc_list = new LookUpList.Builder().add(0, "Video property CICP combination not specified or unknown").add(1, "[9,16,9,0]- BT2100_PQ_YCC").add(2, "[9,18,9,0]- BT2100_HLG_YCC").add(3, "[9,16,14,0]- BT2100_PQ_ICTCP").add(4, "[9,16,0,0]- BT2100_PQ_RGB").add(5, "[9,18,0,0]- BT2100_HLG_RGB").add(6, 15, "Reserved").build();
    private static final LookUpList video_properties_no_indication_list = new LookUpList.Builder().add(0, "Video property CICP combination not specified or unknown").add(1, 15, "Reserved or private").build();
    private int profile_idc;
    private int tier_flag;
    private int num_sub_profiles;
    private List<Long> sub_profile_idc_list = new ArrayList<Long>();
    private int progressive_source_flag;
    private int interlaced_source_flag;
    private int non_packed_constraint_flag;
    private int frame_only_constraint_flag;
    private int reserved_zero_4bits;
    private int level_idc;
    private int temporal_layer_subset_flag;
    private int VVC_still_present_flag;
    private int VVC_24hr_picture_present_flag;
    private int reserved;
    private int HDR_WCG_idc;
    private int video_properties_tag;
    private int reserved2;
    private int reserved3;
    private int temporal_id_min;
    private int reserved4;
    private int temporal_id_max;

    public VVCVideoDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.profile_idc = Utils.getInt(b, offset + 2, 1, 254) >> 1;
        this.tier_flag = Utils.getInt(b, offset + 2, 1, 1);
        this.num_sub_profiles = Utils.getInt(b, offset + 3, 1, 255);
        int localOffset = offset + 4;
        for (int i = 0; i < this.num_sub_profiles; ++i) {
            long sub_profile_idc = Utils.getLong(b, localOffset, 4, -1L);
            this.sub_profile_idc_list.add(sub_profile_idc);
            localOffset += 4;
        }
        this.progressive_source_flag = Utils.getInt(b, localOffset, 1, 128) >> 7;
        this.interlaced_source_flag = Utils.getInt(b, localOffset, 1, 64) >> 6;
        this.non_packed_constraint_flag = Utils.getInt(b, localOffset, 1, 32) >> 5;
        this.frame_only_constraint_flag = Utils.getInt(b, localOffset, 1, 16) >> 4;
        this.reserved_zero_4bits = Utils.getInt(b, localOffset++, 1, 15);
        this.level_idc = Utils.getInt(b, localOffset++, 1, 255);
        this.temporal_layer_subset_flag = Utils.getInt(b, localOffset, 1, 128) >> 7;
        this.VVC_still_present_flag = Utils.getInt(b, localOffset, 1, 64) >> 6;
        this.VVC_24hr_picture_present_flag = Utils.getInt(b, localOffset, 1, 32) >> 5;
        this.reserved = Utils.getInt(b, localOffset++, 1, 31);
        this.HDR_WCG_idc = Utils.getInt(b, localOffset, 1, 192) >> 6;
        this.reserved2 = Utils.getInt(b, localOffset, 1, 48) >> 4;
        this.video_properties_tag = Utils.getInt(b, localOffset++, 1, 15);
        if (this.temporal_layer_subset_flag == 1) {
            this.reserved3 = Utils.getInt(b, localOffset, 1, 248) >> 3;
            this.temporal_id_min = Utils.getInt(b, localOffset++, 1, 7);
            this.reserved4 = Utils.getInt(b, localOffset, 1, 248) >> 3;
            this.temporal_id_max = Utils.getInt(b, localOffset++, 1, 7);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("profile_idc", this.profile_idc, ProfileTierLevel.general_profile_idc_list.get(this.profile_idc, "unknown/reserved"))));
        t.add(new DefaultMutableTreeNode(new KVP("tier_flag", this.tier_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("num_sub_profiles", this.num_sub_profiles, null)));
        for (int i = 0; i < this.num_sub_profiles; ++i) {
            long sub_profile_idc = this.sub_profile_idc_list.get(i);
            t.add(new DefaultMutableTreeNode(new KVP("sub_profile_idc[" + i + "]", sub_profile_idc, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("progressive_source_flag", this.progressive_source_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("interlaced_source_flag", this.interlaced_source_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("non_packed_constraint_flag", this.non_packed_constraint_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_only_constraint_flag", this.frame_only_constraint_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_4bits", this.reserved_zero_4bits, null)));
        t.add(new DefaultMutableTreeNode(new KVP("level_idc", this.level_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("temporal_layer_subset_flag", this.temporal_layer_subset_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("VVC_still_present_flag", this.VVC_still_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("VVC_24hr_picture_present_flag", this.VVC_24hr_picture_present_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("HDR_WCG_idc", this.HDR_WCG_idc, hdr_wgc_idc_list.get(this.HDR_WCG_idc))));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
        t.add(new DefaultMutableTreeNode(new KVP("video_properties_tag", this.video_properties_tag, VVCVideoDescriptor.getVideoPropertiesTagString(this.HDR_WCG_idc, this.video_properties_tag))));
        if (this.temporal_layer_subset_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved3, null)));
            t.add(new DefaultMutableTreeNode(new KVP("temporal_id_min", this.temporal_id_min, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved4, null)));
            t.add(new DefaultMutableTreeNode(new KVP("temporal_id_max", this.temporal_id_max, null)));
        }
        return t;
    }

    private static String getVideoPropertiesTagString(int hDR_WCG_idc, int video_properties_tag) {
        return switch (hDR_WCG_idc) {
            case 0 -> video_properties_sdr_list.get(video_properties_tag);
            case 1 -> video_properties_wgc_list.get(video_properties_tag);
            case 2 -> video_properties_hdr_wgc_list.get(video_properties_tag);
            case 3 -> video_properties_no_indication_list.get(video_properties_tag);
            default -> "Unexpected value: " + hDR_WCG_idc;
        };
    }
}

