/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class VideoStreamDescriptor
extends Descriptor {
    private int multipleFrameRateFlag;
    private int frameRateCode;
    private int mpeg1OnlyFlag;
    private int constrainedParameterFlag;
    private int stillPictureFlag;
    private int profileAndLevelIndication;
    private int chromaFormat;
    private int frameRateExtensionFlag;
    private int reserved;

    public VideoStreamDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.multipleFrameRateFlag = Utils.getInt(b, offset + 2, 1, 128) >> 7;
        this.frameRateCode = Utils.getInt(b, offset + 2, 1, 120) >> 3;
        this.mpeg1OnlyFlag = Utils.getInt(b, offset + 2, 1, 4) >> 2;
        this.constrainedParameterFlag = Utils.getInt(b, offset + 2, 1, 2) >> 1;
        this.stillPictureFlag = Utils.getInt(b, offset + 2, 1, 1);
        if (this.mpeg1OnlyFlag == 0) {
            this.profileAndLevelIndication = Utils.getInt(b, offset + 3, 1, 255);
            this.chromaFormat = Utils.getInt(b, offset + 4, 1, 192) >> 6;
            this.frameRateExtensionFlag = Utils.getInt(b, offset + 4, 1, 32) >> 5;
            this.reserved = Utils.getInt(b, offset + 4, 1, 31);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " multipleFrameRateFlag" + this.multipleFrameRateFlag;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("multiple_frame_rate_flag", this.multipleFrameRateFlag, VideoStreamDescriptor.getMultipleFrameRateFlagString(this.multipleFrameRateFlag))));
        t.add(new DefaultMutableTreeNode(new KVP("frame_rate_code", this.frameRateCode, VideoStreamDescriptor.getFrameRateString(this.frameRateCode))));
        t.add(new DefaultMutableTreeNode(new KVP("MPEG_1_only_flag", this.mpeg1OnlyFlag, VideoStreamDescriptor.getMPEG_1_only_flagString(this.mpeg1OnlyFlag))));
        t.add(new DefaultMutableTreeNode(new KVP("constrained_parameter_flag", this.constrainedParameterFlag, VideoStreamDescriptor.getConstrainedParameterFlagString(this.constrainedParameterFlag))));
        t.add(new DefaultMutableTreeNode(new KVP("still_picture_flag", this.stillPictureFlag, VideoStreamDescriptor.getStillPictureFlagString(this.stillPictureFlag))));
        if (this.mpeg1OnlyFlag == 0) {
            t.add(new DefaultMutableTreeNode(new KVP("profile_and_level_indication", this.profileAndLevelIndication, VideoStreamDescriptor.getVideoProfileString(this.profileAndLevelIndication) + ", " + VideoStreamDescriptor.getVideoLevelString(this.profileAndLevelIndication))));
            t.add(new DefaultMutableTreeNode(new KVP("chroma_format", this.chromaFormat, VideoStreamDescriptor.getChromaFormatString(this.chromaFormat))));
            t.add(new DefaultMutableTreeNode(new KVP("frame_rate_extension_flag", this.frameRateExtensionFlag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        }
        return t;
    }

    public int getMultipleFrameRateFlag() {
        return this.multipleFrameRateFlag;
    }

    public static String getMultipleFrameRateFlagString(int multipleFrameRateFlag) {
        if (multipleFrameRateFlag == 1) {
            return "multiple frame rates may be present";
        }
        return "single frame rate is present";
    }

    public static String getMPEG_1_only_flagString(int mpeg1OnlyFlag) {
        if (mpeg1OnlyFlag == 1) {
            return "video stream contains only ISO/IEC 11172-2 data";
        }
        return "video stream may contain both ITU-T H.262 | ISO/IEC 13818-2 video data and constrained parameter ISO/IEC 11172-2 video data";
    }

    public static String getConstrainedParameterFlagString(int constrainedParameterFlag) {
        if (constrainedParameterFlag == 1) {
            return "video stream shall not contain unconstrained ISO/IEC 11172-2 video data";
        }
        return "video stream may contain both constrained parameters and unconstrained ISO/IEC 11172-2 video streams";
    }

    public static String getStillPictureFlagString(int stillPictureFlag) {
        if (stillPictureFlag == 1) {
            return "video stream contains only still pictures";
        }
        return "video stream may contain either moving or still picture data";
    }

    public void setMultipleFrameRateFlag(int serviceType) {
        this.multipleFrameRateFlag = serviceType;
    }

    public int getMpeg1OnlyFlag() {
        return this.mpeg1OnlyFlag;
    }

    public void setMpeg1OnlyFlag(int serviceNameLength) {
        this.mpeg1OnlyFlag = serviceNameLength;
    }

    public int getFrameRateCode() {
        return this.frameRateCode;
    }

    public void setFrameRateCode(int serviceProviderNameLength) {
        this.frameRateCode = serviceProviderNameLength;
    }

    public int getChromaFormat() {
        return this.chromaFormat;
    }

    public void setChromaFormat(int chromaFormat) {
        this.chromaFormat = chromaFormat;
    }

    public int getConstrainedParameterFlag() {
        return this.constrainedParameterFlag;
    }

    public void setConstrainedParameterFlag(int constrainedParameterFlag) {
        this.constrainedParameterFlag = constrainedParameterFlag;
    }

    public int getFrameRateExtensionFlag() {
        return this.frameRateExtensionFlag;
    }

    public void setFrameRateExtensionFlag(int frameRateExtensionFlag) {
        this.frameRateExtensionFlag = frameRateExtensionFlag;
    }

    public int getProfileAndLevelIndication() {
        return this.profileAndLevelIndication;
    }

    public void setProfileAndLevelIndication(int profileAndLevelIndication) {
        this.profileAndLevelIndication = profileAndLevelIndication;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public int getStillPictureFlag() {
        return this.stillPictureFlag;
    }

    public void setStillPictureFlag(int stillPictureFlag) {
        this.stillPictureFlag = stillPictureFlag;
    }

    public static String getFrameRateString(int frameRateCode) {
        switch (frameRateCode) {
            case 0: {
                return "forbidden";
            }
            case 1: {
                return "24000\u00f71001 (23,976...)";
            }
            case 2: {
                return "24 or 23,976";
            }
            case 3: {
                return "25";
            }
            case 4: {
                return "30 000\u00f71001 (29,97...) or 23,976";
            }
            case 5: {
                return "30 or 23,976 24,0 29,97";
            }
            case 6: {
                return "50 or 25,0";
            }
            case 7: {
                return "60 000\u00f71001 (59,94...) or 23,976 29,97";
            }
            case 8: {
                return "60 or 23,976 24,0 29,97 30,0 59,94";
            }
        }
        return "reserved";
    }

    public static String getChromaFormatString(int code) {
        switch (code) {
            case 0: {
                return "forbidden";
            }
            case 1: {
                return "4:2:0";
            }
            case 2: {
                return "4:2:2";
            }
            case 3: {
                return "4:4:4";
            }
        }
        return "illegal";
    }

    public static String getVideoProfileString(int code) {
        switch ((code & 0x7F) >> 4) {
            case 0: {
                return "reserved profile";
            }
            case 1: {
                return "high profile";
            }
            case 2: {
                return "spatially scalable profile";
            }
            case 3: {
                return "snr scalable profile";
            }
            case 4: {
                return "main profile";
            }
            case 5: {
                return "simple profile";
            }
        }
        return "";
    }

    public static String getVideoLevelString(int code) {
        switch (code & 0xF) {
            case 4: {
                return "high level";
            }
            case 6: {
                return "high 1440 level";
            }
            case 8: {
                return "main level";
            }
            case 10: {
                return "low level";
            }
        }
        return "reserved level";
    }
}

