/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.AFDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.TimelineDescriptor;

public final class AFDescriptorFactory {
    private static final Logger logger = Logger.getLogger(AFDescriptorFactory.class.getName());

    private AFDescriptorFactory() {
    }

    public static List<AFDescriptor> buildDescriptorList(byte[] data, int offset, int len) {
        AFDescriptor d;
        ArrayList<AFDescriptor> r = new ArrayList<AFDescriptor>();
        for (int t = 0; t < len; t += d.getDescriptorLength() + 2) {
            int descriptorLen = Byte.toUnsignedInt(data[offset + t + 1]);
            byte[] descriptorData = Arrays.copyOfRange(data, offset + t, offset + t + descriptorLen + 2);
            try {
                d = AFDescriptorFactory.getAFDescriptor(descriptorData);
            }
            catch (RuntimeException iae) {
                d = new AFDescriptor(data);
                logger.info("Fall back for descriptor:" + Byte.toUnsignedInt(data[t + offset]) + " (" + AFDescriptor.getDescriptorname(Byte.toUnsignedInt(data[t + offset])) + ")in AFDescriptorList adaptationField. data=" + d.getRawDataString() + ", RuntimeException:" + String.valueOf(iae));
            }
            r.add(d);
        }
        return r;
    }

    private static AFDescriptor getAFDescriptor(byte[] data) {
        AFDescriptor d;
        switch (Byte.toUnsignedInt(data[0])) {
            case 4: {
                d = new TimelineDescriptor(data);
                break;
            }
            default: {
                d = new AFDescriptor(data);
                logger.info("Not implemented AFDescriptor:" + Byte.toUnsignedInt(data[0]) + " (" + AFDescriptor.getDescriptorname(Byte.toUnsignedInt(data[0])) + ",) data=" + d.getRawDataString());
            }
        }
        return d;
    }
}

