/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ApplicationDescriptor
extends AITDescriptor {
    private int application_profiles_length;
    private List<ApplicationProfile> applicationProfiles = new ArrayList<ApplicationProfile>();
    private int service_bound_flag;
    private int visibility;
    private int application_priority;
    private List<TransportProtocolLabel> transport_protocol_labels = new ArrayList<TransportProtocolLabel>();

    public ApplicationDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int t;
        this.application_profiles_length = Utils.getInt(b, 2, 1, 255);
        for (t = 0; t < this.application_profiles_length; t += 5) {
            int application_profile = Utils.getInt(b, 3 + t, 2, 65535);
            int version_major = Utils.getInt(b, 5 + t, 1, 255);
            int version_minor = Utils.getInt(b, 6 + t, 1, 255);
            int version_micro = Utils.getInt(b, 7 + t, 1, 255);
            ApplicationProfile prof = new ApplicationProfile(application_profile, version_major, version_minor, version_micro);
            this.applicationProfiles.add(prof);
        }
        this.service_bound_flag = Utils.getInt(b, 3 + t, 1, 128) >> 7;
        this.visibility = Utils.getInt(b, 3 + t, 1, 96) >> 5;
        this.application_priority = Utils.getInt(b, 4 + t, 1, 255);
        for (int r = 3 + t; r < this.descriptorLength; ++r) {
            int transport_protocol_label = Utils.getInt(b, r + 2, 1, 255);
            TransportProtocolLabel transportProtocolLabel = new TransportProtocolLabel(transport_protocol_label);
            this.transport_protocol_labels.add(transportProtocolLabel);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("application_profiles_length", this.application_profiles_length));
        Utils.addListJTree(t, this.applicationProfiles, modus, "application_profiles");
        t.add(new KVP("service_bound_flag", this.service_bound_flag, this.service_bound_flag == 1 ? "the application is only associated with the current service" : "application not associated with the current service"));
        t.add(new KVP("visibility", this.visibility, ApplicationDescriptor.getVisibilityString(this.visibility)));
        t.add(new KVP("application_priority", this.application_priority));
        Utils.addListJTree(t, this.transport_protocol_labels, modus, "transport_protocol_labels");
        return t;
    }

    private static String getVisibilityString(int v) {
        return switch (v) {
            case 0 -> "NOT_VISIBLE_ALL (This application shall not be visible either to applications via an application listing API or to users via the navigator)";
            case 1 -> "NOT_VISIBLE_USERS (This application shall not be visible to users but shall be visible to applications via an application listing API)";
            case 2 -> "reserved_future_use";
            case 3 -> "VISIBLE_ALL (This application can be visible to users and shall be visible to applications via an application listing API)";
            default -> "illegal value";
        };
    }

    record ApplicationProfile(int application_profile, int version_major, int version_minor, int version_micro) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("application_profile (" + this.version_major + "." + this.version_minor + "." + this.version_micro + ")");
            s.add(new KVP("application_profile", this.application_profile));
            s.add(new KVP("version_major", this.version_major));
            s.add(new KVP("version_minor", this.version_minor));
            s.add(new KVP("version_micro", this.version_micro));
            return s;
        }
    }

    record TransportProtocolLabel(int transport_protocol_label) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            return new KVP("transport_protocol_label", this.transport_protocol_label);
        }
    }
}

