/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable;

import java.util.Arrays;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class DVBJApplicationLocationDescriptor
extends AITDescriptor {
    private final int base_directory_length;
    private final byte[] base_directory_byte;
    private final int classpath_extension_length;
    private final byte[] classpath_extension_byte;
    private final byte[] initial_class_byte;

    public DVBJApplicationLocationDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        this.base_directory_length = Utils.getInt(b, 2, 1, 255);
        int from = 3;
        int to = this.base_directory_length + 3;
        this.base_directory_byte = Arrays.copyOfRange(b, from, to);
        this.classpath_extension_length = Utils.getInt(b, 3 + this.base_directory_length, 1, 255);
        this.classpath_extension_byte = Arrays.copyOfRange(b, 4 + this.base_directory_length, 4 + this.base_directory_length + this.classpath_extension_length);
        this.initial_class_byte = Arrays.copyOfRange(b, 4 + this.base_directory_length + this.classpath_extension_length, this.descriptorLength + 2);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("base_directory_length", this.base_directory_length));
        t.add(new KVP("base_directory_byte", this.base_directory_byte));
        t.add(new KVP("classpath_extension_length", this.classpath_extension_length));
        t.add(new KVP("classpath_extension_byte", this.classpath_extension_byte));
        t.add(new KVP("initial_class_byte", this.initial_class_byte));
        return t;
    }
}

