/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class ExternalApplicationAuthorizationDescriptor
extends AITDescriptor {
    private List<ExternalAuthorization> externalAuthorizations = new ArrayList<ExternalAuthorization>();

    public ExternalApplicationAuthorizationDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        for (int t = 0; t < this.descriptorLength; t += 7) {
            byte[] application_identifier = Arrays.copyOfRange(b, t + 2, t + 2 + 6);
            int application_priority = Utils.getInt(b, t + 2 + 6 + 1, 1, 255);
            ExternalAuthorization s = new ExternalAuthorization(application_identifier, application_priority);
            this.externalAuthorizations.add(s);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.externalAuthorizations, modus, "external authorizations");
        return t;
    }

    record ExternalAuthorization(byte[] application_identifier, int application_priority) implements TreeNode
    {
        @Override
        public KVP getJTreeNode(int modus) {
            KVP s = new KVP("external authorization");
            long organisation_id = Utils.getLong(this.application_identifier, 0, 4, -1L);
            int application_id = Utils.getInt(this.application_identifier, 4, 2, 65535);
            KVP applicationIdNode = new KVP("application_identifier", this.application_identifier);
            applicationIdNode.add(new KVP("organisation_id", organisation_id, Utils.getMHPOrganistionIdString(organisation_id)));
            applicationIdNode.add(new KVP("application_id", application_id, AITsection.getApplicationIDString(application_id)));
            s.add(applicationIdNode);
            s.add(new KVP("application_priority", this.application_priority));
            return s;
        }
    }
}

