/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.aitable.AITDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class TransportProtocolDescriptor
extends AITDescriptor {
    private final int protocol_id;
    private final int transport_protocol_label;
    private final byte[] selector_bytes;
    private int remote_connection;
    private int reserved_future_use;
    private int service_id;
    private int original_network_id;
    private int transport_stream_id;
    private int component_tag;
    private int url_base_length;
    private byte[] url_base_byte;
    private int url_extension_count;
    private List<byte[]> url_extension_byte;

    public TransportProtocolDescriptor(byte[] b, TableSection parent) {
        super(b, parent);
        int t;
        this.protocol_id = Utils.getInt(b, 2, 2, 65535);
        this.transport_protocol_label = Utils.getInt(b, 4, 1, 255);
        this.selector_bytes = Arrays.copyOfRange(b, 5, this.descriptorLength + 2);
        if (this.protocol_id == 1) {
            this.remote_connection = Utils.getInt(b, 5, 1, 128) >> 7;
            this.reserved_future_use = Utils.getInt(b, 5, 1, 127);
            t = 6;
            if (this.remote_connection == 1) {
                this.original_network_id = Utils.getInt(b, t, 2, 65535);
                this.transport_stream_id = Utils.getInt(b, t += 2, 2, 65535);
                this.service_id = Utils.getInt(b, t += 2, 2, 65535);
                t += 2;
            }
            this.component_tag = Utils.getInt(b, t, 1, 255);
        }
        if (this.protocol_id == 3) {
            this.url_base_length = Utils.getInt(b, 5, 1, 255);
            this.url_base_byte = Arrays.copyOfRange(b, 6, 6 + this.url_base_length);
            this.url_extension_count = Utils.getInt(b, 6 + this.url_base_length, 1, 255);
            this.url_extension_byte = new ArrayList<byte[]>();
            t = 7 + this.url_base_length;
            for (int i = 0; i < this.url_extension_count; ++i) {
                int url_extension_length = Utils.getInt(b, t, 1, 255);
                this.url_extension_byte.add(Arrays.copyOfRange(b, ++t, t + url_extension_length));
                t += url_extension_length;
            }
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP t = super.getJTreeNode(modus);
        t.add(new KVP("protocol_id", this.protocol_id, TransportProtocolDescriptor.getTransportProtocolIDString(this.protocol_id)));
        t.add(new KVP("transport_protocol_label", this.transport_protocol_label));
        t.add(new KVP("selector_bytes", this.selector_bytes));
        if (this.protocol_id == 1) {
            t.add(new KVP("remote_connection", this.remote_connection, this.remote_connection == 1 ? "the transport connection is provided by a service that is different to the one carrying the AIT" : null));
            t.add(new KVP("reserved_future_use", this.reserved_future_use));
            if (this.remote_connection == 1) {
                t.add(new KVP("original_network_id", this.original_network_id));
                t.add(new KVP("transport_stream_id", this.transport_stream_id));
                t.add(new KVP("service_id", this.service_id));
            }
            t.add(new KVP("component_tag", this.component_tag));
        }
        if (this.protocol_id == 3) {
            t.add(new KVP("url_base_length", this.url_base_length));
            t.add(new KVP("url_base_byte", this.url_base_byte));
            t.add(new KVP("url_extension_count", this.url_extension_count));
            for (byte[] url_extension : this.url_extension_byte) {
                t.add(new KVP("url_extension_byte", url_extension));
            }
        }
        return t;
    }

    private static String getTransportProtocolIDString(int protocol_id) {
        if (protocol_id >= 4 && protocol_id <= 255) {
            return "Reserved for use by DVB";
        }
        return switch (protocol_id) {
            case 0 -> "reserved_future_use";
            case 1 -> "MHP Object Carousel";
            case 2 -> "IP via DVB multiprotocol encapsulation as defined in ETSI EN 301 192 [5], ETSI TR 101 202";
            case 3 -> "HTTP over back channel (i.e. broadband connection).";
            case 256 -> "OpenTV";
            default -> "[subject to registration by DVB]";
        };
    }
}

