/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AC4Descriptor
extends DVBExtensionDescriptor {
    LookUpList ac4_channel_mode_list = new LookUpList.Builder().add(0, "Mono content").add(1, "Stereo content").add(2, "Multichannel content").add(3, "Reserved for future use").build();
    private int ac4_config_flag;
    private int ac4_toc_flag;
    private int reserved_zero_future_use;
    private int ac4_dialog_enhancement_enabled;
    private int ac4_channel_mode;
    private int reserved_zero_future_use2;
    private int ac4_toc_len;
    private byte[] ac4_dsi_byte;
    private byte[] additional_info_byte;

    public AC4Descriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.ac4_config_flag = Utils.getInt(b, offset + 3, 1, 128) >> 7;
        this.ac4_toc_flag = Utils.getInt(b, offset + 3, 1, 64) >> 6;
        this.reserved_zero_future_use = Utils.getInt(b, offset + 3, 1, 63);
        int off = offset + 4;
        if (this.ac4_config_flag == 1) {
            this.ac4_dialog_enhancement_enabled = Utils.getInt(b, off, 1, 128) >> 7;
            this.ac4_channel_mode = Utils.getInt(b, off, 1, 96) >> 5;
            this.reserved_zero_future_use2 = Utils.getInt(b, off, 1, 31);
            ++off;
        }
        if (this.ac4_toc_flag == 1) {
            this.ac4_toc_len = Utils.getInt(b, off++, 1, 255);
            this.ac4_dsi_byte = Utils.getBytes(b, off, this.ac4_toc_len);
            off += this.ac4_toc_len;
        }
        if (off < offset + this.descriptorLength + 2) {
            this.additional_info_byte = Utils.getBytes(b, off, offset + this.descriptorLength + 2 - off);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("ac4_config_flag", this.ac4_config_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("ac4_toc_flag", this.ac4_toc_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use, null)));
        if (this.ac4_config_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("ac4_dialog_enhancement_enabled", this.ac4_dialog_enhancement_enabled, null)));
            t.add(new DefaultMutableTreeNode(new KVP("ac4_channel_mode", this.ac4_channel_mode, this.ac4_channel_mode_list.get(this.ac4_channel_mode))));
            t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use2, null)));
        }
        if (this.ac4_toc_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("ac4_toc_len", this.ac4_toc_len, null)));
            t.add(new DefaultMutableTreeNode(new KVP("ac4_dsi_byte", this.ac4_dsi_byte, null)));
        }
        if (this.additional_info_byte != null) {
            t.add(new DefaultMutableTreeNode(new KVP("additional_info_byte", this.additional_info_byte, null)));
        }
        return t;
    }
}

