/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class AudioPreselectionDescriptor
extends DVBExtensionDescriptor {
    LookUpList audio_rendering_indication_list = new LookUpList.Builder().add(0, "no preference given for the reproduction channel layout").add(1, "preferred reproduction channel layout is stereo").add(2, "preferred reproduction channel layout is two-dimensional (e.g. 5.1 multi-channel)").add(3, "preferred reproduction channel layout is three-dimensional").add(4, "content is pre-rendered for consumption with headphones").add(5, 7, "reserved for future use").build();
    private int num_preselections;
    private int reserved_zero_future_use;
    private List<Preselection> preselections = new ArrayList<Preselection>();

    public AudioPreselectionDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.num_preselections = Utils.getInt(b, offset + 3, 1, 248) >> 3;
        this.reserved_zero_future_use = Utils.getInt(b, offset + 3, 1, 7);
        BitSource bs = new BitSource(b, offset + 4);
        for (int i = 0; i < this.num_preselections; ++i) {
            this.preselections.add(new Preselection(bs));
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("num_preselections", this.num_preselections, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use, null)));
        Utils.addListJTree(t, this.preselections, modus, "preselections");
        return t;
    }

    public class Preselection
    implements TreeNode {
        private int preselection_id;
        private int audio_rendering_indication;
        private int audio_description;
        private int spoken_subtitles;
        private int dialogue_enhancement;
        private int interactivity_enabled;
        private int language_code_present;
        private int text_label_present;
        private int multi_stream_info_present;
        private int future_extension;
        private String iso639LanguageCode;
        private int message_id;
        private int num_aux_components;
        private int reserved_zero_future_use2;
        private int[] component_tag;
        private int reserved_zero_future_use3;
        private int future_extension_length;
        private byte[] future_extension_byte;

        public Preselection(BitSource bs) {
            this.preselection_id = bs.readBits(5);
            this.audio_rendering_indication = bs.readBits(3);
            this.audio_description = bs.readBits(1);
            this.spoken_subtitles = bs.readBits(1);
            this.dialogue_enhancement = bs.readBits(1);
            this.interactivity_enabled = bs.readBits(1);
            this.language_code_present = bs.readBits(1);
            this.text_label_present = bs.readBits(1);
            this.multi_stream_info_present = bs.readBits(1);
            this.future_extension = bs.readBits(1);
            if (this.language_code_present == 1) {
                byte[] iso_639_language_code_bytes = bs.readBytes(3);
                this.iso639LanguageCode = Utils.getISO8859_1String(iso_639_language_code_bytes, 0, 3);
            }
            if (this.text_label_present == 1) {
                this.message_id = bs.readBits(8);
            }
            if (this.multi_stream_info_present == 1) {
                this.num_aux_components = bs.readBits(3);
                this.reserved_zero_future_use2 = bs.readBits(5);
                this.component_tag = new int[this.num_aux_components];
                for (int j = 0; j < this.num_aux_components; ++j) {
                    this.component_tag[j] = bs.readBits(8);
                }
            }
            if (this.future_extension == 1) {
                this.reserved_zero_future_use3 = bs.readBits(3);
                this.future_extension_length = bs.readBits(5);
                this.future_extension_byte = bs.readBytes(this.future_extension_length);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("preselection"));
            s.add(new DefaultMutableTreeNode(new KVP("preselection_id", this.preselection_id, null)));
            s.add(new DefaultMutableTreeNode(new KVP("audio_rendering_indication", this.audio_rendering_indication, AudioPreselectionDescriptor.this.audio_rendering_indication_list.get(this.audio_rendering_indication, "??"))));
            s.add(new DefaultMutableTreeNode(new KVP("audio_description", this.audio_description, null)));
            s.add(new DefaultMutableTreeNode(new KVP("spoken_subtitles", this.spoken_subtitles, null)));
            s.add(new DefaultMutableTreeNode(new KVP("dialogue_enhancement", this.dialogue_enhancement, null)));
            s.add(new DefaultMutableTreeNode(new KVP("interactivity_enabled", this.interactivity_enabled, null)));
            s.add(new DefaultMutableTreeNode(new KVP("language_code_present", this.language_code_present, null)));
            s.add(new DefaultMutableTreeNode(new KVP("text_label_present", this.text_label_present, null)));
            s.add(new DefaultMutableTreeNode(new KVP("multi_stream_info_present", this.multi_stream_info_present, null)));
            s.add(new DefaultMutableTreeNode(new KVP("future_extension", this.future_extension, null)));
            if (this.language_code_present == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("ISO_639_language_code", this.iso639LanguageCode, null)));
            }
            if (this.text_label_present == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("message_id", this.message_id, null)));
            }
            if (this.multi_stream_info_present == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("num_aux_components", this.num_aux_components, null)));
                s.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use2, null)));
                for (int j = 0; j < this.num_aux_components; ++j) {
                    s.add(new DefaultMutableTreeNode(new KVP("component_tag[" + j + "]", this.component_tag[j], null)));
                }
            }
            if (this.future_extension == 1) {
                s.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use3, null)));
                s.add(new DefaultMutableTreeNode(new KVP("future_extension_length", this.future_extension_length, null)));
                s.add(new DefaultMutableTreeNode(new KVP("future_extension_byte", this.future_extension_byte, null)));
            }
            return s;
        }
    }
}

