/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.Utils;

public class NetworkChangeNotifyDescriptor
extends DVBExtensionDescriptor {
    private List<ChangeDescriptor> descriptors = new ArrayList<ChangeDescriptor>();

    public NetworkChangeNotifyDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        int t = offset + 3;
        while (t < offset + this.descriptorLength) {
            int count;
            ChangeDescriptor d = new ChangeDescriptor(this);
            d.cellId = Utils.getInt(b, t, 2, 65535);
            d.loopLength = count = Utils.getInt(b, t + 2, 1, 255);
            int outerByteCount = t += 3;
            while (t - outerByteCount < count) {
                Change c = new Change(this);
                c.changeId = Utils.getInt(b, t, 1, 255);
                c.changeVersion = Utils.getInt(b, t + 1, 1, 255);
                c.startTime = Utils.getBytes(b, t + 2, 5);
                c.duration = Utils.getBCD(b, (t + 7) * 2, 6);
                c.receiverCategory = Utils.getInt(b, t + 10, 1, 224) >> 5;
                c.invariantTsPresent = Utils.getInt(b, t + 10, 1, 16) >> 4;
                c.changeType = Utils.getInt(b, t + 10, 1, 15);
                c.messageId = Utils.getInt(b, t + 11, 1, 255);
                t += 12;
                if (c.invariantTsPresent == 1) {
                    c.invariantTsTsId = Utils.getInt(b, t, 2, 65535);
                    c.invariantTsOnId = Utils.getInt(b, t + 2, 2, 65535);
                    t += 4;
                }
                d.changes.add(c);
            }
            this.descriptors.add(d);
            t = outerByteCount + count;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        Utils.addListJTree(t, this.descriptors, modus, "networkChanges");
        return t;
    }

    private class ChangeDescriptor
    implements TreeNode {
        public int cellId;
        public int loopLength;
        List<Change> changes = new ArrayList<Change>();

        private ChangeDescriptor(NetworkChangeNotifyDescriptor networkChangeNotifyDescriptor) {
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(new KVP("change_descriptor"));
            tn.add(new DefaultMutableTreeNode(new KVP("cell_id", this.cellId, null)));
            tn.add(new DefaultMutableTreeNode(new KVP("loop_length", this.loopLength, null)));
            Utils.addListJTree(tn, this.changes, modus, "changes");
            return tn;
        }
    }

    private class Change
    implements TreeNode {
        public int changeId;
        public int changeVersion;
        public byte[] startTime;
        public String duration;
        public int receiverCategory;
        public int invariantTsPresent;
        public int changeType;
        public int messageId;
        public int invariantTsTsId;
        public int invariantTsOnId;

        private Change(NetworkChangeNotifyDescriptor networkChangeNotifyDescriptor) {
        }

        private String receiverCategoryToString(int receiverCategory) {
            switch (receiverCategory) {
                case 0: {
                    return "All receivers";
                }
                case 1: {
                    return "DVB-T2 or DVB-S2 or DVB-C2 capable receivers only";
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return "Reserved for future use";
                }
            }
            return "Invalid - outside range 0x0 to 0x7";
        }

        private String changeTypeToString(int changeType) {
            switch (changeType) {
                case 0: {
                    return "Message only";
                }
                case 1: {
                    return "Minor - default";
                }
                case 2: {
                    return "Minor - multiplex removed";
                }
                case 3: {
                    return "Minor - service changed";
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return "Reserved - Other minor changes";
                }
                case 8: {
                    return "Major - Default";
                }
                case 9: {
                    return "Major - multiplex frequency changed";
                }
                case 10: {
                    return "Major - multiplex coverage changed";
                }
                case 11: {
                    return "Major - multiplex added";
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return "reserved for future use for other major changes";
                }
            }
            return "Invalid Value - greater than 0xF";
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(new KVP("change"));
            tn.add(new DefaultMutableTreeNode(new KVP("network_change_id", this.changeId, null)));
            tn.add(new DefaultMutableTreeNode(new KVP("network_change_version", this.changeVersion, null)));
            tn.add(new DefaultMutableTreeNode(new KVP("start_time_of_change", this.startTime, Utils.getUTCFormattedString(this.startTime))));
            tn.add(new DefaultMutableTreeNode(new KVP("change_duration", this.duration, Utils.formatDuration(this.duration))));
            tn.add(new DefaultMutableTreeNode(new KVP("receiver_category", this.receiverCategory, this.receiverCategoryToString(this.receiverCategory))));
            tn.add(new DefaultMutableTreeNode(new KVP("invariant_ts_present", this.invariantTsPresent, null)));
            tn.add(new DefaultMutableTreeNode(new KVP("change_type", this.changeType, this.changeTypeToString(this.changeType))));
            tn.add(new DefaultMutableTreeNode(new KVP("message_id", this.messageId, null)));
            if (this.invariantTsPresent == 1) {
                tn.add(new DefaultMutableTreeNode(new KVP("invariant_ts_tsid ", this.invariantTsTsId, null)));
                tn.add(new DefaultMutableTreeNode(new KVP("invariant_ts_onid ", this.invariantTsOnId, null)));
            }
            return tn;
        }
    }
}

