/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class SHDeliverySystemDescriptor
extends DVBExtensionDescriptor {
    private final int diversity_mode;
    private final int reserved;
    private List<Modulation> modulations = new ArrayList<Modulation>();

    public SHDeliverySystemDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, offset, parent);
        this.diversity_mode = Utils.getInt(b, offset + 3, 1, 240) >> 4;
        this.reserved = Utils.getInt(b, offset + 3, 1, 15);
        BitSource bs = new BitSource(this.selector_byte, 1);
        while (bs.available() > 0) {
            Modulation modulation = new Modulation(this, bs);
            this.modulations.add(modulation);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("diversity_mode", this.diversity_mode, SHDeliverySystemDescriptor.getDiversityModeDescription(this.diversity_mode))));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        Utils.addListJTree(t, this.modulations, modus, "modulations");
        return t;
    }

    private static String getDiversityModeDescription(int diversity_mode) {
        switch (diversity_mode) {
            case 0: {
                return "paTS:no, FEC diversity:no, FEC at phy:no, FEC at link:no";
            }
            case 8: {
                return "paTS:yes, FEC diversity:no, FEC at phy:no, FEC at link:no";
            }
            case 13: {
                return "paTS:yes, FEC diversity:yes, FEC at phy:no, FEC at link:yes";
            }
            case 14: {
                return "paTS:yes, FEC diversity:yes, FEC at phy:yes, FEC at link:no";
            }
            case 15: {
                return "paTS:yes, FEC diversity:yes, FEC at phy:yes, FEC at link:yes";
            }
        }
        return "reserved for future use";
    }

    public class Modulation
    implements TreeNode {
        private int modulation_type;
        private int interleaver_presence;
        private int interleaver_type;
        private int reserved;
        private int polarization;
        private int roll_off;
        private int modulation_mode;
        private int code_rate;
        private int symbol_rate;
        private int reserved2;
        private int bandwidth;
        private int priority;
        private int constellation_and_hierarchy;
        private int guard_interval;
        private int transmission_mode;
        private int common_frequency;
        private int common_multiplier;
        private int nof_late_taps;
        private int nof_slices;
        private int slice_distance;
        private int non_late_increments;
        private int reserved3;

        public Modulation(SHDeliverySystemDescriptor this$0, BitSource bs) {
            this.modulation_type = bs.readBits(1);
            this.interleaver_presence = bs.readBits(1);
            this.interleaver_type = bs.readBits(1);
            this.reserved = bs.readBits(5);
            if (this.modulation_type == 0) {
                this.polarization = bs.readBits(2);
                this.roll_off = bs.readBits(2);
                this.modulation_mode = bs.readBits(2);
                this.code_rate = bs.readBits(4);
                this.symbol_rate = bs.readBits(5);
                this.reserved2 = bs.readBits(1);
            } else {
                this.bandwidth = bs.readBits(3);
                this.priority = bs.readBits(1);
                this.constellation_and_hierarchy = bs.readBits(3);
                this.code_rate = bs.readBits(4);
                this.guard_interval = bs.readBits(2);
                this.transmission_mode = bs.readBits(2);
                this.common_frequency = bs.readBits(1);
            }
            if (this.interleaver_presence == 1) {
                if (this.interleaver_type == 0) {
                    this.common_multiplier = bs.readBits(6);
                    this.nof_late_taps = bs.readBits(6);
                    this.nof_slices = bs.readBits(6);
                    this.slice_distance = bs.readBits(8);
                    this.non_late_increments = bs.readBits(6);
                } else {
                    this.common_multiplier = bs.readBits(6);
                    this.reserved3 = bs.readBits(2);
                }
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Modulation"));
            t.add(new DefaultMutableTreeNode(new KVP("modulation_type", this.modulation_type, this.modulation_type == 0 ? "TDM" : "OFDM")));
            t.add(new DefaultMutableTreeNode(new KVP("interleaver_presence", this.interleaver_presence, this.interleaver_presence == 0 ? "no interleaver info follows" : "an interleaver info follows")));
            t.add(new DefaultMutableTreeNode(new KVP("interleaver_type", this.interleaver_type, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            if (this.modulation_type == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("polarization", this.polarization, null)));
                t.add(new DefaultMutableTreeNode(new KVP("roll_off", this.roll_off, null)));
                t.add(new DefaultMutableTreeNode(new KVP("modulation_mode", this.modulation_mode, null)));
                t.add(new DefaultMutableTreeNode(new KVP("code_rate", this.code_rate, null)));
                t.add(new DefaultMutableTreeNode(new KVP("symbol_rate", this.symbol_rate, null)));
                t.add(new DefaultMutableTreeNode(new KVP("reserved2", this.reserved2, null)));
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("bandwidth", this.bandwidth, null)));
                t.add(new DefaultMutableTreeNode(new KVP("priority", this.priority, null)));
                t.add(new DefaultMutableTreeNode(new KVP("constellation_and_hierarchy", this.constellation_and_hierarchy, null)));
                t.add(new DefaultMutableTreeNode(new KVP("code_rate", this.code_rate, null)));
                t.add(new DefaultMutableTreeNode(new KVP("guard_interval", this.guard_interval, null)));
                t.add(new DefaultMutableTreeNode(new KVP("transmission_mode", this.transmission_mode, null)));
                t.add(new DefaultMutableTreeNode(new KVP("common_frequency", this.common_frequency, null)));
            }
            if (this.interleaver_presence == 1) {
                if (this.interleaver_type == 0) {
                    t.add(new DefaultMutableTreeNode(new KVP("common_multiplier", this.common_multiplier, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("nof_late_taps", this.nof_late_taps, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("nof_slices", this.nof_slices, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("slice_distance", this.slice_distance, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("non_late_increments", this.non_late_increments, null)));
                } else {
                    t.add(new DefaultMutableTreeNode(new KVP("common_multiplier", this.common_multiplier, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("reserved3", this.reserved3, null)));
                }
            }
            return t;
        }
    }
}

