/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb.DVBExtensionDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class URILinkageDescriptor
extends DVBExtensionDescriptor {
    private static LookUpList uri_linkage_type_list = new LookUpList.Builder().add(0, "Online SDT (OSDT) for CI Plus").add(1, "DVB-IPTV SD&S").add(2, "Material Resolution Server (MRS) for companion screen applications").add(3, "DVB-I").add(4, 127, "Reserved for future use").add(128, 255, "User defined").build();
    private static LookUpList dvb_i_endpoint_type_list = new LookUpList.Builder().add(0, "Not used").add(1, "DVB-I Service List").add(2, "Service List Registry query").add(3, "Named DVB-I Service List").add(4, 255, "Reserved for future use").build();
    private final int uri_linkage_type;
    private final int uri_length;
    private String uri_char = "";
    private int min_polling_interval;
    private byte[] private_data_byte = null;
    private int dvb_i_endpoint_type = 0;
    private int dvb_i_service_list_name_length = 0;
    private String dvb_i_service_list_name = "";
    private int dvb_i_service_list_provider_name_length = 0;
    private String dvb_i_service_list_provider_name = "";

    public URILinkageDescriptor(byte[] b, int offset, TableSection parent) {
        super(b, parent);
        byte[] payload = Utils.getBytes(b, 3, this.descriptorLength - 1);
        int localOffset = 0;
        this.uri_linkage_type = Utils.getInt(payload, localOffset++, 1, 255);
        this.uri_length = Utils.getInt(payload, localOffset++, 1, 255);
        this.uri_char = Utils.getString(payload, localOffset, this.uri_length);
        localOffset += this.uri_length;
        if (this.uri_linkage_type == 0 || this.uri_linkage_type == 1) {
            this.min_polling_interval = Utils.getInt(payload, localOffset, 2, 65535);
            localOffset += 2;
        } else if (this.uri_linkage_type == 3) {
            this.dvb_i_endpoint_type = Utils.getInt(payload, localOffset++, 1, 255);
            if (this.dvb_i_endpoint_type == 3) {
                this.dvb_i_service_list_name_length = Utils.getInt(payload, localOffset++, 1, 255);
                this.dvb_i_service_list_name = Utils.getString(payload, localOffset, this.dvb_i_service_list_name_length);
                localOffset += this.dvb_i_service_list_name_length;
                this.dvb_i_service_list_provider_name_length = Utils.getInt(payload, localOffset++, 1, 255);
                this.dvb_i_service_list_provider_name = Utils.getString(payload, localOffset, this.dvb_i_service_list_provider_name_length);
                localOffset += this.dvb_i_service_list_provider_name_length;
            }
        }
        if (localOffset < payload.length) {
            this.private_data_byte = Arrays.copyOfRange(payload, localOffset, payload.length);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new KVP("uri_linkage_type", this.uri_linkage_type).setDescription(URILinkageDescriptor.getURILinkageTypeString(this.uri_linkage_type)));
        t.add(new KVP("uri_length", this.uri_length));
        t.add(new KVP("uri_char", this.uri_char));
        if (this.uri_linkage_type == 0 || this.uri_linkage_type == 1) {
            t.add(new KVP("min_polling_interval", this.min_polling_interval));
        }
        if (this.uri_linkage_type == 3) {
            t.add(new KVP("dvb-i end_point_type", this.dvb_i_endpoint_type).setDescription(URILinkageDescriptor.getDVBIEndpointType(this.dvb_i_endpoint_type)));
            if (this.dvb_i_endpoint_type == 3) {
                t.add(new KVP("dvb-i service_list_name", this.dvb_i_service_list_name));
                t.add(new KVP("dvb-i service_list_provider_name", this.dvb_i_service_list_provider_name));
            }
        }
        if (this.private_data_byte != null) {
            t.add(new KVP("private_data_byte", this.private_data_byte));
        }
        return t;
    }

    private static String getURILinkageTypeString(int uri_linkage_type) {
        return uri_linkage_type_list.get(uri_linkage_type);
    }

    private static String getDVBIEndpointType(int dvb_i_endpoint_type) {
        return dvb_i_endpoint_type_list.get(dvb_i_endpoint_type);
    }
}

